<?php

namespace EnumType;

/**
 * This class stands for Item_Fields EnumType
 * @subpackage Enumerations
 */
class Item_Fields
{
    /**
     * Constant for value 'No'
     * @return string 'No'
     */
    const VALUE_NO = 'No';
    /**
     * Constant for value 'External_Vendor_Item_No'
     * @return string 'External_Vendor_Item_No'
     */
    const VALUE_EXTERNAL_VENDOR_ITEM_NO = 'External_Vendor_Item_No';
    /**
     * Constant for value 'Last_Modified_DateTime'
     * @return string 'Last_Modified_DateTime'
     */
    const VALUE_LAST_MODIFIED_DATE_TIME = 'Last_Modified_DateTime';
    /**
     * Constant for value 'Creation_DateTime'
     * @return string 'Creation_DateTime'
     */
    const VALUE_CREATION_DATE_TIME = 'Creation_DateTime';
    /**
     * Constant for value 'Description'
     * @return string 'Description'
     */
    const VALUE_DESCRIPTION = 'Description';
    /**
     * Constant for value 'Description_2'
     * @return string 'Description_2'
     */
    const VALUE_DESCRIPTION_2 = 'Description_2';
    /**
     * Constant for value 'Color'
     * @return string 'Color'
     */
    const VALUE_COLOR = 'Color';
    /**
     * Constant for value 'Base_Unit_of_Measure'
     * @return string 'Base_Unit_of_Measure'
     */
    const VALUE_BASE_UNIT_OF_MEASURE = 'Base_Unit_of_Measure';
    /**
     * Constant for value 'Purchase_Price'
     * @return string 'Purchase_Price'
     */
    const VALUE_PURCHASE_PRICE = 'Purchase_Price';
    /**
     * Constant for value 'List_Price'
     * @return string 'List_Price'
     */
    const VALUE_LIST_PRICE = 'List_Price';
    /**
     * Constant for value 'Unit_Price'
     * @return string 'Unit_Price'
     */
    const VALUE_UNIT_PRICE = 'Unit_Price';
    /**
     * Constant for value 'VAT_Rate'
     * @return string 'VAT_Rate'
     */
    const VALUE_VAT_RATE = 'VAT_Rate';
    /**
     * Constant for value 'Creation_Date'
     * @return string 'Creation_Date'
     */
    const VALUE_CREATION_DATE = 'Creation_Date';
    /**
     * Constant for value 'Product_Group_Code'
     * @return string 'Product_Group_Code'
     */
    const VALUE_PRODUCT_GROUP_CODE = 'Product_Group_Code';
    /**
     * Constant for value 'Product_Group_Description'
     * @return string 'Product_Group_Description'
     */
    const VALUE_PRODUCT_GROUP_DESCRIPTION = 'Product_Group_Description';
    /**
     * Constant for value 'Brand_Code'
     * @return string 'Brand_Code'
     */
    const VALUE_BRAND_CODE = 'Brand_Code';
    /**
     * Constant for value 'Brand_Description'
     * @return string 'Brand_Description'
     */
    const VALUE_BRAND_DESCRIPTION = 'Brand_Description';
    /**
     * Constant for value 'Season_Code'
     * @return string 'Season_Code'
     */
    const VALUE_SEASON_CODE = 'Season_Code';
    /**
     * Constant for value 'Season_Description'
     * @return string 'Season_Description'
     */
    const VALUE_SEASON_DESCRIPTION = 'Season_Description';
    /**
     * Constant for value 'Season_Year_Code'
     * @return string 'Season_Year_Code'
     */
    const VALUE_SEASON_YEAR_CODE = 'Season_Year_Code';
    /**
     * Constant for value 'Season_Year_Description'
     * @return string 'Season_Year_Description'
     */
    const VALUE_SEASON_YEAR_DESCRIPTION = 'Season_Year_Description';
    /**
     * Constant for value 'Gender_Code'
     * @return string 'Gender_Code'
     */
    const VALUE_GENDER_CODE = 'Gender_Code';
    /**
     * Constant for value 'Gender_Description'
     * @return string 'Gender_Description'
     */
    const VALUE_GENDER_DESCRIPTION = 'Gender_Description';
    /**
     * Constant for value 'Blocked'
     * @return string 'Blocked'
     */
    const VALUE_BLOCKED = 'Blocked';
    /**
     * Constant for value 'Active_In_E_Com_System'
     * @return string 'Active_In_E_Com_System'
     */
    const VALUE_ACTIVE_IN_E_COM_SYSTEM = 'Active_In_E_Com_System';
    /**
     * Constant for value 'Vendor_No'
     * @return string 'Vendor_No'
     */
    const VALUE_VENDOR_NO = 'Vendor_No';
    /**
     * Constant for value 'VendorName'
     * @return string 'VendorName'
     */
    const VALUE_VENDOR_NAME = 'VendorName';
    /**
     * Constant for value 'Item_Barcode'
     * @return string 'Item_Barcode'
     */
    const VALUE_ITEM_BARCODE = 'Item_Barcode';
    /**
     * Constant for value 'Item_Material'
     * @return string 'Item_Material'
     */
    const VALUE_ITEM_MATERIAL = 'Item_Material';
    /**
     * Constant for value 'Item_Detail'
     * @return string 'Item_Detail'
     */
    const VALUE_ITEM_DETAIL = 'Item_Detail';
    /**
     * Constant for value 'Current_E_Com_Sales_Type'
     * @return string 'Current_E_Com_Sales_Type'
     */
    const VALUE_CURRENT_E_COM_SALES_TYPE = 'Current_E_Com_Sales_Type';
    /**
     * Constant for value 'Current_E_Com_Campaign_Code'
     * @return string 'Current_E_Com_Campaign_Code'
     */
    const VALUE_CURRENT_E_COM_CAMPAIGN_CODE = 'Current_E_Com_Campaign_Code';
    /**
     * Constant for value '_x003C_Item_Material_2_x003E_'
     * @return string '_x003C_Item_Material_2_x003E_'
     */
    const VALUE_X_003_C_ITEM_MATERIAL_2_X_003_E = '_x003C_Item_Material_2_x003E_';
    /**
     * Constant for value '_x003C_Item_Material_3_x003E_'
     * @return string '_x003C_Item_Material_3_x003E_'
     */
    const VALUE_X_003_C_ITEM_MATERIAL_3_X_003_E = '_x003C_Item_Material_3_x003E_';
    /**
     * Constant for value '_x003C_Item_Material_4_x003E_'
     * @return string '_x003C_Item_Material_4_x003E_'
     */
    const VALUE_X_003_C_ITEM_MATERIAL_4_X_003_E = '_x003C_Item_Material_4_x003E_';
    /**
     * Constant for value 'Description_3'
     * @return string 'Description_3'
     */
    const VALUE_DESCRIPTION_3 = 'Description_3';
    /**
     * Constant for value '_Purchaser_Code'
     * @return string '_Purchaser_Code'
     */
    const VALUE_PURCHASER_CODE = '_Purchaser_Code';
    /**
     * Constant for value 'Vendor_Real_Item_No'
     * @return string 'Vendor_Real_Item_No'
     */
    const VALUE_VENDOR_REAL_ITEM_NO = 'Vendor_Real_Item_No';
    /**
     * Constant for value 'Vendor_Real_Barcode'
     * @return string 'Vendor_Real_Barcode'
     */
    const VALUE_VENDOR_REAL_BARCODE = 'Vendor_Real_Barcode';
    /**
     * Constant for value 'Vendor_XML_Barcode'
     * @return string 'Vendor_XML_Barcode'
     */
    const VALUE_VENDOR_XML_BARCODE = 'Vendor_XML_Barcode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO
     * @uses self::VALUE_EXTERNAL_VENDOR_ITEM_NO
     * @uses self::VALUE_LAST_MODIFIED_DATE_TIME
     * @uses self::VALUE_CREATION_DATE_TIME
     * @uses self::VALUE_DESCRIPTION
     * @uses self::VALUE_DESCRIPTION_2
     * @uses self::VALUE_COLOR
     * @uses self::VALUE_BASE_UNIT_OF_MEASURE
     * @uses self::VALUE_PURCHASE_PRICE
     * @uses self::VALUE_LIST_PRICE
     * @uses self::VALUE_UNIT_PRICE
     * @uses self::VALUE_VAT_RATE
     * @uses self::VALUE_CREATION_DATE
     * @uses self::VALUE_PRODUCT_GROUP_CODE
     * @uses self::VALUE_PRODUCT_GROUP_DESCRIPTION
     * @uses self::VALUE_BRAND_CODE
     * @uses self::VALUE_BRAND_DESCRIPTION
     * @uses self::VALUE_SEASON_CODE
     * @uses self::VALUE_SEASON_DESCRIPTION
     * @uses self::VALUE_SEASON_YEAR_CODE
     * @uses self::VALUE_SEASON_YEAR_DESCRIPTION
     * @uses self::VALUE_GENDER_CODE
     * @uses self::VALUE_GENDER_DESCRIPTION
     * @uses self::VALUE_BLOCKED
     * @uses self::VALUE_ACTIVE_IN_E_COM_SYSTEM
     * @uses self::VALUE_VENDOR_NO
     * @uses self::VALUE_VENDOR_NAME
     * @uses self::VALUE_ITEM_BARCODE
     * @uses self::VALUE_ITEM_MATERIAL
     * @uses self::VALUE_ITEM_DETAIL
     * @uses self::VALUE_CURRENT_E_COM_SALES_TYPE
     * @uses self::VALUE_CURRENT_E_COM_CAMPAIGN_CODE
     * @uses self::VALUE_X_003_C_ITEM_MATERIAL_2_X_003_E
     * @uses self::VALUE_X_003_C_ITEM_MATERIAL_3_X_003_E
     * @uses self::VALUE_X_003_C_ITEM_MATERIAL_4_X_003_E
     * @uses self::VALUE_DESCRIPTION_3
     * @uses self::VALUE_PURCHASER_CODE
     * @uses self::VALUE_VENDOR_REAL_ITEM_NO
     * @uses self::VALUE_VENDOR_REAL_BARCODE
     * @uses self::VALUE_VENDOR_XML_BARCODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO,
            self::VALUE_EXTERNAL_VENDOR_ITEM_NO,
            self::VALUE_LAST_MODIFIED_DATE_TIME,
            self::VALUE_CREATION_DATE_TIME,
            self::VALUE_DESCRIPTION,
            self::VALUE_DESCRIPTION_2,
            self::VALUE_COLOR,
            self::VALUE_BASE_UNIT_OF_MEASURE,
            self::VALUE_PURCHASE_PRICE,
            self::VALUE_LIST_PRICE,
            self::VALUE_UNIT_PRICE,
            self::VALUE_VAT_RATE,
            self::VALUE_CREATION_DATE,
            self::VALUE_PRODUCT_GROUP_CODE,
            self::VALUE_PRODUCT_GROUP_DESCRIPTION,
            self::VALUE_BRAND_CODE,
            self::VALUE_BRAND_DESCRIPTION,
            self::VALUE_SEASON_CODE,
            self::VALUE_SEASON_DESCRIPTION,
            self::VALUE_SEASON_YEAR_CODE,
            self::VALUE_SEASON_YEAR_DESCRIPTION,
            self::VALUE_GENDER_CODE,
            self::VALUE_GENDER_DESCRIPTION,
            self::VALUE_BLOCKED,
            self::VALUE_ACTIVE_IN_E_COM_SYSTEM,
            self::VALUE_VENDOR_NO,
            self::VALUE_VENDOR_NAME,
            self::VALUE_ITEM_BARCODE,
            self::VALUE_ITEM_MATERIAL,
            self::VALUE_ITEM_DETAIL,
            self::VALUE_CURRENT_E_COM_SALES_TYPE,
            self::VALUE_CURRENT_E_COM_CAMPAIGN_CODE,
            self::VALUE_X_003_C_ITEM_MATERIAL_2_X_003_E,
            self::VALUE_X_003_C_ITEM_MATERIAL_3_X_003_E,
            self::VALUE_X_003_C_ITEM_MATERIAL_4_X_003_E,
            self::VALUE_DESCRIPTION_3,
            self::VALUE_PURCHASER_CODE,
            self::VALUE_VENDOR_REAL_ITEM_NO,
            self::VALUE_VENDOR_REAL_BARCODE,
            self::VALUE_VENDOR_XML_BARCODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
