<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The carrier
     * @var string
     */
    public $carrier;
    /**
     * The carrier_id
     * @var float
     */
    public $carrier_id;
    /**
     * The carrier_label
     * @var string
     */
    public $carrier_label;
    /**
     * The rate
     * @var float
     */
    public $rate;
    /**
     * The rate_id
     * @var string
     */
    public $rate_id;
    /**
     * The order_id
     * @var string
     */
    public $order_id;
    /**
     * The delivery_days
     * @var string
     */
    public $delivery_days;
    /**
     * The service
     * @var string
     */
    public $service;
    /**
     * Constructor method for Rate
     * @uses Rate::setCarrier()
     * @uses Rate::setCarrier_id()
     * @uses Rate::setCarrier_label()
     * @uses Rate::setRate()
     * @uses Rate::setRate_id()
     * @uses Rate::setOrder_id()
     * @uses Rate::setDelivery_days()
     * @uses Rate::setService()
     * @param string $carrier
     * @param float $carrier_id
     * @param string $carrier_label
     * @param float $rate
     * @param string $rate_id
     * @param string $order_id
     * @param string $delivery_days
     * @param string $service
     */
    public function __construct($carrier = null, $carrier_id = null, $carrier_label = null, $rate = null, $rate_id = null, $order_id = null, $delivery_days = null, $service = null)
    {
        $this
            ->setCarrier($carrier)
            ->setCarrier_id($carrier_id)
            ->setCarrier_label($carrier_label)
            ->setRate($rate)
            ->setRate_id($rate_id)
            ->setOrder_id($order_id)
            ->setDelivery_days($delivery_days)
            ->setService($service);
    }
    /**
     * Get carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @param string $carrier
     * @return \shippypro\StructType\Rate
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get carrier_id value
     * @return float|null
     */
    public function getCarrier_id()
    {
        return $this->carrier_id;
    }
    /**
     * Set carrier_id value
     * @param float $carrier_id
     * @return \shippypro\StructType\Rate
     */
    public function setCarrier_id($carrier_id = null)
    {
        // validation for constraint: float
        if (!is_null($carrier_id) && !(is_float($carrier_id) || is_numeric($carrier_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrier_id, true), gettype($carrier_id)), __LINE__);
        }
        $this->carrier_id = $carrier_id;
        return $this;
    }
    /**
     * Get carrier_label value
     * @return string|null
     */
    public function getCarrier_label()
    {
        return $this->carrier_label;
    }
    /**
     * Set carrier_label value
     * @param string $carrier_label
     * @return \shippypro\StructType\Rate
     */
    public function setCarrier_label($carrier_label = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_label) && !is_string($carrier_label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_label, true), gettype($carrier_label)), __LINE__);
        }
        $this->carrier_label = $carrier_label;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \shippypro\StructType\Rate
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get rate_id value
     * @return string|null
     */
    public function getRate_id()
    {
        return $this->rate_id;
    }
    /**
     * Set rate_id value
     * @param string $rate_id
     * @return \shippypro\StructType\Rate
     */
    public function setRate_id($rate_id = null)
    {
        // validation for constraint: string
        if (!is_null($rate_id) && !is_string($rate_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate_id, true), gettype($rate_id)), __LINE__);
        }
        $this->rate_id = $rate_id;
        return $this;
    }
    /**
     * Get order_id value
     * @return string|null
     */
    public function getOrder_id()
    {
        return $this->order_id;
    }
    /**
     * Set order_id value
     * @param string $order_id
     * @return \shippypro\StructType\Rate
     */
    public function setOrder_id($order_id = null)
    {
        // validation for constraint: string
        if (!is_null($order_id) && !is_string($order_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order_id, true), gettype($order_id)), __LINE__);
        }
        $this->order_id = $order_id;
        return $this;
    }
    /**
     * Get delivery_days value
     * @return string|null
     */
    public function getDelivery_days()
    {
        return $this->delivery_days;
    }
    /**
     * Set delivery_days value
     * @param string $delivery_days
     * @return \shippypro\StructType\Rate
     */
    public function setDelivery_days($delivery_days = null)
    {
        // validation for constraint: string
        if (!is_null($delivery_days) && !is_string($delivery_days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery_days, true), gettype($delivery_days)), __LINE__);
        }
        $this->delivery_days = $delivery_days;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \shippypro\StructType\Rate
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
}
