<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderResponse StructType
 * @subpackage Structs
 */
class GetOrderResponse extends AbstractStructBase
{
    /**
     * The Result
     * @var string
     */
    public $Result;
    /**
     * The OrderID
     * @var float
     */
    public $OrderID;
    /**
     * The TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The CarrierID
     * @var float
     */
    public $CarrierID;
    /**
     * The TrackingCarrier
     * @var string
     */
    public $TrackingCarrier;
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ReturnTrackingNumber
     * @var string
     */
    public $ReturnTrackingNumber;
    /**
     * The MarketplacePlatform
     * @var string
     */
    public $MarketplacePlatform;
    /**
     * The Status
     * @var float
     */
    public $Status;
    /**
     * The LabelURL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $LabelURL;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * Constructor method for GetOrderResponse
     * @uses GetOrderResponse::setResult()
     * @uses GetOrderResponse::setOrderID()
     * @uses GetOrderResponse::setTransactionID()
     * @uses GetOrderResponse::setCarrierID()
     * @uses GetOrderResponse::setTrackingCarrier()
     * @uses GetOrderResponse::setTrackingNumber()
     * @uses GetOrderResponse::setReturnTrackingNumber()
     * @uses GetOrderResponse::setMarketplacePlatform()
     * @uses GetOrderResponse::setStatus()
     * @uses GetOrderResponse::setLabelURL()
     * @uses GetOrderResponse::setErrorMessage()
     * @uses GetOrderResponse::setError()
     * @param string $result
     * @param float $orderID
     * @param string $transactionID
     * @param float $carrierID
     * @param string $trackingCarrier
     * @param string $trackingNumber
     * @param string $returnTrackingNumber
     * @param string $marketplacePlatform
     * @param float $status
     * @param string[] $labelURL
     * @param string $errorMessage
     * @param string $error
     */
    public function __construct($result = null, $orderID = null, $transactionID = null, $carrierID = null, $trackingCarrier = null, $trackingNumber = null, $returnTrackingNumber = null, $marketplacePlatform = null, $status = null, array $labelURL = array(), $errorMessage = null, $error = null)
    {
        $this
            ->setResult($result)
            ->setOrderID($orderID)
            ->setTransactionID($transactionID)
            ->setCarrierID($carrierID)
            ->setTrackingCarrier($trackingCarrier)
            ->setTrackingNumber($trackingNumber)
            ->setReturnTrackingNumber($returnTrackingNumber)
            ->setMarketplacePlatform($marketplacePlatform)
            ->setStatus($status)
            ->setLabelURL($labelURL)
            ->setErrorMessage($errorMessage)
            ->setError($error);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get OrderID value
     * @return float|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param float $orderID
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: float
        if (!is_null($orderID) && !(is_float($orderID) || is_numeric($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return float|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param float $carrierID
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: float
        if (!is_null($carrierID) && !(is_float($carrierID) || is_numeric($carrierID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get TrackingCarrier value
     * @return string|null
     */
    public function getTrackingCarrier()
    {
        return $this->TrackingCarrier;
    }
    /**
     * Set TrackingCarrier value
     * @param string $trackingCarrier
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setTrackingCarrier($trackingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($trackingCarrier) && !is_string($trackingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingCarrier, true), gettype($trackingCarrier)), __LINE__);
        }
        $this->TrackingCarrier = $trackingCarrier;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ReturnTrackingNumber value
     * @return string|null
     */
    public function getReturnTrackingNumber()
    {
        return $this->ReturnTrackingNumber;
    }
    /**
     * Set ReturnTrackingNumber value
     * @param string $returnTrackingNumber
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setReturnTrackingNumber($returnTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnTrackingNumber) && !is_string($returnTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnTrackingNumber, true), gettype($returnTrackingNumber)), __LINE__);
        }
        $this->ReturnTrackingNumber = $returnTrackingNumber;
        return $this;
    }
    /**
     * Get MarketplacePlatform value
     * @return string|null
     */
    public function getMarketplacePlatform()
    {
        return $this->MarketplacePlatform;
    }
    /**
     * Set MarketplacePlatform value
     * @param string $marketplacePlatform
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setMarketplacePlatform($marketplacePlatform = null)
    {
        // validation for constraint: string
        if (!is_null($marketplacePlatform) && !is_string($marketplacePlatform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketplacePlatform, true), gettype($marketplacePlatform)), __LINE__);
        }
        $this->MarketplacePlatform = $marketplacePlatform;
        return $this;
    }
    /**
     * Get Status value
     * @return float|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param float $status
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LabelURL value
     * @return string[]|null
     */
    public function getLabelURL()
    {
        return $this->LabelURL;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelURLForArrayConstraintsFromSetLabelURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getOrderResponseLabelURLItem) {
            // validation for constraint: itemType
            if (!is_string($getOrderResponseLabelURLItem)) {
                $invalidValues[] = is_object($getOrderResponseLabelURLItem) ? get_class($getOrderResponseLabelURLItem) : sprintf('%s(%s)', gettype($getOrderResponseLabelURLItem), var_export($getOrderResponseLabelURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelURL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelURL value
     * @throws \InvalidArgumentException
     * @param string[] $labelURL
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setLabelURL(array $labelURL = array())
    {
        // validation for constraint: array
        if ('' !== ($labelURLArrayErrorMessage = self::validateLabelURLForArrayConstraintsFromSetLabelURL($labelURL))) {
            throw new \InvalidArgumentException($labelURLArrayErrorMessage, __LINE__);
        }
        $this->LabelURL = $labelURL;
        return $this;
    }
    /**
     * Add item to LabelURL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function addToLabelURL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The LabelURL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LabelURL[] = $item;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \shippypro\StructType\GetOrderResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
