<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelUrlResponse StructType
 * @subpackage Structs
 */
class GetLabelUrlResponse extends AbstractStructBase
{
    /**
     * The LabelURL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $LabelURL;
    /**
     * The PDF
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $PDF;
    /**
     * The ZPL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ZPL;
    /**
     * The TrackingCarrier
     * @var string
     */
    public $TrackingCarrier;
    /**
     * The TrackingNumber
     * @var string
     */
    public $TrackingNumber;
    /**
     * The ReturnTrackingNumber
     * @var string
     */
    public $ReturnTrackingNumber;
    /**
     * The Status
     * @var float
     */
    public $Status;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * Constructor method for GetLabelUrlResponse
     * @uses GetLabelUrlResponse::setLabelURL()
     * @uses GetLabelUrlResponse::setPDF()
     * @uses GetLabelUrlResponse::setZPL()
     * @uses GetLabelUrlResponse::setTrackingCarrier()
     * @uses GetLabelUrlResponse::setTrackingNumber()
     * @uses GetLabelUrlResponse::setReturnTrackingNumber()
     * @uses GetLabelUrlResponse::setStatus()
     * @uses GetLabelUrlResponse::setErrorMessage()
     * @uses GetLabelUrlResponse::setError()
     * @param string[] $labelURL
     * @param string[] $pDF
     * @param string[] $zPL
     * @param string $trackingCarrier
     * @param string $trackingNumber
     * @param string $returnTrackingNumber
     * @param float $status
     * @param string $errorMessage
     * @param string $error
     */
    public function __construct(array $labelURL = array(), array $pDF = array(), array $zPL = array(), $trackingCarrier = null, $trackingNumber = null, $returnTrackingNumber = null, $status = null, $errorMessage = null, $error = null)
    {
        $this
            ->setLabelURL($labelURL)
            ->setPDF($pDF)
            ->setZPL($zPL)
            ->setTrackingCarrier($trackingCarrier)
            ->setTrackingNumber($trackingNumber)
            ->setReturnTrackingNumber($returnTrackingNumber)
            ->setStatus($status)
            ->setErrorMessage($errorMessage)
            ->setError($error);
    }
    /**
     * Get LabelURL value
     * @return string[]|null
     */
    public function getLabelURL()
    {
        return $this->LabelURL;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelURLForArrayConstraintsFromSetLabelURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelUrlResponseLabelURLItem) {
            // validation for constraint: itemType
            if (!is_string($getLabelUrlResponseLabelURLItem)) {
                $invalidValues[] = is_object($getLabelUrlResponseLabelURLItem) ? get_class($getLabelUrlResponseLabelURLItem) : sprintf('%s(%s)', gettype($getLabelUrlResponseLabelURLItem), var_export($getLabelUrlResponseLabelURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelURL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelURL value
     * @throws \InvalidArgumentException
     * @param string[] $labelURL
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setLabelURL(array $labelURL = array())
    {
        // validation for constraint: array
        if ('' !== ($labelURLArrayErrorMessage = self::validateLabelURLForArrayConstraintsFromSetLabelURL($labelURL))) {
            throw new \InvalidArgumentException($labelURLArrayErrorMessage, __LINE__);
        }
        $this->LabelURL = $labelURL;
        return $this;
    }
    /**
     * Add item to LabelURL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function addToLabelURL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The LabelURL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LabelURL[] = $item;
        return $this;
    }
    /**
     * Get PDF value
     * @return string[]|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * This method is responsible for validating the values passed to the setPDF method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPDF method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePDFForArrayConstraintsFromSetPDF(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelUrlResponsePDFItem) {
            // validation for constraint: itemType
            if (!is_string($getLabelUrlResponsePDFItem)) {
                $invalidValues[] = is_object($getLabelUrlResponsePDFItem) ? get_class($getLabelUrlResponsePDFItem) : sprintf('%s(%s)', gettype($getLabelUrlResponsePDFItem), var_export($getLabelUrlResponsePDFItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PDF property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PDF value
     * @throws \InvalidArgumentException
     * @param string[] $pDF
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setPDF(array $pDF = array())
    {
        // validation for constraint: array
        if ('' !== ($pDFArrayErrorMessage = self::validatePDFForArrayConstraintsFromSetPDF($pDF))) {
            throw new \InvalidArgumentException($pDFArrayErrorMessage, __LINE__);
        }
        $this->PDF = $pDF;
        return $this;
    }
    /**
     * Add item to PDF value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function addToPDF($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PDF property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PDF[] = $item;
        return $this;
    }
    /**
     * Get ZPL value
     * @return string[]|null
     */
    public function getZPL()
    {
        return $this->ZPL;
    }
    /**
     * This method is responsible for validating the values passed to the setZPL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZPL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZPLForArrayConstraintsFromSetZPL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelUrlResponseZPLItem) {
            // validation for constraint: itemType
            if (!is_string($getLabelUrlResponseZPLItem)) {
                $invalidValues[] = is_object($getLabelUrlResponseZPLItem) ? get_class($getLabelUrlResponseZPLItem) : sprintf('%s(%s)', gettype($getLabelUrlResponseZPLItem), var_export($getLabelUrlResponseZPLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ZPL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ZPL value
     * @throws \InvalidArgumentException
     * @param string[] $zPL
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setZPL(array $zPL = array())
    {
        // validation for constraint: array
        if ('' !== ($zPLArrayErrorMessage = self::validateZPLForArrayConstraintsFromSetZPL($zPL))) {
            throw new \InvalidArgumentException($zPLArrayErrorMessage, __LINE__);
        }
        $this->ZPL = $zPL;
        return $this;
    }
    /**
     * Add item to ZPL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function addToZPL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ZPL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ZPL[] = $item;
        return $this;
    }
    /**
     * Get TrackingCarrier value
     * @return string|null
     */
    public function getTrackingCarrier()
    {
        return $this->TrackingCarrier;
    }
    /**
     * Set TrackingCarrier value
     * @param string $trackingCarrier
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setTrackingCarrier($trackingCarrier = null)
    {
        // validation for constraint: string
        if (!is_null($trackingCarrier) && !is_string($trackingCarrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingCarrier, true), gettype($trackingCarrier)), __LINE__);
        }
        $this->TrackingCarrier = $trackingCarrier;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get ReturnTrackingNumber value
     * @return string|null
     */
    public function getReturnTrackingNumber()
    {
        return $this->ReturnTrackingNumber;
    }
    /**
     * Set ReturnTrackingNumber value
     * @param string $returnTrackingNumber
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setReturnTrackingNumber($returnTrackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnTrackingNumber) && !is_string($returnTrackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnTrackingNumber, true), gettype($returnTrackingNumber)), __LINE__);
        }
        $this->ReturnTrackingNumber = $returnTrackingNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return float|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param float $status
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \shippypro\StructType\GetLabelUrlResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
