<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetManifest StructType
 * @subpackage Structs
 */
class GetManifest extends AbstractStructBase
{
    /**
     * The ManifestNumber
     * @var string
     */
    public $ManifestNumber;
    /**
     * Constructor method for GetManifest
     * @uses GetManifest::setManifestNumber()
     * @param string $manifestNumber
     */
    public function __construct($manifestNumber = null)
    {
        $this
            ->setManifestNumber($manifestNumber);
    }
    /**
     * Get ManifestNumber value
     * @return string|null
     */
    public function getManifestNumber()
    {
        return $this->ManifestNumber;
    }
    /**
     * Set ManifestNumber value
     * @param string $manifestNumber
     * @return \shippypro\StructType\GetManifest
     */
    public function setManifestNumber($manifestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($manifestNumber) && !is_string($manifestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestNumber, true), gettype($manifestNumber)), __LINE__);
        }
        $this->ManifestNumber = $manifestNumber;
        return $this;
    }
}
