<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateManifestResponse StructType
 * @subpackage Structs
 */
class CreateManifestResponse extends AbstractStructBase
{
    /**
     * The ManifestNumber
     * @var string
     */
    public $ManifestNumber;
    /**
     * The ManifestURL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ManifestURL;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * Constructor method for CreateManifestResponse
     * @uses CreateManifestResponse::setManifestNumber()
     * @uses CreateManifestResponse::setManifestURL()
     * @uses CreateManifestResponse::setErrorMessage()
     * @uses CreateManifestResponse::setError()
     * @param string $manifestNumber
     * @param string[] $manifestURL
     * @param string $errorMessage
     * @param string $error
     */
    public function __construct($manifestNumber = null, array $manifestURL = array(), $errorMessage = null, $error = null)
    {
        $this
            ->setManifestNumber($manifestNumber)
            ->setManifestURL($manifestURL)
            ->setErrorMessage($errorMessage)
            ->setError($error);
    }
    /**
     * Get ManifestNumber value
     * @return string|null
     */
    public function getManifestNumber()
    {
        return $this->ManifestNumber;
    }
    /**
     * Set ManifestNumber value
     * @param string $manifestNumber
     * @return \shippypro\StructType\CreateManifestResponse
     */
    public function setManifestNumber($manifestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($manifestNumber) && !is_string($manifestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestNumber, true), gettype($manifestNumber)), __LINE__);
        }
        $this->ManifestNumber = $manifestNumber;
        return $this;
    }
    /**
     * Get ManifestURL value
     * @return string[]|null
     */
    public function getManifestURL()
    {
        return $this->ManifestURL;
    }
    /**
     * This method is responsible for validating the values passed to the setManifestURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManifestURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManifestURLForArrayConstraintsFromSetManifestURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createManifestResponseManifestURLItem) {
            // validation for constraint: itemType
            if (!is_string($createManifestResponseManifestURLItem)) {
                $invalidValues[] = is_object($createManifestResponseManifestURLItem) ? get_class($createManifestResponseManifestURLItem) : sprintf('%s(%s)', gettype($createManifestResponseManifestURLItem), var_export($createManifestResponseManifestURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManifestURL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManifestURL value
     * @throws \InvalidArgumentException
     * @param string[] $manifestURL
     * @return \shippypro\StructType\CreateManifestResponse
     */
    public function setManifestURL(array $manifestURL = array())
    {
        // validation for constraint: array
        if ('' !== ($manifestURLArrayErrorMessage = self::validateManifestURLForArrayConstraintsFromSetManifestURL($manifestURL))) {
            throw new \InvalidArgumentException($manifestURLArrayErrorMessage, __LINE__);
        }
        $this->ManifestURL = $manifestURL;
        return $this;
    }
    /**
     * Add item to ManifestURL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\CreateManifestResponse
     */
    public function addToManifestURL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ManifestURL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ManifestURL[] = $item;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \shippypro\StructType\CreateManifestResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \shippypro\StructType\CreateManifestResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
