<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The length
     * @var float
     */
    public $length;
    /**
     * The width
     * @var float
     */
    public $width;
    /**
     * The height
     * @var float
     */
    public $height;
    /**
     * The weight
     * @var float
     */
    public $weight;
    /**
     * Constructor method for Parcel
     * @uses Parcel::setLength()
     * @uses Parcel::setWidth()
     * @uses Parcel::setHeight()
     * @uses Parcel::setWeight()
     * @param float $length
     * @param float $width
     * @param float $height
     * @param float $weight
     */
    public function __construct($length = null, $width = null, $height = null, $weight = null)
    {
        $this
            ->setLength($length)
            ->setWidth($width)
            ->setHeight($height)
            ->setWeight($weight);
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \shippypro\StructType\Parcel
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \shippypro\StructType\Parcel
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \shippypro\StructType\Parcel
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \shippypro\StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
}
