<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTrackingResponse StructType
 * @subpackage Structs
 */
class GetTrackingResponse extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\TrackingEvent[]
     */
    public $Details;
    /**
     * The Carrier
     * @var string
     */
    public $Carrier;
    /**
     * The CarrierLogo
     * @var string
     */
    public $CarrierLogo;
    /**
     * The Completed
     * @var bool
     */
    public $Completed;
    /**
     * The EstimatedDeliveryDate
     * @var string
     */
    public $EstimatedDeliveryDate;
    /**
     * Constructor method for GetTrackingResponse
     * @uses GetTrackingResponse::setDetails()
     * @uses GetTrackingResponse::setCarrier()
     * @uses GetTrackingResponse::setCarrierLogo()
     * @uses GetTrackingResponse::setCompleted()
     * @uses GetTrackingResponse::setEstimatedDeliveryDate()
     * @param \shippypro\StructType\TrackingEvent[] $details
     * @param string $carrier
     * @param string $carrierLogo
     * @param bool $completed
     * @param string $estimatedDeliveryDate
     */
    public function __construct(array $details = array(), $carrier = null, $carrierLogo = null, $completed = null, $estimatedDeliveryDate = null)
    {
        $this
            ->setDetails($details)
            ->setCarrier($carrier)
            ->setCarrierLogo($carrierLogo)
            ->setCompleted($completed)
            ->setEstimatedDeliveryDate($estimatedDeliveryDate);
    }
    /**
     * Get Details value
     * @return \shippypro\StructType\TrackingEvent[]|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * This method is responsible for validating the values passed to the setDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetailsForArrayConstraintsFromSetDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getTrackingResponseDetailsItem) {
            // validation for constraint: itemType
            if (!$getTrackingResponseDetailsItem instanceof \shippypro\StructType\TrackingEvent) {
                $invalidValues[] = is_object($getTrackingResponseDetailsItem) ? get_class($getTrackingResponseDetailsItem) : sprintf('%s(%s)', gettype($getTrackingResponseDetailsItem), var_export($getTrackingResponseDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Details property can only contain items of type \shippypro\StructType\TrackingEvent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Details value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\TrackingEvent[] $details
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function setDetails(array $details = array())
    {
        // validation for constraint: array
        if ('' !== ($detailsArrayErrorMessage = self::validateDetailsForArrayConstraintsFromSetDetails($details))) {
            throw new \InvalidArgumentException($detailsArrayErrorMessage, __LINE__);
        }
        $this->Details = $details;
        return $this;
    }
    /**
     * Add item to Details value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\TrackingEvent $item
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function addToDetails(\shippypro\StructType\TrackingEvent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\TrackingEvent) {
            throw new \InvalidArgumentException(sprintf('The Details property can only contain items of type \shippypro\StructType\TrackingEvent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Details[] = $item;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get CarrierLogo value
     * @return string|null
     */
    public function getCarrierLogo()
    {
        return $this->CarrierLogo;
    }
    /**
     * Set CarrierLogo value
     * @param string $carrierLogo
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function setCarrierLogo($carrierLogo = null)
    {
        // validation for constraint: string
        if (!is_null($carrierLogo) && !is_string($carrierLogo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierLogo, true), gettype($carrierLogo)), __LINE__);
        }
        $this->CarrierLogo = $carrierLogo;
        return $this;
    }
    /**
     * Get Completed value
     * @return bool|null
     */
    public function getCompleted()
    {
        return $this->Completed;
    }
    /**
     * Set Completed value
     * @param bool $completed
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function setCompleted($completed = null)
    {
        // validation for constraint: boolean
        if (!is_null($completed) && !is_bool($completed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($completed, true), gettype($completed)), __LINE__);
        }
        $this->Completed = $completed;
        return $this;
    }
    /**
     * Get EstimatedDeliveryDate value
     * @return string|null
     */
    public function getEstimatedDeliveryDate()
    {
        return $this->EstimatedDeliveryDate;
    }
    /**
     * Set EstimatedDeliveryDate value
     * @param string $estimatedDeliveryDate
     * @return \shippypro\StructType\GetTrackingResponse
     */
    public function setEstimatedDeliveryDate($estimatedDeliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDate) && !is_string($estimatedDeliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDate, true), gettype($estimatedDeliveryDate)), __LINE__);
        }
        $this->EstimatedDeliveryDate = $estimatedDeliveryDate;
        return $this;
    }
}
