<?php

namespace shippypro\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edit ServiceType
 * @subpackage Services
 */
class Edit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Edit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\Edit $parameters
     * @return \shippypro\StructType\EditResponse|bool
     */
    public function Edit(\shippypro\StructType\Edit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Edit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \shippypro\StructType\EditResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
