<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Edit StructType
 * @subpackage Structs
 */
class Edit extends AbstractStructBase
{
    /**
     * The to_address
     * @var \shippypro\StructType\Address
     */
    public $to_address;
    /**
     * The from_address
     * @var \shippypro\StructType\Address
     */
    public $from_address;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Parcel[]
     */
    public $parcels;
    /**
     * The TotalValue
     * @var string
     */
    public $TotalValue;
    /**
     * The TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The ContentDescription
     * @var string
     */
    public $ContentDescription;
    /**
     * The Insurance
     * @var float
     */
    public $Insurance;
    /**
     * The InsuranceCurrency
     * @var string
     */
    public $InsuranceCurrency;
    /**
     * The CashOnDelivery
     * @var float
     */
    public $CashOnDelivery;
    /**
     * The CashOnDeliveryCurrency
     * @var string
     */
    public $CashOnDeliveryCurrency;
    /**
     * The CarrierName
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierID
     * @var float
     */
    public $CarrierID;
    /**
     * The CarrierService
     * @var string
     */
    public $CarrierService;
    /**
     * The OrderID
     * @var string
     */
    public $OrderID;
    /**
     * The Incoterm
     * @var string
     */
    public $Incoterm;
    /**
     * The BillAccountNumber
     * @var string
     */
    public $BillAccountNumber;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The Async
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Async;
    /**
     * The CarrierOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\CarrierOption[]
     */
    public $CarrierOptions;
    /**
     * Constructor method for Edit
     * @uses Edit::setTo_address()
     * @uses Edit::setFrom_address()
     * @uses Edit::setParcels()
     * @uses Edit::setTotalValue()
     * @uses Edit::setTransactionID()
     * @uses Edit::setContentDescription()
     * @uses Edit::setInsurance()
     * @uses Edit::setInsuranceCurrency()
     * @uses Edit::setCashOnDelivery()
     * @uses Edit::setCashOnDeliveryCurrency()
     * @uses Edit::setCarrierName()
     * @uses Edit::setCarrierID()
     * @uses Edit::setCarrierService()
     * @uses Edit::setOrderID()
     * @uses Edit::setIncoterm()
     * @uses Edit::setBillAccountNumber()
     * @uses Edit::setNote()
     * @uses Edit::setAsync()
     * @uses Edit::setCarrierOptions()
     * @param \shippypro\StructType\Address $to_address
     * @param \shippypro\StructType\Address $from_address
     * @param \shippypro\StructType\Parcel[] $parcels
     * @param string $totalValue
     * @param string $transactionID
     * @param string $contentDescription
     * @param float $insurance
     * @param string $insuranceCurrency
     * @param float $cashOnDelivery
     * @param string $cashOnDeliveryCurrency
     * @param string $carrierName
     * @param float $carrierID
     * @param string $carrierService
     * @param string $orderID
     * @param string $incoterm
     * @param string $billAccountNumber
     * @param string $note
     * @param bool $async
     * @param \shippypro\StructType\CarrierOption[] $carrierOptions
     */
    public function __construct(\shippypro\StructType\Address $to_address = null, \shippypro\StructType\Address $from_address = null, array $parcels = array(), $totalValue = null, $transactionID = null, $contentDescription = null, $insurance = null, $insuranceCurrency = null, $cashOnDelivery = null, $cashOnDeliveryCurrency = null, $carrierName = null, $carrierID = null, $carrierService = null, $orderID = null, $incoterm = null, $billAccountNumber = null, $note = null, $async = null, array $carrierOptions = array())
    {
        $this
            ->setTo_address($to_address)
            ->setFrom_address($from_address)
            ->setParcels($parcels)
            ->setTotalValue($totalValue)
            ->setTransactionID($transactionID)
            ->setContentDescription($contentDescription)
            ->setInsurance($insurance)
            ->setInsuranceCurrency($insuranceCurrency)
            ->setCashOnDelivery($cashOnDelivery)
            ->setCashOnDeliveryCurrency($cashOnDeliveryCurrency)
            ->setCarrierName($carrierName)
            ->setCarrierID($carrierID)
            ->setCarrierService($carrierService)
            ->setOrderID($orderID)
            ->setIncoterm($incoterm)
            ->setBillAccountNumber($billAccountNumber)
            ->setNote($note)
            ->setAsync($async)
            ->setCarrierOptions($carrierOptions);
    }
    /**
     * Get to_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getTo_address()
    {
        return $this->to_address;
    }
    /**
     * Set to_address value
     * @param \shippypro\StructType\Address $to_address
     * @return \shippypro\StructType\Edit
     */
    public function setTo_address(\shippypro\StructType\Address $to_address = null)
    {
        $this->to_address = $to_address;
        return $this;
    }
    /**
     * Get from_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getFrom_address()
    {
        return $this->from_address;
    }
    /**
     * Set from_address value
     * @param \shippypro\StructType\Address $from_address
     * @return \shippypro\StructType\Edit
     */
    public function setFrom_address(\shippypro\StructType\Address $from_address = null)
    {
        $this->from_address = $from_address;
        return $this;
    }
    /**
     * Get parcels value
     * @return \shippypro\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $editParcelsItem) {
            // validation for constraint: itemType
            if (!$editParcelsItem instanceof \shippypro\StructType\Parcel) {
                $invalidValues[] = is_object($editParcelsItem) ? get_class($editParcelsItem) : sprintf('%s(%s)', gettype($editParcelsItem), var_export($editParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel[] $parcels
     * @return \shippypro\StructType\Edit
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel $item
     * @return \shippypro\StructType\Edit
     */
    public function addToParcels(\shippypro\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get TotalValue value
     * @return string|null
     */
    public function getTotalValue()
    {
        return $this->TotalValue;
    }
    /**
     * Set TotalValue value
     * @param string $totalValue
     * @return \shippypro\StructType\Edit
     */
    public function setTotalValue($totalValue = null)
    {
        // validation for constraint: string
        if (!is_null($totalValue) && !is_string($totalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalValue, true), gettype($totalValue)), __LINE__);
        }
        $this->TotalValue = $totalValue;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \shippypro\StructType\Edit
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ContentDescription value
     * @return string|null
     */
    public function getContentDescription()
    {
        return $this->ContentDescription;
    }
    /**
     * Set ContentDescription value
     * @param string $contentDescription
     * @return \shippypro\StructType\Edit
     */
    public function setContentDescription($contentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentDescription) && !is_string($contentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDescription, true), gettype($contentDescription)), __LINE__);
        }
        $this->ContentDescription = $contentDescription;
        return $this;
    }
    /**
     * Get Insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param float $insurance
     * @return \shippypro\StructType\Edit
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get InsuranceCurrency value
     * @return string|null
     */
    public function getInsuranceCurrency()
    {
        return $this->InsuranceCurrency;
    }
    /**
     * Set InsuranceCurrency value
     * @param string $insuranceCurrency
     * @return \shippypro\StructType\Edit
     */
    public function setInsuranceCurrency($insuranceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceCurrency) && !is_string($insuranceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceCurrency, true), gettype($insuranceCurrency)), __LINE__);
        }
        $this->InsuranceCurrency = $insuranceCurrency;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return float|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param float $cashOnDelivery
     * @return \shippypro\StructType\Edit
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: float
        if (!is_null($cashOnDelivery) && !(is_float($cashOnDelivery) || is_numeric($cashOnDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get CashOnDeliveryCurrency value
     * @return string|null
     */
    public function getCashOnDeliveryCurrency()
    {
        return $this->CashOnDeliveryCurrency;
    }
    /**
     * Set CashOnDeliveryCurrency value
     * @param string $cashOnDeliveryCurrency
     * @return \shippypro\StructType\Edit
     */
    public function setCashOnDeliveryCurrency($cashOnDeliveryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cashOnDeliveryCurrency) && !is_string($cashOnDeliveryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashOnDeliveryCurrency, true), gettype($cashOnDeliveryCurrency)), __LINE__);
        }
        $this->CashOnDeliveryCurrency = $cashOnDeliveryCurrency;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \shippypro\StructType\Edit
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return float|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param float $carrierID
     * @return \shippypro\StructType\Edit
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: float
        if (!is_null($carrierID) && !(is_float($carrierID) || is_numeric($carrierID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get CarrierService value
     * @return string|null
     */
    public function getCarrierService()
    {
        return $this->CarrierService;
    }
    /**
     * Set CarrierService value
     * @param string $carrierService
     * @return \shippypro\StructType\Edit
     */
    public function setCarrierService($carrierService = null)
    {
        // validation for constraint: string
        if (!is_null($carrierService) && !is_string($carrierService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierService, true), gettype($carrierService)), __LINE__);
        }
        $this->CarrierService = $carrierService;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \shippypro\StructType\Edit
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get Incoterm value
     * @return string|null
     */
    public function getIncoterm()
    {
        return $this->Incoterm;
    }
    /**
     * Set Incoterm value
     * @param string $incoterm
     * @return \shippypro\StructType\Edit
     */
    public function setIncoterm($incoterm = null)
    {
        // validation for constraint: string
        if (!is_null($incoterm) && !is_string($incoterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incoterm, true), gettype($incoterm)), __LINE__);
        }
        $this->Incoterm = $incoterm;
        return $this;
    }
    /**
     * Get BillAccountNumber value
     * @return string|null
     */
    public function getBillAccountNumber()
    {
        return $this->BillAccountNumber;
    }
    /**
     * Set BillAccountNumber value
     * @param string $billAccountNumber
     * @return \shippypro\StructType\Edit
     */
    public function setBillAccountNumber($billAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billAccountNumber) && !is_string($billAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billAccountNumber, true), gettype($billAccountNumber)), __LINE__);
        }
        $this->BillAccountNumber = $billAccountNumber;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \shippypro\StructType\Edit
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get Async value
     * @return bool|null
     */
    public function getAsync()
    {
        return $this->Async;
    }
    /**
     * Set Async value
     * @param bool $async
     * @return \shippypro\StructType\Edit
     */
    public function setAsync($async = null)
    {
        // validation for constraint: boolean
        if (!is_null($async) && !is_bool($async)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($async, true), gettype($async)), __LINE__);
        }
        $this->Async = $async;
        return $this;
    }
    /**
     * Get CarrierOptions value
     * @return \shippypro\StructType\CarrierOption[]|null
     */
    public function getCarrierOptions()
    {
        return $this->CarrierOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierOptionsForArrayConstraintsFromSetCarrierOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $editCarrierOptionsItem) {
            // validation for constraint: itemType
            if (!$editCarrierOptionsItem instanceof \shippypro\StructType\CarrierOption) {
                $invalidValues[] = is_object($editCarrierOptionsItem) ? get_class($editCarrierOptionsItem) : sprintf('%s(%s)', gettype($editCarrierOptionsItem), var_export($editCarrierOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption[] $carrierOptions
     * @return \shippypro\StructType\Edit
     */
    public function setCarrierOptions(array $carrierOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierOptionsArrayErrorMessage = self::validateCarrierOptionsForArrayConstraintsFromSetCarrierOptions($carrierOptions))) {
            throw new \InvalidArgumentException($carrierOptionsArrayErrorMessage, __LINE__);
        }
        $this->CarrierOptions = $carrierOptions;
        return $this;
    }
    /**
     * Add item to CarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption $item
     * @return \shippypro\StructType\Edit
     */
    public function addToCarrierOptions(\shippypro\StructType\CarrierOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\CarrierOption) {
            throw new \InvalidArgumentException(sprintf('The CarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierOptions[] = $item;
        return $this;
    }
}
