<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.shippypro.com/wsdl/shippypro.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.shippypro.com/wsdl/shippypro.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \shippypro\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \shippypro\ServiceType\Get($options);
/**
 * Sample call for GetLabelUrl operation/method
 */
if ($get->GetLabelUrl(new \shippypro\StructType\GetLabelUrl()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOrder operation/method
 */
if ($get->GetOrder(new \shippypro\StructType\GetOrder()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRates operation/method
 */
if ($get->GetRates(new \shippypro\StructType\GetRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTracking operation/method
 */
if ($get->GetTracking(new \shippypro\StructType\GetTracking()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetManifest operation/method
 */
if ($get->GetManifest(new \shippypro\StructType\GetManifest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCarrierOptions operation/method
 */
if ($get->GetCarrierOptions(new \shippypro\StructType\GetCarrierOptions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Ship ServiceType
 */
$ship = new \shippypro\ServiceType\Ship($options);
/**
 * Sample call for Ship operation/method
 */
if ($ship->Ship(new \shippypro\StructType\Ship()) !== false) {
    print_r($ship->getResult());
} else {
    print_r($ship->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \shippypro\ServiceType\Edit($options);
/**
 * Sample call for Edit operation/method
 */
if ($edit->Edit(new \shippypro\StructType\Edit()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \shippypro\ServiceType\Create($options);
/**
 * Sample call for CreateManifest operation/method
 */
if ($create->CreateManifest(new \shippypro\StructType\CreateManifest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \shippypro\ServiceType\Upload($options);
/**
 * Sample call for UploadPaperlessDocumentation operation/method
 */
if ($upload->UploadPaperlessDocumentation(new \shippypro\StructType\UploadPaperlessDocumentation()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \shippypro\ServiceType\Close($options);
/**
 * Sample call for CloseShipments operation/method
 */
if ($close->CloseShipments(new \shippypro\StructType\CloseShipments()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \shippypro\ServiceType\_Void($options);
/**
 * Sample call for VoidShipments operation/method
 */
if ($void->VoidShipments(new \shippypro\StructType\VoidShipments()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \shippypro\ServiceType\Delete($options);
/**
 * Sample call for DeleteManifest operation/method
 */
if ($delete->DeleteManifest(new \shippypro\StructType\DeleteManifest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
