<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRates StructType
 * @subpackage Structs
 */
class GetRates extends AbstractStructBase
{
    /**
     * The to_address
     * @var \shippypro\StructType\Address
     */
    public $to_address;
    /**
     * The from_address
     * @var \shippypro\StructType\Address
     */
    public $from_address;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Parcel[]
     */
    public $parcels;
    /**
     * The CashOnDelivery
     * @var float
     */
    public $CashOnDelivery;
    /**
     * The CashOnDeliveryCurrency
     * @var string
     */
    public $CashOnDeliveryCurrency;
    /**
     * The ContentDescription
     * @var string
     */
    public $ContentDescription;
    /**
     * The TotalValue
     * @var string
     */
    public $TotalValue;
    /**
     * The ShippingService
     * @var string
     */
    public $ShippingService;
    /**
     * Constructor method for GetRates
     * @uses GetRates::setTo_address()
     * @uses GetRates::setFrom_address()
     * @uses GetRates::setParcels()
     * @uses GetRates::setCashOnDelivery()
     * @uses GetRates::setCashOnDeliveryCurrency()
     * @uses GetRates::setContentDescription()
     * @uses GetRates::setTotalValue()
     * @uses GetRates::setShippingService()
     * @param \shippypro\StructType\Address $to_address
     * @param \shippypro\StructType\Address $from_address
     * @param \shippypro\StructType\Parcel[] $parcels
     * @param float $cashOnDelivery
     * @param string $cashOnDeliveryCurrency
     * @param string $contentDescription
     * @param string $totalValue
     * @param string $shippingService
     */
    public function __construct(\shippypro\StructType\Address $to_address = null, \shippypro\StructType\Address $from_address = null, array $parcels = array(), $cashOnDelivery = null, $cashOnDeliveryCurrency = null, $contentDescription = null, $totalValue = null, $shippingService = null)
    {
        $this
            ->setTo_address($to_address)
            ->setFrom_address($from_address)
            ->setParcels($parcels)
            ->setCashOnDelivery($cashOnDelivery)
            ->setCashOnDeliveryCurrency($cashOnDeliveryCurrency)
            ->setContentDescription($contentDescription)
            ->setTotalValue($totalValue)
            ->setShippingService($shippingService);
    }
    /**
     * Get to_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getTo_address()
    {
        return $this->to_address;
    }
    /**
     * Set to_address value
     * @param \shippypro\StructType\Address $to_address
     * @return \shippypro\StructType\GetRates
     */
    public function setTo_address(\shippypro\StructType\Address $to_address = null)
    {
        $this->to_address = $to_address;
        return $this;
    }
    /**
     * Get from_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getFrom_address()
    {
        return $this->from_address;
    }
    /**
     * Set from_address value
     * @param \shippypro\StructType\Address $from_address
     * @return \shippypro\StructType\GetRates
     */
    public function setFrom_address(\shippypro\StructType\Address $from_address = null)
    {
        $this->from_address = $from_address;
        return $this;
    }
    /**
     * Get parcels value
     * @return \shippypro\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getRatesParcelsItem) {
            // validation for constraint: itemType
            if (!$getRatesParcelsItem instanceof \shippypro\StructType\Parcel) {
                $invalidValues[] = is_object($getRatesParcelsItem) ? get_class($getRatesParcelsItem) : sprintf('%s(%s)', gettype($getRatesParcelsItem), var_export($getRatesParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel[] $parcels
     * @return \shippypro\StructType\GetRates
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel $item
     * @return \shippypro\StructType\GetRates
     */
    public function addToParcels(\shippypro\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return float|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param float $cashOnDelivery
     * @return \shippypro\StructType\GetRates
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: float
        if (!is_null($cashOnDelivery) && !(is_float($cashOnDelivery) || is_numeric($cashOnDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get CashOnDeliveryCurrency value
     * @return string|null
     */
    public function getCashOnDeliveryCurrency()
    {
        return $this->CashOnDeliveryCurrency;
    }
    /**
     * Set CashOnDeliveryCurrency value
     * @param string $cashOnDeliveryCurrency
     * @return \shippypro\StructType\GetRates
     */
    public function setCashOnDeliveryCurrency($cashOnDeliveryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cashOnDeliveryCurrency) && !is_string($cashOnDeliveryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashOnDeliveryCurrency, true), gettype($cashOnDeliveryCurrency)), __LINE__);
        }
        $this->CashOnDeliveryCurrency = $cashOnDeliveryCurrency;
        return $this;
    }
    /**
     * Get ContentDescription value
     * @return string|null
     */
    public function getContentDescription()
    {
        return $this->ContentDescription;
    }
    /**
     * Set ContentDescription value
     * @param string $contentDescription
     * @return \shippypro\StructType\GetRates
     */
    public function setContentDescription($contentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentDescription) && !is_string($contentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDescription, true), gettype($contentDescription)), __LINE__);
        }
        $this->ContentDescription = $contentDescription;
        return $this;
    }
    /**
     * Get TotalValue value
     * @return string|null
     */
    public function getTotalValue()
    {
        return $this->TotalValue;
    }
    /**
     * Set TotalValue value
     * @param string $totalValue
     * @return \shippypro\StructType\GetRates
     */
    public function setTotalValue($totalValue = null)
    {
        // validation for constraint: string
        if (!is_null($totalValue) && !is_string($totalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalValue, true), gettype($totalValue)), __LINE__);
        }
        $this->TotalValue = $totalValue;
        return $this;
    }
    /**
     * Get ShippingService value
     * @return string|null
     */
    public function getShippingService()
    {
        return $this->ShippingService;
    }
    /**
     * Set ShippingService value
     * @param string $shippingService
     * @return \shippypro\StructType\GetRates
     */
    public function setShippingService($shippingService = null)
    {
        // validation for constraint: string
        if (!is_null($shippingService) && !is_string($shippingService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingService, true), gettype($shippingService)), __LINE__);
        }
        $this->ShippingService = $shippingService;
        return $this;
    }
}
