<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateManifest StructType
 * @subpackage Structs
 */
class CreateManifest extends AbstractStructBase
{
    /**
     * The OrderIDS
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $OrderIDS;
    /**
     * Constructor method for CreateManifest
     * @uses CreateManifest::setOrderIDS()
     * @param int[] $orderIDS
     */
    public function __construct(array $orderIDS = array())
    {
        $this
            ->setOrderIDS($orderIDS);
    }
    /**
     * Get OrderIDS value
     * @return int[]
     */
    public function getOrderIDS()
    {
        return $this->OrderIDS;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderIDS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderIDS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderIDSForArrayConstraintsFromSetOrderIDS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $createManifestOrderIDSItem) {
            // validation for constraint: itemType
            if (!(is_int($createManifestOrderIDSItem) || ctype_digit($createManifestOrderIDSItem))) {
                $invalidValues[] = is_object($createManifestOrderIDSItem) ? get_class($createManifestOrderIDSItem) : sprintf('%s(%s)', gettype($createManifestOrderIDSItem), var_export($createManifestOrderIDSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderIDS value
     * @throws \InvalidArgumentException
     * @param int[] $orderIDS
     * @return \shippypro\StructType\CreateManifest
     */
    public function setOrderIDS(array $orderIDS = array())
    {
        // validation for constraint: array
        if ('' !== ($orderIDSArrayErrorMessage = self::validateOrderIDSForArrayConstraintsFromSetOrderIDS($orderIDS))) {
            throw new \InvalidArgumentException($orderIDSArrayErrorMessage, __LINE__);
        }
        $this->OrderIDS = $orderIDS;
        return $this;
    }
    /**
     * Add item to OrderIDS value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \shippypro\StructType\CreateManifest
     */
    public function addToOrderIDS($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderIDS[] = $item;
        return $this;
    }
}
