<?php

namespace shippypro\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ship ServiceType
 * @subpackage Services
 */
class Ship extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Ship
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\Ship $parameters
     * @return \shippypro\StructType\ShipResponse|bool
     */
    public function Ship(\shippypro\StructType\Ship $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Ship($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \shippypro\StructType\ShipResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
