<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadPaperlessDocumentation StructType
 * @subpackage Structs
 */
class UploadPaperlessDocumentation extends AbstractStructBase
{
    /**
     * The TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The Document
     * @var string
     */
    public $Document;
    /**
     * Constructor method for UploadPaperlessDocumentation
     * @uses UploadPaperlessDocumentation::setTransactionID()
     * @uses UploadPaperlessDocumentation::setName()
     * @uses UploadPaperlessDocumentation::setCountry()
     * @uses UploadPaperlessDocumentation::setDocument()
     * @param string $transactionID
     * @param string $name
     * @param string $country
     * @param string $document
     */
    public function __construct($transactionID = null, $name = null, $country = null, $document = null)
    {
        $this
            ->setTransactionID($transactionID)
            ->setName($name)
            ->setCountry($country)
            ->setDocument($document);
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \shippypro\StructType\UploadPaperlessDocumentation
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \shippypro\StructType\UploadPaperlessDocumentation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \shippypro\StructType\UploadPaperlessDocumentation
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get Document value
     * @return string|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param string $document
     * @return \shippypro\StructType\UploadPaperlessDocumentation
     */
    public function setDocument($document = null)
    {
        // validation for constraint: string
        if (!is_null($document) && !is_string($document)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document, true), gettype($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
}
