<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelUrl StructType
 * @subpackage Structs
 */
class GetLabelUrl extends AbstractStructBase
{
    /**
     * The OrderID
     * @var float
     */
    public $OrderID;
    /**
     * The LabelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LabelType;
    /**
     * The LabelWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LabelWidth;
    /**
     * The LabelHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LabelHeight;
    /**
     * Constructor method for GetLabelUrl
     * @uses GetLabelUrl::setOrderID()
     * @uses GetLabelUrl::setLabelType()
     * @uses GetLabelUrl::setLabelWidth()
     * @uses GetLabelUrl::setLabelHeight()
     * @param float $orderID
     * @param string $labelType
     * @param float $labelWidth
     * @param float $labelHeight
     */
    public function __construct($orderID = null, $labelType = null, $labelWidth = null, $labelHeight = null)
    {
        $this
            ->setOrderID($orderID)
            ->setLabelType($labelType)
            ->setLabelWidth($labelWidth)
            ->setLabelHeight($labelHeight);
    }
    /**
     * Get OrderID value
     * @return float|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param float $orderID
     * @return \shippypro\StructType\GetLabelUrl
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: float
        if (!is_null($orderID) && !(is_float($orderID) || is_numeric($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get LabelType value
     * @return string|null
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @param string $labelType
     * @return \shippypro\StructType\GetLabelUrl
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: string
        if (!is_null($labelType) && !is_string($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelType, true), gettype($labelType)), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get LabelWidth value
     * @return float|null
     */
    public function getLabelWidth()
    {
        return $this->LabelWidth;
    }
    /**
     * Set LabelWidth value
     * @param float $labelWidth
     * @return \shippypro\StructType\GetLabelUrl
     */
    public function setLabelWidth($labelWidth = null)
    {
        // validation for constraint: float
        if (!is_null($labelWidth) && !(is_float($labelWidth) || is_numeric($labelWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($labelWidth, true), gettype($labelWidth)), __LINE__);
        }
        $this->LabelWidth = $labelWidth;
        return $this;
    }
    /**
     * Get LabelHeight value
     * @return float|null
     */
    public function getLabelHeight()
    {
        return $this->LabelHeight;
    }
    /**
     * Set LabelHeight value
     * @param float $labelHeight
     * @return \shippypro\StructType\GetLabelUrl
     */
    public function setLabelHeight($labelHeight = null)
    {
        // validation for constraint: float
        if (!is_null($labelHeight) && !(is_float($labelHeight) || is_numeric($labelHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($labelHeight, true), gettype($labelHeight)), __LINE__);
        }
        $this->LabelHeight = $labelHeight;
        return $this;
    }
}
