<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCarrierOptionsResponse StructType
 * @subpackage Structs
 */
class GetCarrierOptionsResponse extends AbstractStructBase
{
    /**
     * The Result
     * @var string
     */
    public $Result;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * The Option
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Option[]
     */
    public $Option;
    /**
     * Constructor method for GetCarrierOptionsResponse
     * @uses GetCarrierOptionsResponse::setResult()
     * @uses GetCarrierOptionsResponse::setErrorMessage()
     * @uses GetCarrierOptionsResponse::setError()
     * @uses GetCarrierOptionsResponse::setOption()
     * @param string $result
     * @param string $errorMessage
     * @param string $error
     * @param \shippypro\StructType\Option[] $option
     */
    public function __construct($result = null, $errorMessage = null, $error = null, array $option = array())
    {
        $this
            ->setResult($result)
            ->setErrorMessage($errorMessage)
            ->setError($error)
            ->setOption($option);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \shippypro\StructType\GetCarrierOptionsResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \shippypro\StructType\GetCarrierOptionsResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \shippypro\StructType\GetCarrierOptionsResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Option value
     * @return \shippypro\StructType\Option[]|null
     */
    public function getOption()
    {
        return $this->Option;
    }
    /**
     * This method is responsible for validating the values passed to the setOption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionForArrayConstraintsFromSetOption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCarrierOptionsResponseOptionItem) {
            // validation for constraint: itemType
            if (!$getCarrierOptionsResponseOptionItem instanceof \shippypro\StructType\Option) {
                $invalidValues[] = is_object($getCarrierOptionsResponseOptionItem) ? get_class($getCarrierOptionsResponseOptionItem) : sprintf('%s(%s)', gettype($getCarrierOptionsResponseOptionItem), var_export($getCarrierOptionsResponseOptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Option property can only contain items of type \shippypro\StructType\Option, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Option value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Option[] $option
     * @return \shippypro\StructType\GetCarrierOptionsResponse
     */
    public function setOption(array $option = array())
    {
        // validation for constraint: array
        if ('' !== ($optionArrayErrorMessage = self::validateOptionForArrayConstraintsFromSetOption($option))) {
            throw new \InvalidArgumentException($optionArrayErrorMessage, __LINE__);
        }
        $this->Option = $option;
        return $this;
    }
    /**
     * Add item to Option value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Option $item
     * @return \shippypro\StructType\GetCarrierOptionsResponse
     */
    public function addToOption(\shippypro\StructType\Option $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Option) {
            throw new \InvalidArgumentException(sprintf('The Option property can only contain items of type \shippypro\StructType\Option, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Option[] = $item;
        return $this;
    }
}
