<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CN22Info StructType
 * @subpackage Structs
 */
class CN22Info extends AbstractStructBase
{
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The Weight
     * @var float
     */
    public $Weight;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The UnitValue
     * @var float
     */
    public $UnitValue;
    /**
     * The OriginCountry
     * @var string
     */
    public $OriginCountry;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The HSCode
     * @var string
     */
    public $HSCode;
    /**
     * Constructor method for CN22Info
     * @uses CN22Info::setDescription()
     * @uses CN22Info::setWeight()
     * @uses CN22Info::setQuantity()
     * @uses CN22Info::setUnitValue()
     * @uses CN22Info::setOriginCountry()
     * @uses CN22Info::setCurrency()
     * @uses CN22Info::setHSCode()
     * @param string $description
     * @param float $weight
     * @param int $quantity
     * @param float $unitValue
     * @param string $originCountry
     * @param string $currency
     * @param string $hSCode
     */
    public function __construct($description = null, $weight = null, $quantity = null, $unitValue = null, $originCountry = null, $currency = null, $hSCode = null)
    {
        $this
            ->setDescription($description)
            ->setWeight($weight)
            ->setQuantity($quantity)
            ->setUnitValue($unitValue)
            ->setOriginCountry($originCountry)
            ->setCurrency($currency)
            ->setHSCode($hSCode);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \shippypro\StructType\CN22Info
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \shippypro\StructType\CN22Info
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \shippypro\StructType\CN22Info
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get UnitValue value
     * @return float|null
     */
    public function getUnitValue()
    {
        return $this->UnitValue;
    }
    /**
     * Set UnitValue value
     * @param float $unitValue
     * @return \shippypro\StructType\CN22Info
     */
    public function setUnitValue($unitValue = null)
    {
        // validation for constraint: float
        if (!is_null($unitValue) && !(is_float($unitValue) || is_numeric($unitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitValue, true), gettype($unitValue)), __LINE__);
        }
        $this->UnitValue = $unitValue;
        return $this;
    }
    /**
     * Get OriginCountry value
     * @return string|null
     */
    public function getOriginCountry()
    {
        return $this->OriginCountry;
    }
    /**
     * Set OriginCountry value
     * @param string $originCountry
     * @return \shippypro\StructType\CN22Info
     */
    public function setOriginCountry($originCountry = null)
    {
        // validation for constraint: string
        if (!is_null($originCountry) && !is_string($originCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCountry, true), gettype($originCountry)), __LINE__);
        }
        $this->OriginCountry = $originCountry;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \shippypro\StructType\CN22Info
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get HSCode value
     * @return string|null
     */
    public function getHSCode()
    {
        return $this->HSCode;
    }
    /**
     * Set HSCode value
     * @param string $hSCode
     * @return \shippypro\StructType\CN22Info
     */
    public function setHSCode($hSCode = null)
    {
        // validation for constraint: string
        if (!is_null($hSCode) && !is_string($hSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hSCode, true), gettype($hSCode)), __LINE__);
        }
        $this->HSCode = $hSCode;
        return $this;
    }
}
