<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookPickup StructType
 * @subpackage Structs
 */
class BookPickup extends AbstractStructBase
{
    /**
     * The CarrierName
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierID
     * @var float
     */
    public $CarrierID;
    /**
     * The PickupTime
     * @var float
     */
    public $PickupTime;
    /**
     * The PickupNote
     * @var string
     */
    public $PickupNote;
    /**
     * The PickupMorningMintime
     * @var string
     */
    public $PickupMorningMintime;
    /**
     * The PickupMorningMaxtime
     * @var string
     */
    public $PickupMorningMaxtime;
    /**
     * The PickupAfternoonMintime
     * @var string
     */
    public $PickupAfternoonMintime;
    /**
     * The PickupAfternoonMaxtime
     * @var string
     */
    public $PickupAfternoonMaxtime;
    /**
     * The to_address
     * @var \shippypro\StructType\To_address
     */
    public $to_address;
    /**
     * The from_address
     * @var \shippypro\StructType\Address
     */
    public $from_address;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Parcel[]
     */
    public $parcels;
    /**
     * Constructor method for BookPickup
     * @uses BookPickup::setCarrierName()
     * @uses BookPickup::setCarrierID()
     * @uses BookPickup::setPickupTime()
     * @uses BookPickup::setPickupNote()
     * @uses BookPickup::setPickupMorningMintime()
     * @uses BookPickup::setPickupMorningMaxtime()
     * @uses BookPickup::setPickupAfternoonMintime()
     * @uses BookPickup::setPickupAfternoonMaxtime()
     * @uses BookPickup::setTo_address()
     * @uses BookPickup::setFrom_address()
     * @uses BookPickup::setParcels()
     * @param string $carrierName
     * @param float $carrierID
     * @param float $pickupTime
     * @param string $pickupNote
     * @param string $pickupMorningMintime
     * @param string $pickupMorningMaxtime
     * @param string $pickupAfternoonMintime
     * @param string $pickupAfternoonMaxtime
     * @param \shippypro\StructType\To_address $to_address
     * @param \shippypro\StructType\Address $from_address
     * @param \shippypro\StructType\Parcel[] $parcels
     */
    public function __construct($carrierName = null, $carrierID = null, $pickupTime = null, $pickupNote = null, $pickupMorningMintime = null, $pickupMorningMaxtime = null, $pickupAfternoonMintime = null, $pickupAfternoonMaxtime = null, \shippypro\StructType\To_address $to_address = null, \shippypro\StructType\Address $from_address = null, array $parcels = array())
    {
        $this
            ->setCarrierName($carrierName)
            ->setCarrierID($carrierID)
            ->setPickupTime($pickupTime)
            ->setPickupNote($pickupNote)
            ->setPickupMorningMintime($pickupMorningMintime)
            ->setPickupMorningMaxtime($pickupMorningMaxtime)
            ->setPickupAfternoonMintime($pickupAfternoonMintime)
            ->setPickupAfternoonMaxtime($pickupAfternoonMaxtime)
            ->setTo_address($to_address)
            ->setFrom_address($from_address)
            ->setParcels($parcels);
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \shippypro\StructType\BookPickup
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return float|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param float $carrierID
     * @return \shippypro\StructType\BookPickup
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: float
        if (!is_null($carrierID) && !(is_float($carrierID) || is_numeric($carrierID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get PickupTime value
     * @return float|null
     */
    public function getPickupTime()
    {
        return $this->PickupTime;
    }
    /**
     * Set PickupTime value
     * @param float $pickupTime
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupTime($pickupTime = null)
    {
        // validation for constraint: float
        if (!is_null($pickupTime) && !(is_float($pickupTime) || is_numeric($pickupTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pickupTime, true), gettype($pickupTime)), __LINE__);
        }
        $this->PickupTime = $pickupTime;
        return $this;
    }
    /**
     * Get PickupNote value
     * @return string|null
     */
    public function getPickupNote()
    {
        return $this->PickupNote;
    }
    /**
     * Set PickupNote value
     * @param string $pickupNote
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupNote($pickupNote = null)
    {
        // validation for constraint: string
        if (!is_null($pickupNote) && !is_string($pickupNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupNote, true), gettype($pickupNote)), __LINE__);
        }
        $this->PickupNote = $pickupNote;
        return $this;
    }
    /**
     * Get PickupMorningMintime value
     * @return string|null
     */
    public function getPickupMorningMintime()
    {
        return $this->PickupMorningMintime;
    }
    /**
     * Set PickupMorningMintime value
     * @param string $pickupMorningMintime
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupMorningMintime($pickupMorningMintime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupMorningMintime) && !is_string($pickupMorningMintime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupMorningMintime, true), gettype($pickupMorningMintime)), __LINE__);
        }
        $this->PickupMorningMintime = $pickupMorningMintime;
        return $this;
    }
    /**
     * Get PickupMorningMaxtime value
     * @return string|null
     */
    public function getPickupMorningMaxtime()
    {
        return $this->PickupMorningMaxtime;
    }
    /**
     * Set PickupMorningMaxtime value
     * @param string $pickupMorningMaxtime
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupMorningMaxtime($pickupMorningMaxtime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupMorningMaxtime) && !is_string($pickupMorningMaxtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupMorningMaxtime, true), gettype($pickupMorningMaxtime)), __LINE__);
        }
        $this->PickupMorningMaxtime = $pickupMorningMaxtime;
        return $this;
    }
    /**
     * Get PickupAfternoonMintime value
     * @return string|null
     */
    public function getPickupAfternoonMintime()
    {
        return $this->PickupAfternoonMintime;
    }
    /**
     * Set PickupAfternoonMintime value
     * @param string $pickupAfternoonMintime
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupAfternoonMintime($pickupAfternoonMintime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupAfternoonMintime) && !is_string($pickupAfternoonMintime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupAfternoonMintime, true), gettype($pickupAfternoonMintime)), __LINE__);
        }
        $this->PickupAfternoonMintime = $pickupAfternoonMintime;
        return $this;
    }
    /**
     * Get PickupAfternoonMaxtime value
     * @return string|null
     */
    public function getPickupAfternoonMaxtime()
    {
        return $this->PickupAfternoonMaxtime;
    }
    /**
     * Set PickupAfternoonMaxtime value
     * @param string $pickupAfternoonMaxtime
     * @return \shippypro\StructType\BookPickup
     */
    public function setPickupAfternoonMaxtime($pickupAfternoonMaxtime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupAfternoonMaxtime) && !is_string($pickupAfternoonMaxtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupAfternoonMaxtime, true), gettype($pickupAfternoonMaxtime)), __LINE__);
        }
        $this->PickupAfternoonMaxtime = $pickupAfternoonMaxtime;
        return $this;
    }
    /**
     * Get to_address value
     * @return \shippypro\StructType\To_address|null
     */
    public function getTo_address()
    {
        return $this->to_address;
    }
    /**
     * Set to_address value
     * @param \shippypro\StructType\To_address $to_address
     * @return \shippypro\StructType\BookPickup
     */
    public function setTo_address(\shippypro\StructType\To_address $to_address = null)
    {
        $this->to_address = $to_address;
        return $this;
    }
    /**
     * Get from_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getFrom_address()
    {
        return $this->from_address;
    }
    /**
     * Set from_address value
     * @param \shippypro\StructType\Address $from_address
     * @return \shippypro\StructType\BookPickup
     */
    public function setFrom_address(\shippypro\StructType\Address $from_address = null)
    {
        $this->from_address = $from_address;
        return $this;
    }
    /**
     * Get parcels value
     * @return \shippypro\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookPickupParcelsItem) {
            // validation for constraint: itemType
            if (!$bookPickupParcelsItem instanceof \shippypro\StructType\Parcel) {
                $invalidValues[] = is_object($bookPickupParcelsItem) ? get_class($bookPickupParcelsItem) : sprintf('%s(%s)', gettype($bookPickupParcelsItem), var_export($bookPickupParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel[] $parcels
     * @return \shippypro\StructType\BookPickup
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel $item
     * @return \shippypro\StructType\BookPickup
     */
    public function addToParcels(\shippypro\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
}
