<?php

namespace shippypro\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetLabelUrl
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetLabelUrl $parameters
     * @return \shippypro\StructType\GetLabelUrlResponse|bool
     */
    public function GetLabelUrl(\shippypro\StructType\GetLabelUrl $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLabelUrl($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetOrder $parameters
     * @return \shippypro\StructType\GetOrderResponse|bool
     */
    public function GetOrder(\shippypro\StructType\GetOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetRates $parameters
     * @return \shippypro\StructType\GetRatesResponse|bool
     */
    public function GetRates(\shippypro\StructType\GetRates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetTracking $parameters
     * @return \shippypro\StructType\GetTrackingResponse|bool
     */
    public function GetTracking(\shippypro\StructType\GetTracking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetManifest $parameters
     * @return \shippypro\StructType\GetManifestResponse|bool
     */
    public function GetManifest(\shippypro\StructType\GetManifest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetManifest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCarrierOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\GetCarrierOptions $parameters
     * @return \shippypro\StructType\GetCarrierOptionsResponse|bool
     */
    public function GetCarrierOptions(\shippypro\StructType\GetCarrierOptions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCarrierOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \shippypro\StructType\GetCarrierOptionsResponse|\shippypro\StructType\GetLabelUrlResponse|\shippypro\StructType\GetManifestResponse|\shippypro\StructType\GetOrderResponse|\shippypro\StructType\GetRatesResponse|\shippypro\StructType\GetTrackingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
