<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ship StructType
 * @subpackage Structs
 */
class Ship extends AbstractStructBase
{
    /**
     * The to_address
     * @var \shippypro\StructType\Address
     */
    public $to_address;
    /**
     * The from_address
     * @var \shippypro\StructType\Address
     */
    public $from_address;
    /**
     * The return_to
     * @var \shippypro\StructType\Address
     */
    public $return_to;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Parcel[]
     */
    public $parcels;
    /**
     * The TotalValue
     * @var string
     */
    public $TotalValue;
    /**
     * The TransactionID
     * @var string
     */
    public $TransactionID;
    /**
     * The ContentDescription
     * @var string
     */
    public $ContentDescription;
    /**
     * The Insurance
     * @var float
     */
    public $Insurance;
    /**
     * The InsuranceCurrency
     * @var string
     */
    public $InsuranceCurrency;
    /**
     * The CashOnDelivery
     * @var float
     */
    public $CashOnDelivery;
    /**
     * The CashOnDeliveryCurrency
     * @var string
     */
    public $CashOnDeliveryCurrency;
    /**
     * The CarrierName
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierID
     * @var float
     */
    public $CarrierID;
    /**
     * The CarrierService
     * @var string
     */
    public $CarrierService;
    /**
     * The OrderID
     * @var string
     */
    public $OrderID;
    /**
     * The RateID
     * @var string
     */
    public $RateID;
    /**
     * The Incoterm
     * @var string
     */
    public $Incoterm;
    /**
     * The BillAccountNumber
     * @var string
     */
    public $BillAccountNumber;
    /**
     * The Note
     * @var string
     */
    public $Note;
    /**
     * The Async
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Async;
    /**
     * The CarrierOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\CarrierOption[]
     */
    public $CarrierOptions;
    /**
     * The ReturnCarrierOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\CarrierOption[]
     */
    public $ReturnCarrierOptions;
    /**
     * The CN22Info
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \shippypro\StructType\CN22Info[]
     */
    public $CN22Info;
    /**
     * The ReturnCarrierName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReturnCarrierName;
    /**
     * The ReturnCarrierID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $ReturnCarrierID;
    /**
     * The ReturnCarrierService
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReturnCarrierService;
    /**
     * The ReturnInsurance
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReturnInsurance;
    /**
     * The ReturnInsuranceCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ReturnInsuranceCurrency;
    /**
     * The Attributes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \shippypro\StructType\Attribute[]
     */
    public $Attributes;
    /**
     * Constructor method for Ship
     * @uses Ship::setTo_address()
     * @uses Ship::setFrom_address()
     * @uses Ship::setReturn_to()
     * @uses Ship::setParcels()
     * @uses Ship::setTotalValue()
     * @uses Ship::setTransactionID()
     * @uses Ship::setContentDescription()
     * @uses Ship::setInsurance()
     * @uses Ship::setInsuranceCurrency()
     * @uses Ship::setCashOnDelivery()
     * @uses Ship::setCashOnDeliveryCurrency()
     * @uses Ship::setCarrierName()
     * @uses Ship::setCarrierID()
     * @uses Ship::setCarrierService()
     * @uses Ship::setOrderID()
     * @uses Ship::setRateID()
     * @uses Ship::setIncoterm()
     * @uses Ship::setBillAccountNumber()
     * @uses Ship::setNote()
     * @uses Ship::setAsync()
     * @uses Ship::setCarrierOptions()
     * @uses Ship::setReturnCarrierOptions()
     * @uses Ship::setCN22Info()
     * @uses Ship::setReturnCarrierName()
     * @uses Ship::setReturnCarrierID()
     * @uses Ship::setReturnCarrierService()
     * @uses Ship::setReturnInsurance()
     * @uses Ship::setReturnInsuranceCurrency()
     * @uses Ship::setAttributes()
     * @param \shippypro\StructType\Address $to_address
     * @param \shippypro\StructType\Address $from_address
     * @param \shippypro\StructType\Address $return_to
     * @param \shippypro\StructType\Parcel[] $parcels
     * @param string $totalValue
     * @param string $transactionID
     * @param string $contentDescription
     * @param float $insurance
     * @param string $insuranceCurrency
     * @param float $cashOnDelivery
     * @param string $cashOnDeliveryCurrency
     * @param string $carrierName
     * @param float $carrierID
     * @param string $carrierService
     * @param string $orderID
     * @param string $rateID
     * @param string $incoterm
     * @param string $billAccountNumber
     * @param string $note
     * @param bool $async
     * @param \shippypro\StructType\CarrierOption[] $carrierOptions
     * @param \shippypro\StructType\CarrierOption[] $returnCarrierOptions
     * @param \shippypro\StructType\CN22Info[] $cN22Info
     * @param string[] $returnCarrierName
     * @param float[] $returnCarrierID
     * @param string[] $returnCarrierService
     * @param string[] $returnInsurance
     * @param string[] $returnInsuranceCurrency
     * @param \shippypro\StructType\Attribute[] $attributes
     */
    public function __construct(\shippypro\StructType\Address $to_address = null, \shippypro\StructType\Address $from_address = null, \shippypro\StructType\Address $return_to = null, array $parcels = array(), $totalValue = null, $transactionID = null, $contentDescription = null, $insurance = null, $insuranceCurrency = null, $cashOnDelivery = null, $cashOnDeliveryCurrency = null, $carrierName = null, $carrierID = null, $carrierService = null, $orderID = null, $rateID = null, $incoterm = null, $billAccountNumber = null, $note = null, $async = null, array $carrierOptions = array(), array $returnCarrierOptions = array(), array $cN22Info = array(), array $returnCarrierName = array(), array $returnCarrierID = array(), array $returnCarrierService = array(), array $returnInsurance = array(), array $returnInsuranceCurrency = array(), array $attributes = array())
    {
        $this
            ->setTo_address($to_address)
            ->setFrom_address($from_address)
            ->setReturn_to($return_to)
            ->setParcels($parcels)
            ->setTotalValue($totalValue)
            ->setTransactionID($transactionID)
            ->setContentDescription($contentDescription)
            ->setInsurance($insurance)
            ->setInsuranceCurrency($insuranceCurrency)
            ->setCashOnDelivery($cashOnDelivery)
            ->setCashOnDeliveryCurrency($cashOnDeliveryCurrency)
            ->setCarrierName($carrierName)
            ->setCarrierID($carrierID)
            ->setCarrierService($carrierService)
            ->setOrderID($orderID)
            ->setRateID($rateID)
            ->setIncoterm($incoterm)
            ->setBillAccountNumber($billAccountNumber)
            ->setNote($note)
            ->setAsync($async)
            ->setCarrierOptions($carrierOptions)
            ->setReturnCarrierOptions($returnCarrierOptions)
            ->setCN22Info($cN22Info)
            ->setReturnCarrierName($returnCarrierName)
            ->setReturnCarrierID($returnCarrierID)
            ->setReturnCarrierService($returnCarrierService)
            ->setReturnInsurance($returnInsurance)
            ->setReturnInsuranceCurrency($returnInsuranceCurrency)
            ->setAttributes($attributes);
    }
    /**
     * Get to_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getTo_address()
    {
        return $this->to_address;
    }
    /**
     * Set to_address value
     * @param \shippypro\StructType\Address $to_address
     * @return \shippypro\StructType\Ship
     */
    public function setTo_address(\shippypro\StructType\Address $to_address = null)
    {
        $this->to_address = $to_address;
        return $this;
    }
    /**
     * Get from_address value
     * @return \shippypro\StructType\Address|null
     */
    public function getFrom_address()
    {
        return $this->from_address;
    }
    /**
     * Set from_address value
     * @param \shippypro\StructType\Address $from_address
     * @return \shippypro\StructType\Ship
     */
    public function setFrom_address(\shippypro\StructType\Address $from_address = null)
    {
        $this->from_address = $from_address;
        return $this;
    }
    /**
     * Get return_to value
     * @return \shippypro\StructType\Address|null
     */
    public function getReturn_to()
    {
        return $this->return_to;
    }
    /**
     * Set return_to value
     * @param \shippypro\StructType\Address $return_to
     * @return \shippypro\StructType\Ship
     */
    public function setReturn_to(\shippypro\StructType\Address $return_to = null)
    {
        $this->return_to = $return_to;
        return $this;
    }
    /**
     * Get parcels value
     * @return \shippypro\StructType\Parcel[]|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipParcelsItem) {
            // validation for constraint: itemType
            if (!$shipParcelsItem instanceof \shippypro\StructType\Parcel) {
                $invalidValues[] = is_object($shipParcelsItem) ? get_class($shipParcelsItem) : sprintf('%s(%s)', gettype($shipParcelsItem), var_export($shipParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel[] $parcels
     * @return \shippypro\StructType\Ship
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Parcel $item
     * @return \shippypro\StructType\Ship
     */
    public function addToParcels(\shippypro\StructType\Parcel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Parcel) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \shippypro\StructType\Parcel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get TotalValue value
     * @return string|null
     */
    public function getTotalValue()
    {
        return $this->TotalValue;
    }
    /**
     * Set TotalValue value
     * @param string $totalValue
     * @return \shippypro\StructType\Ship
     */
    public function setTotalValue($totalValue = null)
    {
        // validation for constraint: string
        if (!is_null($totalValue) && !is_string($totalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalValue, true), gettype($totalValue)), __LINE__);
        }
        $this->TotalValue = $totalValue;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \shippypro\StructType\Ship
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get ContentDescription value
     * @return string|null
     */
    public function getContentDescription()
    {
        return $this->ContentDescription;
    }
    /**
     * Set ContentDescription value
     * @param string $contentDescription
     * @return \shippypro\StructType\Ship
     */
    public function setContentDescription($contentDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentDescription) && !is_string($contentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentDescription, true), gettype($contentDescription)), __LINE__);
        }
        $this->ContentDescription = $contentDescription;
        return $this;
    }
    /**
     * Get Insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param float $insurance
     * @return \shippypro\StructType\Ship
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get InsuranceCurrency value
     * @return string|null
     */
    public function getInsuranceCurrency()
    {
        return $this->InsuranceCurrency;
    }
    /**
     * Set InsuranceCurrency value
     * @param string $insuranceCurrency
     * @return \shippypro\StructType\Ship
     */
    public function setInsuranceCurrency($insuranceCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($insuranceCurrency) && !is_string($insuranceCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insuranceCurrency, true), gettype($insuranceCurrency)), __LINE__);
        }
        $this->InsuranceCurrency = $insuranceCurrency;
        return $this;
    }
    /**
     * Get CashOnDelivery value
     * @return float|null
     */
    public function getCashOnDelivery()
    {
        return $this->CashOnDelivery;
    }
    /**
     * Set CashOnDelivery value
     * @param float $cashOnDelivery
     * @return \shippypro\StructType\Ship
     */
    public function setCashOnDelivery($cashOnDelivery = null)
    {
        // validation for constraint: float
        if (!is_null($cashOnDelivery) && !(is_float($cashOnDelivery) || is_numeric($cashOnDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashOnDelivery, true), gettype($cashOnDelivery)), __LINE__);
        }
        $this->CashOnDelivery = $cashOnDelivery;
        return $this;
    }
    /**
     * Get CashOnDeliveryCurrency value
     * @return string|null
     */
    public function getCashOnDeliveryCurrency()
    {
        return $this->CashOnDeliveryCurrency;
    }
    /**
     * Set CashOnDeliveryCurrency value
     * @param string $cashOnDeliveryCurrency
     * @return \shippypro\StructType\Ship
     */
    public function setCashOnDeliveryCurrency($cashOnDeliveryCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cashOnDeliveryCurrency) && !is_string($cashOnDeliveryCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cashOnDeliveryCurrency, true), gettype($cashOnDeliveryCurrency)), __LINE__);
        }
        $this->CashOnDeliveryCurrency = $cashOnDeliveryCurrency;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \shippypro\StructType\Ship
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return float|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param float $carrierID
     * @return \shippypro\StructType\Ship
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: float
        if (!is_null($carrierID) && !(is_float($carrierID) || is_numeric($carrierID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get CarrierService value
     * @return string|null
     */
    public function getCarrierService()
    {
        return $this->CarrierService;
    }
    /**
     * Set CarrierService value
     * @param string $carrierService
     * @return \shippypro\StructType\Ship
     */
    public function setCarrierService($carrierService = null)
    {
        // validation for constraint: string
        if (!is_null($carrierService) && !is_string($carrierService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierService, true), gettype($carrierService)), __LINE__);
        }
        $this->CarrierService = $carrierService;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \shippypro\StructType\Ship
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get RateID value
     * @return string|null
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param string $rateID
     * @return \shippypro\StructType\Ship
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: string
        if (!is_null($rateID) && !is_string($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateID, true), gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get Incoterm value
     * @return string|null
     */
    public function getIncoterm()
    {
        return $this->Incoterm;
    }
    /**
     * Set Incoterm value
     * @param string $incoterm
     * @return \shippypro\StructType\Ship
     */
    public function setIncoterm($incoterm = null)
    {
        // validation for constraint: string
        if (!is_null($incoterm) && !is_string($incoterm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($incoterm, true), gettype($incoterm)), __LINE__);
        }
        $this->Incoterm = $incoterm;
        return $this;
    }
    /**
     * Get BillAccountNumber value
     * @return string|null
     */
    public function getBillAccountNumber()
    {
        return $this->BillAccountNumber;
    }
    /**
     * Set BillAccountNumber value
     * @param string $billAccountNumber
     * @return \shippypro\StructType\Ship
     */
    public function setBillAccountNumber($billAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billAccountNumber) && !is_string($billAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billAccountNumber, true), gettype($billAccountNumber)), __LINE__);
        }
        $this->BillAccountNumber = $billAccountNumber;
        return $this;
    }
    /**
     * Get Note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @param string $note
     * @return \shippypro\StructType\Ship
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Get Async value
     * @return bool|null
     */
    public function getAsync()
    {
        return $this->Async;
    }
    /**
     * Set Async value
     * @param bool $async
     * @return \shippypro\StructType\Ship
     */
    public function setAsync($async = null)
    {
        // validation for constraint: boolean
        if (!is_null($async) && !is_bool($async)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($async, true), gettype($async)), __LINE__);
        }
        $this->Async = $async;
        return $this;
    }
    /**
     * Get CarrierOptions value
     * @return \shippypro\StructType\CarrierOption[]|null
     */
    public function getCarrierOptions()
    {
        return $this->CarrierOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierOptionsForArrayConstraintsFromSetCarrierOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipCarrierOptionsItem) {
            // validation for constraint: itemType
            if (!$shipCarrierOptionsItem instanceof \shippypro\StructType\CarrierOption) {
                $invalidValues[] = is_object($shipCarrierOptionsItem) ? get_class($shipCarrierOptionsItem) : sprintf('%s(%s)', gettype($shipCarrierOptionsItem), var_export($shipCarrierOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption[] $carrierOptions
     * @return \shippypro\StructType\Ship
     */
    public function setCarrierOptions(array $carrierOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierOptionsArrayErrorMessage = self::validateCarrierOptionsForArrayConstraintsFromSetCarrierOptions($carrierOptions))) {
            throw new \InvalidArgumentException($carrierOptionsArrayErrorMessage, __LINE__);
        }
        $this->CarrierOptions = $carrierOptions;
        return $this;
    }
    /**
     * Add item to CarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption $item
     * @return \shippypro\StructType\Ship
     */
    public function addToCarrierOptions(\shippypro\StructType\CarrierOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\CarrierOption) {
            throw new \InvalidArgumentException(sprintf('The CarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierOptions[] = $item;
        return $this;
    }
    /**
     * Get ReturnCarrierOptions value
     * @return \shippypro\StructType\CarrierOption[]|null
     */
    public function getReturnCarrierOptions()
    {
        return $this->ReturnCarrierOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnCarrierOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnCarrierOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnCarrierOptionsForArrayConstraintsFromSetReturnCarrierOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnCarrierOptionsItem) {
            // validation for constraint: itemType
            if (!$shipReturnCarrierOptionsItem instanceof \shippypro\StructType\CarrierOption) {
                $invalidValues[] = is_object($shipReturnCarrierOptionsItem) ? get_class($shipReturnCarrierOptionsItem) : sprintf('%s(%s)', gettype($shipReturnCarrierOptionsItem), var_export($shipReturnCarrierOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnCarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnCarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption[] $returnCarrierOptions
     * @return \shippypro\StructType\Ship
     */
    public function setReturnCarrierOptions(array $returnCarrierOptions = array())
    {
        // validation for constraint: array
        if ('' !== ($returnCarrierOptionsArrayErrorMessage = self::validateReturnCarrierOptionsForArrayConstraintsFromSetReturnCarrierOptions($returnCarrierOptions))) {
            throw new \InvalidArgumentException($returnCarrierOptionsArrayErrorMessage, __LINE__);
        }
        $this->ReturnCarrierOptions = $returnCarrierOptions;
        return $this;
    }
    /**
     * Add item to ReturnCarrierOptions value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CarrierOption $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnCarrierOptions(\shippypro\StructType\CarrierOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\CarrierOption) {
            throw new \InvalidArgumentException(sprintf('The ReturnCarrierOptions property can only contain items of type \shippypro\StructType\CarrierOption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnCarrierOptions[] = $item;
        return $this;
    }
    /**
     * Get CN22Info value
     * @return \shippypro\StructType\CN22Info[]|null
     */
    public function getCN22Info()
    {
        return $this->CN22Info;
    }
    /**
     * This method is responsible for validating the values passed to the setCN22Info method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCN22Info method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCN22InfoForArrayConstraintsFromSetCN22Info(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipCN22InfoItem) {
            // validation for constraint: itemType
            if (!$shipCN22InfoItem instanceof \shippypro\StructType\CN22Info) {
                $invalidValues[] = is_object($shipCN22InfoItem) ? get_class($shipCN22InfoItem) : sprintf('%s(%s)', gettype($shipCN22InfoItem), var_export($shipCN22InfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CN22Info property can only contain items of type \shippypro\StructType\CN22Info, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CN22Info value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CN22Info[] $cN22Info
     * @return \shippypro\StructType\Ship
     */
    public function setCN22Info(array $cN22Info = array())
    {
        // validation for constraint: array
        if ('' !== ($cN22InfoArrayErrorMessage = self::validateCN22InfoForArrayConstraintsFromSetCN22Info($cN22Info))) {
            throw new \InvalidArgumentException($cN22InfoArrayErrorMessage, __LINE__);
        }
        $this->CN22Info = $cN22Info;
        return $this;
    }
    /**
     * Add item to CN22Info value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\CN22Info $item
     * @return \shippypro\StructType\Ship
     */
    public function addToCN22Info(\shippypro\StructType\CN22Info $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\CN22Info) {
            throw new \InvalidArgumentException(sprintf('The CN22Info property can only contain items of type \shippypro\StructType\CN22Info, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CN22Info[] = $item;
        return $this;
    }
    /**
     * Get ReturnCarrierName value
     * @return string[]|null
     */
    public function getReturnCarrierName()
    {
        return $this->ReturnCarrierName;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnCarrierName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnCarrierName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnCarrierNameForArrayConstraintsFromSetReturnCarrierName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnCarrierNameItem) {
            // validation for constraint: itemType
            if (!is_string($shipReturnCarrierNameItem)) {
                $invalidValues[] = is_object($shipReturnCarrierNameItem) ? get_class($shipReturnCarrierNameItem) : sprintf('%s(%s)', gettype($shipReturnCarrierNameItem), var_export($shipReturnCarrierNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnCarrierName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnCarrierName value
     * @throws \InvalidArgumentException
     * @param string[] $returnCarrierName
     * @return \shippypro\StructType\Ship
     */
    public function setReturnCarrierName(array $returnCarrierName = array())
    {
        // validation for constraint: array
        if ('' !== ($returnCarrierNameArrayErrorMessage = self::validateReturnCarrierNameForArrayConstraintsFromSetReturnCarrierName($returnCarrierName))) {
            throw new \InvalidArgumentException($returnCarrierNameArrayErrorMessage, __LINE__);
        }
        $this->ReturnCarrierName = $returnCarrierName;
        return $this;
    }
    /**
     * Add item to ReturnCarrierName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnCarrierName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReturnCarrierName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnCarrierName[] = $item;
        return $this;
    }
    /**
     * Get ReturnCarrierID value
     * @return float[]|null
     */
    public function getReturnCarrierID()
    {
        return $this->ReturnCarrierID;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnCarrierID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnCarrierID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnCarrierIDForArrayConstraintsFromSetReturnCarrierID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnCarrierIDItem) {
            // validation for constraint: itemType
            if (!(is_float($shipReturnCarrierIDItem) || is_numeric($shipReturnCarrierIDItem))) {
                $invalidValues[] = is_object($shipReturnCarrierIDItem) ? get_class($shipReturnCarrierIDItem) : sprintf('%s(%s)', gettype($shipReturnCarrierIDItem), var_export($shipReturnCarrierIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnCarrierID property can only contain items of type decimal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnCarrierID value
     * @throws \InvalidArgumentException
     * @param float[] $returnCarrierID
     * @return \shippypro\StructType\Ship
     */
    public function setReturnCarrierID(array $returnCarrierID = array())
    {
        // validation for constraint: array
        if ('' !== ($returnCarrierIDArrayErrorMessage = self::validateReturnCarrierIDForArrayConstraintsFromSetReturnCarrierID($returnCarrierID))) {
            throw new \InvalidArgumentException($returnCarrierIDArrayErrorMessage, __LINE__);
        }
        $this->ReturnCarrierID = $returnCarrierID;
        return $this;
    }
    /**
     * Add item to ReturnCarrierID value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnCarrierID($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The ReturnCarrierID property can only contain items of type decimal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnCarrierID[] = $item;
        return $this;
    }
    /**
     * Get ReturnCarrierService value
     * @return string[]|null
     */
    public function getReturnCarrierService()
    {
        return $this->ReturnCarrierService;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnCarrierService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnCarrierService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnCarrierServiceForArrayConstraintsFromSetReturnCarrierService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnCarrierServiceItem) {
            // validation for constraint: itemType
            if (!is_string($shipReturnCarrierServiceItem)) {
                $invalidValues[] = is_object($shipReturnCarrierServiceItem) ? get_class($shipReturnCarrierServiceItem) : sprintf('%s(%s)', gettype($shipReturnCarrierServiceItem), var_export($shipReturnCarrierServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnCarrierService property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnCarrierService value
     * @throws \InvalidArgumentException
     * @param string[] $returnCarrierService
     * @return \shippypro\StructType\Ship
     */
    public function setReturnCarrierService(array $returnCarrierService = array())
    {
        // validation for constraint: array
        if ('' !== ($returnCarrierServiceArrayErrorMessage = self::validateReturnCarrierServiceForArrayConstraintsFromSetReturnCarrierService($returnCarrierService))) {
            throw new \InvalidArgumentException($returnCarrierServiceArrayErrorMessage, __LINE__);
        }
        $this->ReturnCarrierService = $returnCarrierService;
        return $this;
    }
    /**
     * Add item to ReturnCarrierService value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnCarrierService($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReturnCarrierService property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnCarrierService[] = $item;
        return $this;
    }
    /**
     * Get ReturnInsurance value
     * @return string[]|null
     */
    public function getReturnInsurance()
    {
        return $this->ReturnInsurance;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnInsuranceForArrayConstraintsFromSetReturnInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnInsuranceItem) {
            // validation for constraint: itemType
            if (!is_string($shipReturnInsuranceItem)) {
                $invalidValues[] = is_object($shipReturnInsuranceItem) ? get_class($shipReturnInsuranceItem) : sprintf('%s(%s)', gettype($shipReturnInsuranceItem), var_export($shipReturnInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnInsurance property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnInsurance value
     * @throws \InvalidArgumentException
     * @param string[] $returnInsurance
     * @return \shippypro\StructType\Ship
     */
    public function setReturnInsurance(array $returnInsurance = array())
    {
        // validation for constraint: array
        if ('' !== ($returnInsuranceArrayErrorMessage = self::validateReturnInsuranceForArrayConstraintsFromSetReturnInsurance($returnInsurance))) {
            throw new \InvalidArgumentException($returnInsuranceArrayErrorMessage, __LINE__);
        }
        $this->ReturnInsurance = $returnInsurance;
        return $this;
    }
    /**
     * Add item to ReturnInsurance value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnInsurance($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReturnInsurance property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnInsurance[] = $item;
        return $this;
    }
    /**
     * Get ReturnInsuranceCurrency value
     * @return string[]|null
     */
    public function getReturnInsuranceCurrency()
    {
        return $this->ReturnInsuranceCurrency;
    }
    /**
     * This method is responsible for validating the values passed to the setReturnInsuranceCurrency method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturnInsuranceCurrency method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturnInsuranceCurrencyForArrayConstraintsFromSetReturnInsuranceCurrency(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipReturnInsuranceCurrencyItem) {
            // validation for constraint: itemType
            if (!is_string($shipReturnInsuranceCurrencyItem)) {
                $invalidValues[] = is_object($shipReturnInsuranceCurrencyItem) ? get_class($shipReturnInsuranceCurrencyItem) : sprintf('%s(%s)', gettype($shipReturnInsuranceCurrencyItem), var_export($shipReturnInsuranceCurrencyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReturnInsuranceCurrency property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReturnInsuranceCurrency value
     * @throws \InvalidArgumentException
     * @param string[] $returnInsuranceCurrency
     * @return \shippypro\StructType\Ship
     */
    public function setReturnInsuranceCurrency(array $returnInsuranceCurrency = array())
    {
        // validation for constraint: array
        if ('' !== ($returnInsuranceCurrencyArrayErrorMessage = self::validateReturnInsuranceCurrencyForArrayConstraintsFromSetReturnInsuranceCurrency($returnInsuranceCurrency))) {
            throw new \InvalidArgumentException($returnInsuranceCurrencyArrayErrorMessage, __LINE__);
        }
        $this->ReturnInsuranceCurrency = $returnInsuranceCurrency;
        return $this;
    }
    /**
     * Add item to ReturnInsuranceCurrency value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\Ship
     */
    public function addToReturnInsuranceCurrency($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReturnInsuranceCurrency property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReturnInsuranceCurrency[] = $item;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \shippypro\StructType\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * This method is responsible for validating the values passed to the setAttributes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttributes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttributesForArrayConstraintsFromSetAttributes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipAttributesItem) {
            // validation for constraint: itemType
            if (!$shipAttributesItem instanceof \shippypro\StructType\Attribute) {
                $invalidValues[] = is_object($shipAttributesItem) ? get_class($shipAttributesItem) : sprintf('%s(%s)', gettype($shipAttributesItem), var_export($shipAttributesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attributes property can only contain items of type \shippypro\StructType\Attribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attributes value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Attribute[] $attributes
     * @return \shippypro\StructType\Ship
     */
    public function setAttributes(array $attributes = array())
    {
        // validation for constraint: array
        if ('' !== ($attributesArrayErrorMessage = self::validateAttributesForArrayConstraintsFromSetAttributes($attributes))) {
            throw new \InvalidArgumentException($attributesArrayErrorMessage, __LINE__);
        }
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Add item to Attributes value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Attribute $item
     * @return \shippypro\StructType\Ship
     */
    public function addToAttributes(\shippypro\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attributes property can only contain items of type \shippypro\StructType\Attribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attributes[] = $item;
        return $this;
    }
}
