<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The company
     * @var string
     */
    public $company;
    /**
     * The street1
     * @var string
     */
    public $street1;
    /**
     * The street2
     * @var string
     */
    public $street2;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The zip
     * @var string
     */
    public $zip;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The phone
     * @var string
     */
    public $phone;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * Constructor method for Address
     * @uses Address::setName()
     * @uses Address::setCompany()
     * @uses Address::setStreet1()
     * @uses Address::setStreet2()
     * @uses Address::setCity()
     * @uses Address::setState()
     * @uses Address::setZip()
     * @uses Address::setCountry()
     * @uses Address::setPhone()
     * @uses Address::setEmail()
     * @param string $name
     * @param string $company
     * @param string $street1
     * @param string $street2
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $country
     * @param string $phone
     * @param string $email
     */
    public function __construct($name = null, $company = null, $street1 = null, $street2 = null, $city = null, $state = null, $zip = null, $country = null, $phone = null, $email = null)
    {
        $this
            ->setName($name)
            ->setCompany($company)
            ->setStreet1($street1)
            ->setStreet2($street2)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCountry($country)
            ->setPhone($phone)
            ->setEmail($email);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \shippypro\StructType\Address
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \shippypro\StructType\Address
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get street1 value
     * @return string|null
     */
    public function getStreet1()
    {
        return $this->street1;
    }
    /**
     * Set street1 value
     * @param string $street1
     * @return \shippypro\StructType\Address
     */
    public function setStreet1($street1 = null)
    {
        // validation for constraint: string
        if (!is_null($street1) && !is_string($street1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street1, true), gettype($street1)), __LINE__);
        }
        $this->street1 = $street1;
        return $this;
    }
    /**
     * Get street2 value
     * @return string|null
     */
    public function getStreet2()
    {
        return $this->street2;
    }
    /**
     * Set street2 value
     * @param string $street2
     * @return \shippypro\StructType\Address
     */
    public function setStreet2($street2 = null)
    {
        // validation for constraint: string
        if (!is_null($street2) && !is_string($street2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street2, true), gettype($street2)), __LINE__);
        }
        $this->street2 = $street2;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \shippypro\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \shippypro\StructType\Address
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \shippypro\StructType\Address
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \shippypro\StructType\Address
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \shippypro\StructType\Address
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \shippypro\StructType\Address
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
