<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Option StructType
 * @subpackage Structs
 */
class Option_1 extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * The parameters
     * @var \shippypro\StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for Option
     * @uses Option_1::setName()
     * @uses Option_1::setLabel()
     * @uses Option_1::setPrice()
     * @uses Option_1::setParameters()
     * @param string $name
     * @param string $label
     * @param float $price
     * @param \shippypro\StructType\Parameters $parameters
     */
    public function __construct($name = null, $label = null, $price = null, \shippypro\StructType\Parameters $parameters = null)
    {
        $this
            ->setName($name)
            ->setLabel($label)
            ->setPrice($price)
            ->setParameters($parameters);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \shippypro\StructType\Option_1
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \shippypro\StructType\Option_1
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \shippypro\StructType\Option_1
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get parameters value
     * @return \shippypro\StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \shippypro\StructType\Parameters $parameters
     * @return \shippypro\StructType\Option_1
     */
    public function setParameters(\shippypro\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
