<?php

namespace shippypro\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Book ServiceType
 * @subpackage Services
 */
class Book extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BookPickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \shippypro\StructType\BookPickup $parameters
     * @return \shippypro\StructType\BookPickupResponse|bool
     */
    public function BookPickup(\shippypro\StructType\BookPickup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BookPickup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \shippypro\StructType\BookPickupResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
