<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRatesResponse StructType
 * @subpackage Structs
 */
class GetRatesResponse extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \shippypro\StructType\Rate[]
     */
    public $Rates;
    /**
     * Constructor method for GetRatesResponse
     * @uses GetRatesResponse::setRates()
     * @param \shippypro\StructType\Rate[] $rates
     */
    public function __construct(array $rates = array())
    {
        $this
            ->setRates($rates);
    }
    /**
     * Get Rates value
     * @return \shippypro\StructType\Rate[]|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * This method is responsible for validating the values passed to the setRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatesForArrayConstraintsFromSetRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getRatesResponseRatesItem) {
            // validation for constraint: itemType
            if (!$getRatesResponseRatesItem instanceof \shippypro\StructType\Rate) {
                $invalidValues[] = is_object($getRatesResponseRatesItem) ? get_class($getRatesResponseRatesItem) : sprintf('%s(%s)', gettype($getRatesResponseRatesItem), var_export($getRatesResponseRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rates property can only contain items of type \shippypro\StructType\Rate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rates value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Rate[] $rates
     * @return \shippypro\StructType\GetRatesResponse
     */
    public function setRates(array $rates = array())
    {
        // validation for constraint: array
        if ('' !== ($ratesArrayErrorMessage = self::validateRatesForArrayConstraintsFromSetRates($rates))) {
            throw new \InvalidArgumentException($ratesArrayErrorMessage, __LINE__);
        }
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Add item to Rates value
     * @throws \InvalidArgumentException
     * @param \shippypro\StructType\Rate $item
     * @return \shippypro\StructType\GetRatesResponse
     */
    public function addToRates(\shippypro\StructType\Rate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \shippypro\StructType\Rate) {
            throw new \InvalidArgumentException(sprintf('The Rates property can only contain items of type \shippypro\StructType\Rate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rates[] = $item;
        return $this;
    }
}
