<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCarrierOptions StructType
 * @subpackage Structs
 */
class GetCarrierOptions extends AbstractStructBase
{
    /**
     * The CarrierName
     * @var string
     */
    public $CarrierName;
    /**
     * The CarrierID
     * @var float
     */
    public $CarrierID;
    /**
     * The to_address
     * @var \shippypro\StructType\To_address
     */
    public $to_address;
    /**
     * Constructor method for GetCarrierOptions
     * @uses GetCarrierOptions::setCarrierName()
     * @uses GetCarrierOptions::setCarrierID()
     * @uses GetCarrierOptions::setTo_address()
     * @param string $carrierName
     * @param float $carrierID
     * @param \shippypro\StructType\To_address $to_address
     */
    public function __construct($carrierName = null, $carrierID = null, \shippypro\StructType\To_address $to_address = null)
    {
        $this
            ->setCarrierName($carrierName)
            ->setCarrierID($carrierID)
            ->setTo_address($to_address);
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \shippypro\StructType\GetCarrierOptions
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get CarrierID value
     * @return float|null
     */
    public function getCarrierID()
    {
        return $this->CarrierID;
    }
    /**
     * Set CarrierID value
     * @param float $carrierID
     * @return \shippypro\StructType\GetCarrierOptions
     */
    public function setCarrierID($carrierID = null)
    {
        // validation for constraint: float
        if (!is_null($carrierID) && !(is_float($carrierID) || is_numeric($carrierID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carrierID, true), gettype($carrierID)), __LINE__);
        }
        $this->CarrierID = $carrierID;
        return $this;
    }
    /**
     * Get to_address value
     * @return \shippypro\StructType\To_address|null
     */
    public function getTo_address()
    {
        return $this->to_address;
    }
    /**
     * Set to_address value
     * @param \shippypro\StructType\To_address $to_address
     * @return \shippypro\StructType\GetCarrierOptions
     */
    public function setTo_address(\shippypro\StructType\To_address $to_address = null)
    {
        $this->to_address = $to_address;
        return $this;
    }
}
