<?php

namespace shippypro;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'Address' => '\\shippypro\\StructType\\Address',
            'Parcel' => '\\shippypro\\StructType\\Parcel_1',
            'CarrierOption' => '\\shippypro\\StructType\\CarrierOption',
            'CN22Info' => '\\shippypro\\StructType\\CN22Info',
            'Attribute' => '\\shippypro\\StructType\\Attribute',
            'Rate' => '\\shippypro\\StructType\\Rate',
            'TrackingEvent' => '\\shippypro\\StructType\\TrackingEvent',
            'GetLabelUrlResponse' => '\\shippypro\\StructType\\GetLabelUrlResponse',
            'GetLabelUrl' => '\\shippypro\\StructType\\GetLabelUrl',
            'GetOrderResponse' => '\\shippypro\\StructType\\GetOrderResponse',
            'GetOrder' => '\\shippypro\\StructType\\GetOrder',
            'GetRatesResponse' => '\\shippypro\\StructType\\GetRatesResponse',
            'GetRates' => '\\shippypro\\StructType\\GetRates',
            'GetTrackingResponse' => '\\shippypro\\StructType\\GetTrackingResponse',
            'GetTracking' => '\\shippypro\\StructType\\GetTracking',
            'ShipResponse' => '\\shippypro\\StructType\\ShipResponse',
            'Ship' => '\\shippypro\\StructType\\Ship',
            'EditResponse' => '\\shippypro\\StructType\\EditResponse',
            'Edit' => '\\shippypro\\StructType\\Edit',
            'CreateManifestResponse' => '\\shippypro\\StructType\\CreateManifestResponse',
            'CreateManifest' => '\\shippypro\\StructType\\CreateManifest',
            'UploadPaperlessDocumentationResponse' => '\\shippypro\\StructType\\UploadPaperlessDocumentationResponse',
            'UploadPaperlessDocumentation' => '\\shippypro\\StructType\\UploadPaperlessDocumentation',
            'CloseShipmentsResponse' => '\\shippypro\\StructType\\CloseShipmentsResponse',
            'CloseShipments' => '\\shippypro\\StructType\\CloseShipments',
            'VoidShipmentsResponse' => '\\shippypro\\StructType\\VoidShipmentsResponse',
            'VoidShipments' => '\\shippypro\\StructType\\VoidShipments',
            'GetManifestResponse' => '\\shippypro\\StructType\\GetManifestResponse',
            'GetManifest' => '\\shippypro\\StructType\\GetManifest',
            'DeleteManifestResponse' => '\\shippypro\\StructType\\DeleteManifestResponse',
            'DeleteManifest' => '\\shippypro\\StructType\\DeleteManifest',
            'GetCarrierOptionsResponse' => '\\shippypro\\StructType\\GetCarrierOptionsResponse',
            'Option' => '\\shippypro\\StructType\\Option_1',
            'parameters' => '\\shippypro\\StructType\\Parameters',
            'GetCarrierOptions' => '\\shippypro\\StructType\\GetCarrierOptions',
            'to_address' => '\\shippypro\\StructType\\To_address',
            'BookPickupResponse' => '\\shippypro\\StructType\\BookPickupResponse',
            'BookPickup' => '\\shippypro\\StructType\\BookPickup',
        );
    }
}
