<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingEvent StructType
 * @subpackage Structs
 */
class TrackingEvent extends AbstractStructBase
{
    /**
     * The date
     * @var string
     */
    public $date;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * Constructor method for TrackingEvent
     * @uses TrackingEvent::setDate()
     * @uses TrackingEvent::setMessage()
     * @uses TrackingEvent::setCity()
     * @param string $date
     * @param string $message
     * @param string $city
     */
    public function __construct($date = null, $message = null, $city = null)
    {
        $this
            ->setDate($date)
            ->setMessage($message)
            ->setCity($city);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \shippypro\StructType\TrackingEvent
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \shippypro\StructType\TrackingEvent
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \shippypro\StructType\TrackingEvent
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
}
