<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrder StructType
 * @subpackage Structs
 */
class GetOrder extends AbstractStructBase
{
    /**
     * The OrderID
     * @var float
     */
    public $OrderID;
    /**
     * Constructor method for GetOrder
     * @uses GetOrder::setOrderID()
     * @param float $orderID
     */
    public function __construct($orderID = null)
    {
        $this
            ->setOrderID($orderID);
    }
    /**
     * Get OrderID value
     * @return float|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param float $orderID
     * @return \shippypro\StructType\GetOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: float
        if (!is_null($orderID) && !(is_float($orderID) || is_numeric($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
}
