<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetManifestResponse StructType
 * @subpackage Structs
 */
class GetManifestResponse extends AbstractStructBase
{
    /**
     * The Result
     * @var string
     */
    public $Result;
    /**
     * The ErrorMessage
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * The ManifestNumber
     * @var string
     */
    public $ManifestNumber;
    /**
     * The ManifestURL
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $ManifestURL;
    /**
     * The OrderIDS
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxOccurs: unbounded
     * @var int[]
     */
    public $OrderIDS;
    /**
     * Constructor method for GetManifestResponse
     * @uses GetManifestResponse::setResult()
     * @uses GetManifestResponse::setErrorMessage()
     * @uses GetManifestResponse::setError()
     * @uses GetManifestResponse::setManifestNumber()
     * @uses GetManifestResponse::setManifestURL()
     * @uses GetManifestResponse::setOrderIDS()
     * @param string $result
     * @param string $errorMessage
     * @param string $error
     * @param string $manifestNumber
     * @param string[] $manifestURL
     * @param int[] $orderIDS
     */
    public function __construct($result = null, $errorMessage = null, $error = null, $manifestNumber = null, array $manifestURL = array(), array $orderIDS = array())
    {
        $this
            ->setResult($result)
            ->setErrorMessage($errorMessage)
            ->setError($error)
            ->setManifestNumber($manifestNumber)
            ->setManifestURL($manifestURL)
            ->setOrderIDS($orderIDS);
    }
    /**
     * Get Result value
     * @return string|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param string $result
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setResult($result = null)
    {
        // validation for constraint: string
        if (!is_null($result) && !is_string($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get ManifestNumber value
     * @return string|null
     */
    public function getManifestNumber()
    {
        return $this->ManifestNumber;
    }
    /**
     * Set ManifestNumber value
     * @param string $manifestNumber
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setManifestNumber($manifestNumber = null)
    {
        // validation for constraint: string
        if (!is_null($manifestNumber) && !is_string($manifestNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestNumber, true), gettype($manifestNumber)), __LINE__);
        }
        $this->ManifestNumber = $manifestNumber;
        return $this;
    }
    /**
     * Get ManifestURL value
     * @return string[]|null
     */
    public function getManifestURL()
    {
        return $this->ManifestURL;
    }
    /**
     * This method is responsible for validating the values passed to the setManifestURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManifestURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManifestURLForArrayConstraintsFromSetManifestURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getManifestResponseManifestURLItem) {
            // validation for constraint: itemType
            if (!is_string($getManifestResponseManifestURLItem)) {
                $invalidValues[] = is_object($getManifestResponseManifestURLItem) ? get_class($getManifestResponseManifestURLItem) : sprintf('%s(%s)', gettype($getManifestResponseManifestURLItem), var_export($getManifestResponseManifestURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ManifestURL property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ManifestURL value
     * @throws \InvalidArgumentException
     * @param string[] $manifestURL
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setManifestURL(array $manifestURL = array())
    {
        // validation for constraint: array
        if ('' !== ($manifestURLArrayErrorMessage = self::validateManifestURLForArrayConstraintsFromSetManifestURL($manifestURL))) {
            throw new \InvalidArgumentException($manifestURLArrayErrorMessage, __LINE__);
        }
        $this->ManifestURL = $manifestURL;
        return $this;
    }
    /**
     * Add item to ManifestURL value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function addToManifestURL($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ManifestURL property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ManifestURL[] = $item;
        return $this;
    }
    /**
     * Get OrderIDS value
     * @return int[]|null
     */
    public function getOrderIDS()
    {
        return $this->OrderIDS;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderIDS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderIDS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderIDSForArrayConstraintsFromSetOrderIDS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getManifestResponseOrderIDSItem) {
            // validation for constraint: itemType
            if (!(is_int($getManifestResponseOrderIDSItem) || ctype_digit($getManifestResponseOrderIDSItem))) {
                $invalidValues[] = is_object($getManifestResponseOrderIDSItem) ? get_class($getManifestResponseOrderIDSItem) : sprintf('%s(%s)', gettype($getManifestResponseOrderIDSItem), var_export($getManifestResponseOrderIDSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderIDS value
     * @throws \InvalidArgumentException
     * @param int[] $orderIDS
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function setOrderIDS(array $orderIDS = array())
    {
        // validation for constraint: array
        if ('' !== ($orderIDSArrayErrorMessage = self::validateOrderIDSForArrayConstraintsFromSetOrderIDS($orderIDS))) {
            throw new \InvalidArgumentException($orderIDSArrayErrorMessage, __LINE__);
        }
        $this->OrderIDS = $orderIDS;
        return $this;
    }
    /**
     * Add item to OrderIDS value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \shippypro\StructType\GetManifestResponse
     */
    public function addToOrderIDS($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderIDS[] = $item;
        return $this;
    }
}
