<?php

namespace shippypro\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseShipments StructType
 * @subpackage Structs
 */
class CloseShipments extends AbstractStructBase
{
    /**
     * The OrderIDS
     * Meta information extracted from the WSDL
     * - base: integer
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $OrderIDS;
    /**
     * The CarrierName
     * @var string
     */
    public $CarrierName;
    /**
     * Constructor method for CloseShipments
     * @uses CloseShipments::setOrderIDS()
     * @uses CloseShipments::setCarrierName()
     * @param int[] $orderIDS
     * @param string $carrierName
     */
    public function __construct(array $orderIDS = array(), $carrierName = null)
    {
        $this
            ->setOrderIDS($orderIDS)
            ->setCarrierName($carrierName);
    }
    /**
     * Get OrderIDS value
     * @return int[]|null
     */
    public function getOrderIDS()
    {
        return $this->OrderIDS;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderIDS method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderIDS method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderIDSForArrayConstraintsFromSetOrderIDS(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $closeShipmentsOrderIDSItem) {
            // validation for constraint: itemType
            if (!(is_int($closeShipmentsOrderIDSItem) || ctype_digit($closeShipmentsOrderIDSItem))) {
                $invalidValues[] = is_object($closeShipmentsOrderIDSItem) ? get_class($closeShipmentsOrderIDSItem) : sprintf('%s(%s)', gettype($closeShipmentsOrderIDSItem), var_export($closeShipmentsOrderIDSItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderIDS value
     * @throws \InvalidArgumentException
     * @param int[] $orderIDS
     * @return \shippypro\StructType\CloseShipments
     */
    public function setOrderIDS(array $orderIDS = array())
    {
        // validation for constraint: array
        if ('' !== ($orderIDSArrayErrorMessage = self::validateOrderIDSForArrayConstraintsFromSetOrderIDS($orderIDS))) {
            throw new \InvalidArgumentException($orderIDSArrayErrorMessage, __LINE__);
        }
        $this->OrderIDS = $orderIDS;
        return $this;
    }
    /**
     * Add item to OrderIDS value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \shippypro\StructType\CloseShipments
     */
    public function addToOrderIDS($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The OrderIDS property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderIDS[] = $item;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \shippypro\StructType\CloseShipments
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
}
