<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SezioniBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che riporta tutte le zone censuarie di un comuneAttenzione: non tutti i comuni possiedono una zona censuaria
 * @subpackage Structs
 */
class SezioniBean_Type extends AbstractStructBase
{
    /**
     * The codiceSezione
     * Meta information extracted from the WSDL
     * - documentation: Codice della sezione censuaria del comune
     * - nillable: true
     * @var string
     */
    public $codiceSezione;
    /**
     * The comune
     * Meta information extracted from the WSDL
     * - documentation: codice del Comune
     * - nillable: true
     * @var string
     */
    public $comune;
    /**
     * The descrizione
     * Meta information extracted from the WSDL
     * - documentation: Descrizione della sezione censuaria
     * - nillable: true
     * @var string
     */
    public $descrizione;
    /**
     * Constructor method for SezioniBean_Type
     * @uses SezioniBean_Type::setCodiceSezione()
     * @uses SezioniBean_Type::setComune()
     * @uses SezioniBean_Type::setDescrizione()
     * @param string $codiceSezione
     * @param string $comune
     * @param string $descrizione
     */
    public function __construct($codiceSezione = null, $comune = null, $descrizione = null)
    {
        $this
            ->setCodiceSezione($codiceSezione)
            ->setComune($comune)
            ->setDescrizione($descrizione);
    }
    /**
     * Get codiceSezione value
     * @return string|null
     */
    public function getCodiceSezione()
    {
        return $this->codiceSezione;
    }
    /**
     * Set codiceSezione value
     * @param string $codiceSezione
     * @return \Sisteract\StructType\SezioniBean_Type
     */
    public function setCodiceSezione($codiceSezione = null)
    {
        // validation for constraint: string
        if (!is_null($codiceSezione) && !is_string($codiceSezione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceSezione, true), gettype($codiceSezione)), __LINE__);
        }
        $this->codiceSezione = $codiceSezione;
        return $this;
    }
    /**
     * Get comune value
     * @return string|null
     */
    public function getComune()
    {
        return $this->comune;
    }
    /**
     * Set comune value
     * @param string $comune
     * @return \Sisteract\StructType\SezioniBean_Type
     */
    public function setComune($comune = null)
    {
        // validation for constraint: string
        if (!is_null($comune) && !is_string($comune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comune, true), gettype($comune)), __LINE__);
        }
        $this->comune = $comune;
        return $this;
    }
    /**
     * Get descrizione value
     * @return string|null
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }
    /**
     * Set descrizione value
     * @param string $descrizione
     * @return \Sisteract\StructType\SezioniBean_Type
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        $this->descrizione = $descrizione;
        return $this;
    }
}
