<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPersoneGiuridicheList_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean di risposta che riporta tuitte le persone giuridiche trovatecon la ricerca per persona giuridica
 * @subpackage Structs
 */
class ReturnPersoneGiuridicheList_Type extends Session_Type
{
    /**
     * The binFile
     * Meta information extracted from the WSDL
     * - documentation: Se RitornatoValori e' false (nessuna persona giuridica tornata)continene il pdf ufficile di negativita'
     * - nillable: true
     * @var string
     */
    public $binFile;
    /**
     * The listPersoneGiuridicheBean
     * Meta information extracted from the WSDL
     * - documentation: Lista delle persone giuridiche tornate
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sisteract\StructType\PersoneGiuridicheBean_Type[]
     */
    public $listPersoneGiuridicheBean;
    /**
     * The mimeType
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il mimeType del file binario
     * - nillable: true
     * @var string
     */
    public $mimeType;
    /**
     * The nomeFile
     * Meta information extracted from the WSDL
     * - documentation: ritorna il nome del file dato dal sistema
     * - nillable: true
     * @var string
     */
    public $nomeFile;
    /**
     * The probabileErrore
     * @var bool
     */
    public $probabileErrore;
    /**
     * The ritornatoValori
     * Meta information extracted from the WSDL
     * - documentation: Ritorna true se sono state trovate persone giuridiche.
     * @var bool
     */
    public $ritornatoValori;
    /**
     * Constructor method for ReturnPersoneGiuridicheList_Type
     * @uses ReturnPersoneGiuridicheList_Type::setBinFile()
     * @uses ReturnPersoneGiuridicheList_Type::setListPersoneGiuridicheBean()
     * @uses ReturnPersoneGiuridicheList_Type::setMimeType()
     * @uses ReturnPersoneGiuridicheList_Type::setNomeFile()
     * @uses ReturnPersoneGiuridicheList_Type::setProbabileErrore()
     * @uses ReturnPersoneGiuridicheList_Type::setRitornatoValori()
     * @param string $binFile
     * @param \Sisteract\StructType\PersoneGiuridicheBean_Type[] $listPersoneGiuridicheBean
     * @param string $mimeType
     * @param string $nomeFile
     * @param bool $probabileErrore
     * @param bool $ritornatoValori
     */
    public function __construct($binFile = null, array $listPersoneGiuridicheBean = array(), $mimeType = null, $nomeFile = null, $probabileErrore = null, $ritornatoValori = null)
    {
        $this
            ->setBinFile($binFile)
            ->setListPersoneGiuridicheBean($listPersoneGiuridicheBean)
            ->setMimeType($mimeType)
            ->setNomeFile($nomeFile)
            ->setProbabileErrore($probabileErrore)
            ->setRitornatoValori($ritornatoValori);
    }
    /**
     * Get binFile value
     * @return string|null
     */
    public function getBinFile()
    {
        return $this->binFile;
    }
    /**
     * Set binFile value
     * @param string $binFile
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setBinFile($binFile = null)
    {
        // validation for constraint: string
        if (!is_null($binFile) && !is_string($binFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binFile, true), gettype($binFile)), __LINE__);
        }
        $this->binFile = $binFile;
        return $this;
    }
    /**
     * Get listPersoneGiuridicheBean value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type[]|null
     */
    public function getListPersoneGiuridicheBean()
    {
        return isset($this->listPersoneGiuridicheBean) ? $this->listPersoneGiuridicheBean : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListPersoneGiuridicheBean method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListPersoneGiuridicheBean method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListPersoneGiuridicheBeanForArrayConstraintsFromSetListPersoneGiuridicheBean(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem) {
            // validation for constraint: itemType
            if (!$returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem instanceof \Sisteract\StructType\PersoneGiuridicheBean_Type) {
                $invalidValues[] = is_object($returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem) ? get_class($returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem) : sprintf('%s(%s)', gettype($returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem), var_export($returnPersoneGiuridicheList_TypeListPersoneGiuridicheBeanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listPersoneGiuridicheBean property can only contain items of type \Sisteract\StructType\PersoneGiuridicheBean_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listPersoneGiuridicheBean value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PersoneGiuridicheBean_Type[] $listPersoneGiuridicheBean
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setListPersoneGiuridicheBean(array $listPersoneGiuridicheBean = array())
    {
        // validation for constraint: array
        if ('' !== ($listPersoneGiuridicheBeanArrayErrorMessage = self::validateListPersoneGiuridicheBeanForArrayConstraintsFromSetListPersoneGiuridicheBean($listPersoneGiuridicheBean))) {
            throw new \InvalidArgumentException($listPersoneGiuridicheBeanArrayErrorMessage, __LINE__);
        }
        if (is_null($listPersoneGiuridicheBean) || (is_array($listPersoneGiuridicheBean) && empty($listPersoneGiuridicheBean))) {
            unset($this->listPersoneGiuridicheBean);
        } else {
            $this->listPersoneGiuridicheBean = $listPersoneGiuridicheBean;
        }
        return $this;
    }
    /**
     * Add item to listPersoneGiuridicheBean value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PersoneGiuridicheBean_Type $item
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function addToListPersoneGiuridicheBean(\Sisteract\StructType\PersoneGiuridicheBean_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\PersoneGiuridicheBean_Type) {
            throw new \InvalidArgumentException(sprintf('The listPersoneGiuridicheBean property can only contain items of type \Sisteract\StructType\PersoneGiuridicheBean_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listPersoneGiuridicheBean[] = $item;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get nomeFile value
     * @return string|null
     */
    public function getNomeFile()
    {
        return $this->nomeFile;
    }
    /**
     * Set nomeFile value
     * @param string $nomeFile
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setNomeFile($nomeFile = null)
    {
        // validation for constraint: string
        if (!is_null($nomeFile) && !is_string($nomeFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeFile, true), gettype($nomeFile)), __LINE__);
        }
        $this->nomeFile = $nomeFile;
        return $this;
    }
    /**
     * Get probabileErrore value
     * @return bool|null
     */
    public function getProbabileErrore()
    {
        return $this->probabileErrore;
    }
    /**
     * Set probabileErrore value
     * @param bool $probabileErrore
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setProbabileErrore($probabileErrore = null)
    {
        // validation for constraint: boolean
        if (!is_null($probabileErrore) && !is_bool($probabileErrore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($probabileErrore, true), gettype($probabileErrore)), __LINE__);
        }
        $this->probabileErrore = $probabileErrore;
        return $this;
    }
    /**
     * Get ritornatoValori value
     * @return bool|null
     */
    public function getRitornatoValori()
    {
        return $this->ritornatoValori;
    }
    /**
     * Set ritornatoValori value
     * @param bool $ritornatoValori
     * @return \Sisteract\StructType\ReturnPersoneGiuridicheList_Type
     */
    public function setRitornatoValori($ritornatoValori = null)
    {
        // validation for constraint: boolean
        if (!is_null($ritornatoValori) && !is_bool($ritornatoValori)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ritornatoValori, true), gettype($ritornatoValori)), __LINE__);
        }
        $this->ritornatoValori = $ritornatoValori;
        return $this;
    }
}
