<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnPersoneFisicheList_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean di risposta che riporta tuitte le persone fisiche trovatecon la ricerca per persona fisica
 * @subpackage Structs
 */
class ReturnPersoneFisicheList_Type extends Session_Type
{
    /**
     * The binFile
     * Meta information extracted from the WSDL
     * - documentation: Se RitornatoValori e' false (nessuna persona fisica tornata)continene il pdf ufficile di negativita'
     * - nillable: true
     * @var string
     */
    public $binFile;
    /**
     * The listPersoneFisicheBean
     * Meta information extracted from the WSDL
     * - documentation: Lista delle persone fisiche tornate
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sisteract\StructType\PersoneFisicheBean_Type[]
     */
    public $listPersoneFisicheBean;
    /**
     * The mimeType
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il mimeType del file binario
     * - nillable: true
     * @var string
     */
    public $mimeType;
    /**
     * The nomeFile
     * Meta information extracted from the WSDL
     * - documentation: ritorna il nome del file dato dal sistema
     * - nillable: true
     * @var string
     */
    public $nomeFile;
    /**
     * The probabileErrore
     * @var bool
     */
    public $probabileErrore;
    /**
     * The ritornatoValori
     * Meta information extracted from the WSDL
     * - documentation: Ritorna true se sono state trovate persone fisiche.
     * @var bool
     */
    public $ritornatoValori;
    /**
     * Constructor method for ReturnPersoneFisicheList_Type
     * @uses ReturnPersoneFisicheList_Type::setBinFile()
     * @uses ReturnPersoneFisicheList_Type::setListPersoneFisicheBean()
     * @uses ReturnPersoneFisicheList_Type::setMimeType()
     * @uses ReturnPersoneFisicheList_Type::setNomeFile()
     * @uses ReturnPersoneFisicheList_Type::setProbabileErrore()
     * @uses ReturnPersoneFisicheList_Type::setRitornatoValori()
     * @param string $binFile
     * @param \Sisteract\StructType\PersoneFisicheBean_Type[] $listPersoneFisicheBean
     * @param string $mimeType
     * @param string $nomeFile
     * @param bool $probabileErrore
     * @param bool $ritornatoValori
     */
    public function __construct($binFile = null, array $listPersoneFisicheBean = array(), $mimeType = null, $nomeFile = null, $probabileErrore = null, $ritornatoValori = null)
    {
        $this
            ->setBinFile($binFile)
            ->setListPersoneFisicheBean($listPersoneFisicheBean)
            ->setMimeType($mimeType)
            ->setNomeFile($nomeFile)
            ->setProbabileErrore($probabileErrore)
            ->setRitornatoValori($ritornatoValori);
    }
    /**
     * Get binFile value
     * @return string|null
     */
    public function getBinFile()
    {
        return $this->binFile;
    }
    /**
     * Set binFile value
     * @param string $binFile
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setBinFile($binFile = null)
    {
        // validation for constraint: string
        if (!is_null($binFile) && !is_string($binFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binFile, true), gettype($binFile)), __LINE__);
        }
        $this->binFile = $binFile;
        return $this;
    }
    /**
     * Get listPersoneFisicheBean value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sisteract\StructType\PersoneFisicheBean_Type[]|null
     */
    public function getListPersoneFisicheBean()
    {
        return isset($this->listPersoneFisicheBean) ? $this->listPersoneFisicheBean : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListPersoneFisicheBean method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListPersoneFisicheBean method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListPersoneFisicheBeanForArrayConstraintsFromSetListPersoneFisicheBean(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnPersoneFisicheList_TypeListPersoneFisicheBeanItem) {
            // validation for constraint: itemType
            if (!$returnPersoneFisicheList_TypeListPersoneFisicheBeanItem instanceof \Sisteract\StructType\PersoneFisicheBean_Type) {
                $invalidValues[] = is_object($returnPersoneFisicheList_TypeListPersoneFisicheBeanItem) ? get_class($returnPersoneFisicheList_TypeListPersoneFisicheBeanItem) : sprintf('%s(%s)', gettype($returnPersoneFisicheList_TypeListPersoneFisicheBeanItem), var_export($returnPersoneFisicheList_TypeListPersoneFisicheBeanItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listPersoneFisicheBean property can only contain items of type \Sisteract\StructType\PersoneFisicheBean_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listPersoneFisicheBean value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PersoneFisicheBean_Type[] $listPersoneFisicheBean
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setListPersoneFisicheBean(array $listPersoneFisicheBean = array())
    {
        // validation for constraint: array
        if ('' !== ($listPersoneFisicheBeanArrayErrorMessage = self::validateListPersoneFisicheBeanForArrayConstraintsFromSetListPersoneFisicheBean($listPersoneFisicheBean))) {
            throw new \InvalidArgumentException($listPersoneFisicheBeanArrayErrorMessage, __LINE__);
        }
        if (is_null($listPersoneFisicheBean) || (is_array($listPersoneFisicheBean) && empty($listPersoneFisicheBean))) {
            unset($this->listPersoneFisicheBean);
        } else {
            $this->listPersoneFisicheBean = $listPersoneFisicheBean;
        }
        return $this;
    }
    /**
     * Add item to listPersoneFisicheBean value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PersoneFisicheBean_Type $item
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function addToListPersoneFisicheBean(\Sisteract\StructType\PersoneFisicheBean_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\PersoneFisicheBean_Type) {
            throw new \InvalidArgumentException(sprintf('The listPersoneFisicheBean property can only contain items of type \Sisteract\StructType\PersoneFisicheBean_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listPersoneFisicheBean[] = $item;
        return $this;
    }
    /**
     * Get mimeType value
     * @return string|null
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * Set mimeType value
     * @param string $mimeType
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setMimeType($mimeType = null)
    {
        // validation for constraint: string
        if (!is_null($mimeType) && !is_string($mimeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeType, true), gettype($mimeType)), __LINE__);
        }
        $this->mimeType = $mimeType;
        return $this;
    }
    /**
     * Get nomeFile value
     * @return string|null
     */
    public function getNomeFile()
    {
        return $this->nomeFile;
    }
    /**
     * Set nomeFile value
     * @param string $nomeFile
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setNomeFile($nomeFile = null)
    {
        // validation for constraint: string
        if (!is_null($nomeFile) && !is_string($nomeFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeFile, true), gettype($nomeFile)), __LINE__);
        }
        $this->nomeFile = $nomeFile;
        return $this;
    }
    /**
     * Get probabileErrore value
     * @return bool|null
     */
    public function getProbabileErrore()
    {
        return $this->probabileErrore;
    }
    /**
     * Set probabileErrore value
     * @param bool $probabileErrore
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setProbabileErrore($probabileErrore = null)
    {
        // validation for constraint: boolean
        if (!is_null($probabileErrore) && !is_bool($probabileErrore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($probabileErrore, true), gettype($probabileErrore)), __LINE__);
        }
        $this->probabileErrore = $probabileErrore;
        return $this;
    }
    /**
     * Get ritornatoValori value
     * @return bool|null
     */
    public function getRitornatoValori()
    {
        return $this->ritornatoValori;
    }
    /**
     * Set ritornatoValori value
     * @param bool $ritornatoValori
     * @return \Sisteract\StructType\ReturnPersoneFisicheList_Type
     */
    public function setRitornatoValori($ritornatoValori = null)
    {
        // validation for constraint: boolean
        if (!is_null($ritornatoValori) && !is_bool($ritornatoValori)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ritornatoValori, true), gettype($ritornatoValori)), __LINE__);
        }
        $this->ritornatoValori = $ritornatoValori;
        return $this;
    }
}
