<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnIndirizziList_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che contiene il risultato della ricerca degli indirizzi senza toponimoall'interno di uno specifico comune
 * @subpackage Structs
 */
class ReturnIndirizziList_Type extends Session_Type
{
    /**
     * The listaIndirizziTrovati
     * Meta information extracted from the WSDL
     * - documentation: Lista degli indirizzi trovati
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Sisteract\StructType\IndirizziBean_Type[]
     */
    public $listaIndirizziTrovati;
    /**
     * The numeroA
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di arrivo
     * - nillable: true
     * @var string
     */
    public $numeroA;
    /**
     * The numeroDa
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di partenza
     * - nillable: true
     * @var string
     */
    public $numeroDa;
    /**
     * The probabileErrore
     * @var bool
     */
    public $probabileErrore;
    /**
     * The ritornatoIndirizzi
     * Meta information extracted from the WSDL
     * - documentation: Indica se sono stati trovati indirizzi sul comune
     * @var bool
     */
    public $ritornatoIndirizzi;
    /**
     * Constructor method for ReturnIndirizziList_Type
     * @uses ReturnIndirizziList_Type::setListaIndirizziTrovati()
     * @uses ReturnIndirizziList_Type::setNumeroA()
     * @uses ReturnIndirizziList_Type::setNumeroDa()
     * @uses ReturnIndirizziList_Type::setProbabileErrore()
     * @uses ReturnIndirizziList_Type::setRitornatoIndirizzi()
     * @param \Sisteract\StructType\IndirizziBean_Type[] $listaIndirizziTrovati
     * @param string $numeroA
     * @param string $numeroDa
     * @param bool $probabileErrore
     * @param bool $ritornatoIndirizzi
     */
    public function __construct(array $listaIndirizziTrovati = array(), $numeroA = null, $numeroDa = null, $probabileErrore = null, $ritornatoIndirizzi = null)
    {
        $this
            ->setListaIndirizziTrovati($listaIndirizziTrovati)
            ->setNumeroA($numeroA)
            ->setNumeroDa($numeroDa)
            ->setProbabileErrore($probabileErrore)
            ->setRitornatoIndirizzi($ritornatoIndirizzi);
    }
    /**
     * Get listaIndirizziTrovati value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Sisteract\StructType\IndirizziBean_Type[]|null
     */
    public function getListaIndirizziTrovati()
    {
        return isset($this->listaIndirizziTrovati) ? $this->listaIndirizziTrovati : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListaIndirizziTrovati method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListaIndirizziTrovati method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListaIndirizziTrovatiForArrayConstraintsFromSetListaIndirizziTrovati(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnIndirizziList_TypeListaIndirizziTrovatiItem) {
            // validation for constraint: itemType
            if (!$returnIndirizziList_TypeListaIndirizziTrovatiItem instanceof \Sisteract\StructType\IndirizziBean_Type) {
                $invalidValues[] = is_object($returnIndirizziList_TypeListaIndirizziTrovatiItem) ? get_class($returnIndirizziList_TypeListaIndirizziTrovatiItem) : sprintf('%s(%s)', gettype($returnIndirizziList_TypeListaIndirizziTrovatiItem), var_export($returnIndirizziList_TypeListaIndirizziTrovatiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listaIndirizziTrovati property can only contain items of type \Sisteract\StructType\IndirizziBean_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listaIndirizziTrovati value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\IndirizziBean_Type[] $listaIndirizziTrovati
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function setListaIndirizziTrovati(array $listaIndirizziTrovati = array())
    {
        // validation for constraint: array
        if ('' !== ($listaIndirizziTrovatiArrayErrorMessage = self::validateListaIndirizziTrovatiForArrayConstraintsFromSetListaIndirizziTrovati($listaIndirizziTrovati))) {
            throw new \InvalidArgumentException($listaIndirizziTrovatiArrayErrorMessage, __LINE__);
        }
        if (is_null($listaIndirizziTrovati) || (is_array($listaIndirizziTrovati) && empty($listaIndirizziTrovati))) {
            unset($this->listaIndirizziTrovati);
        } else {
            $this->listaIndirizziTrovati = $listaIndirizziTrovati;
        }
        return $this;
    }
    /**
     * Add item to listaIndirizziTrovati value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\IndirizziBean_Type $item
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function addToListaIndirizziTrovati(\Sisteract\StructType\IndirizziBean_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\IndirizziBean_Type) {
            throw new \InvalidArgumentException(sprintf('The listaIndirizziTrovati property can only contain items of type \Sisteract\StructType\IndirizziBean_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listaIndirizziTrovati[] = $item;
        return $this;
    }
    /**
     * Get numeroA value
     * @return string|null
     */
    public function getNumeroA()
    {
        return $this->numeroA;
    }
    /**
     * Set numeroA value
     * @param string $numeroA
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function setNumeroA($numeroA = null)
    {
        // validation for constraint: string
        if (!is_null($numeroA) && !is_string($numeroA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroA, true), gettype($numeroA)), __LINE__);
        }
        $this->numeroA = $numeroA;
        return $this;
    }
    /**
     * Get numeroDa value
     * @return string|null
     */
    public function getNumeroDa()
    {
        return $this->numeroDa;
    }
    /**
     * Set numeroDa value
     * @param string $numeroDa
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function setNumeroDa($numeroDa = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDa) && !is_string($numeroDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDa, true), gettype($numeroDa)), __LINE__);
        }
        $this->numeroDa = $numeroDa;
        return $this;
    }
    /**
     * Get probabileErrore value
     * @return bool|null
     */
    public function getProbabileErrore()
    {
        return $this->probabileErrore;
    }
    /**
     * Set probabileErrore value
     * @param bool $probabileErrore
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function setProbabileErrore($probabileErrore = null)
    {
        // validation for constraint: boolean
        if (!is_null($probabileErrore) && !is_bool($probabileErrore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($probabileErrore, true), gettype($probabileErrore)), __LINE__);
        }
        $this->probabileErrore = $probabileErrore;
        return $this;
    }
    /**
     * Get ritornatoIndirizzi value
     * @return bool|null
     */
    public function getRitornatoIndirizzi()
    {
        return $this->ritornatoIndirizzi;
    }
    /**
     * Set ritornatoIndirizzi value
     * @param bool $ritornatoIndirizzi
     * @return \Sisteract\StructType\ReturnIndirizziList_Type
     */
    public function setRitornatoIndirizzi($ritornatoIndirizzi = null)
    {
        // validation for constraint: boolean
        if (!is_null($ritornatoIndirizzi) && !is_bool($ritornatoIndirizzi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ritornatoIndirizzi, true), gettype($ritornatoIndirizzi)), __LINE__);
        }
        $this->ritornatoIndirizzi = $ritornatoIndirizzi;
        return $this;
    }
}
