<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersoneGiuridicheBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che rappresenta una persona giuridca
 * @subpackage Structs
 */
class PersoneGiuridicheBean_Type extends AbstractStructBase
{
    /**
     * The codiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Codice fiscale della persona giuridica
     * - nillable: true
     * @var string
     */
    public $codiceFiscale;
    /**
     * The comuneSede
     * Meta information extracted from the WSDL
     * - documentation: Comune sede della persona giuridica
     * - nillable: true
     * @var string
     */
    public $comuneSede;
    /**
     * The denominazione
     * Meta information extracted from the WSDL
     * - documentation: Denominazione della persona giuridica
     * - nillable: true
     * @var string
     */
    public $denominazione;
    /**
     * The idSoggetto
     * Meta information extracted from the WSDL
     * - documentation: Id del soggetto della persona giuridica, l'Id e' assegnato dal sistema
     * - nillable: true
     * @var string
     */
    public $idSoggetto;
    /**
     * The provinciaSede
     * Meta information extracted from the WSDL
     * - documentation: Provincia sede della persona giuridica
     * - nillable: true
     * @var string
     */
    public $provinciaSede;
    /**
     * Constructor method for PersoneGiuridicheBean_Type
     * @uses PersoneGiuridicheBean_Type::setCodiceFiscale()
     * @uses PersoneGiuridicheBean_Type::setComuneSede()
     * @uses PersoneGiuridicheBean_Type::setDenominazione()
     * @uses PersoneGiuridicheBean_Type::setIdSoggetto()
     * @uses PersoneGiuridicheBean_Type::setProvinciaSede()
     * @param string $codiceFiscale
     * @param string $comuneSede
     * @param string $denominazione
     * @param string $idSoggetto
     * @param string $provinciaSede
     */
    public function __construct($codiceFiscale = null, $comuneSede = null, $denominazione = null, $idSoggetto = null, $provinciaSede = null)
    {
        $this
            ->setCodiceFiscale($codiceFiscale)
            ->setComuneSede($comuneSede)
            ->setDenominazione($denominazione)
            ->setIdSoggetto($idSoggetto)
            ->setProvinciaSede($provinciaSede);
    }
    /**
     * Get codiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->codiceFiscale;
    }
    /**
     * Set codiceFiscale value
     * @param string $codiceFiscale
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->codiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get comuneSede value
     * @return string|null
     */
    public function getComuneSede()
    {
        return $this->comuneSede;
    }
    /**
     * Set comuneSede value
     * @param string $comuneSede
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type
     */
    public function setComuneSede($comuneSede = null)
    {
        // validation for constraint: string
        if (!is_null($comuneSede) && !is_string($comuneSede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comuneSede, true), gettype($comuneSede)), __LINE__);
        }
        $this->comuneSede = $comuneSede;
        return $this;
    }
    /**
     * Get denominazione value
     * @return string|null
     */
    public function getDenominazione()
    {
        return $this->denominazione;
    }
    /**
     * Set denominazione value
     * @param string $denominazione
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type
     */
    public function setDenominazione($denominazione = null)
    {
        // validation for constraint: string
        if (!is_null($denominazione) && !is_string($denominazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominazione, true), gettype($denominazione)), __LINE__);
        }
        $this->denominazione = $denominazione;
        return $this;
    }
    /**
     * Get idSoggetto value
     * @return string|null
     */
    public function getIdSoggetto()
    {
        return $this->idSoggetto;
    }
    /**
     * Set idSoggetto value
     * @param string $idSoggetto
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type
     */
    public function setIdSoggetto($idSoggetto = null)
    {
        // validation for constraint: string
        if (!is_null($idSoggetto) && !is_string($idSoggetto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idSoggetto, true), gettype($idSoggetto)), __LINE__);
        }
        $this->idSoggetto = $idSoggetto;
        return $this;
    }
    /**
     * Get provinciaSede value
     * @return string|null
     */
    public function getProvinciaSede()
    {
        return $this->provinciaSede;
    }
    /**
     * Set provinciaSede value
     * @param string $provinciaSede
     * @return \Sisteract\StructType\PersoneGiuridicheBean_Type
     */
    public function setProvinciaSede($provinciaSede = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaSede) && !is_string($provinciaSede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaSede, true), gettype($provinciaSede)), __LINE__);
        }
        $this->provinciaSede = $provinciaSede;
        return $this;
    }
}
