<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRichiestaNota_Type StructType
 * @subpackage Structs
 */
class ParametriRichiestaNota_Type extends Session_Type
{
    /**
     * The anno
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $anno;
    /**
     * The conservatoria
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sisteract\StructType\ConservatoriaBean_Type
     */
    public $conservatoria;
    /**
     * The perRegistroParticolare
     * @var bool
     */
    public $perRegistroParticolare;
    /**
     * The registroGenerale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $registroGenerale;
    /**
     * The registroParticolare
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $registroParticolare;
    /**
     * The restrizione
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $restrizione;
    /**
     * The restrizioneImmobileBean
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sisteract\StructType\RestrizioneImmobileBean_Type
     */
    public $restrizioneImmobileBean;
    /**
     * The restrizionePersonaBean
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \Sisteract\StructType\RestrizionePersoneBean_Type
     */
    public $restrizionePersonaBean;
    /**
     * The sezioneCensimento
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sezioneCensimento;
    /**
     * The tipoNota
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tipoNota;
    /**
     * Constructor method for ParametriRichiestaNota_Type
     * @uses ParametriRichiestaNota_Type::setAnno()
     * @uses ParametriRichiestaNota_Type::setConservatoria()
     * @uses ParametriRichiestaNota_Type::setPerRegistroParticolare()
     * @uses ParametriRichiestaNota_Type::setRegistroGenerale()
     * @uses ParametriRichiestaNota_Type::setRegistroParticolare()
     * @uses ParametriRichiestaNota_Type::setRestrizione()
     * @uses ParametriRichiestaNota_Type::setRestrizioneImmobileBean()
     * @uses ParametriRichiestaNota_Type::setRestrizionePersonaBean()
     * @uses ParametriRichiestaNota_Type::setSezioneCensimento()
     * @uses ParametriRichiestaNota_Type::setTipoNota()
     * @param string $anno
     * @param \Sisteract\StructType\ConservatoriaBean_Type $conservatoria
     * @param bool $perRegistroParticolare
     * @param string $registroGenerale
     * @param string $registroParticolare
     * @param string $restrizione
     * @param \Sisteract\StructType\RestrizioneImmobileBean_Type $restrizioneImmobileBean
     * @param \Sisteract\StructType\RestrizionePersoneBean_Type $restrizionePersonaBean
     * @param string $sezioneCensimento
     * @param string $tipoNota
     */
    public function __construct($anno = null, \Sisteract\StructType\ConservatoriaBean_Type $conservatoria = null, $perRegistroParticolare = null, $registroGenerale = null, $registroParticolare = null, $restrizione = null, \Sisteract\StructType\RestrizioneImmobileBean_Type $restrizioneImmobileBean = null, \Sisteract\StructType\RestrizionePersoneBean_Type $restrizionePersonaBean = null, $sezioneCensimento = null, $tipoNota = null)
    {
        $this
            ->setAnno($anno)
            ->setConservatoria($conservatoria)
            ->setPerRegistroParticolare($perRegistroParticolare)
            ->setRegistroGenerale($registroGenerale)
            ->setRegistroParticolare($registroParticolare)
            ->setRestrizione($restrizione)
            ->setRestrizioneImmobileBean($restrizioneImmobileBean)
            ->setRestrizionePersonaBean($restrizionePersonaBean)
            ->setSezioneCensimento($sezioneCensimento)
            ->setTipoNota($tipoNota);
    }
    /**
     * Get anno value
     * @return string|null
     */
    public function getAnno()
    {
        return $this->anno;
    }
    /**
     * Set anno value
     * @param string $anno
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setAnno($anno = null)
    {
        // validation for constraint: string
        if (!is_null($anno) && !is_string($anno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anno, true), gettype($anno)), __LINE__);
        }
        $this->anno = $anno;
        return $this;
    }
    /**
     * Get conservatoria value
     * @return \Sisteract\StructType\ConservatoriaBean_Type|null
     */
    public function getConservatoria()
    {
        return $this->conservatoria;
    }
    /**
     * Set conservatoria value
     * @param \Sisteract\StructType\ConservatoriaBean_Type $conservatoria
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setConservatoria(\Sisteract\StructType\ConservatoriaBean_Type $conservatoria = null)
    {
        $this->conservatoria = $conservatoria;
        return $this;
    }
    /**
     * Get perRegistroParticolare value
     * @return bool|null
     */
    public function getPerRegistroParticolare()
    {
        return $this->perRegistroParticolare;
    }
    /**
     * Set perRegistroParticolare value
     * @param bool $perRegistroParticolare
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setPerRegistroParticolare($perRegistroParticolare = null)
    {
        // validation for constraint: boolean
        if (!is_null($perRegistroParticolare) && !is_bool($perRegistroParticolare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($perRegistroParticolare, true), gettype($perRegistroParticolare)), __LINE__);
        }
        $this->perRegistroParticolare = $perRegistroParticolare;
        return $this;
    }
    /**
     * Get registroGenerale value
     * @return string|null
     */
    public function getRegistroGenerale()
    {
        return $this->registroGenerale;
    }
    /**
     * Set registroGenerale value
     * @param string $registroGenerale
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setRegistroGenerale($registroGenerale = null)
    {
        // validation for constraint: string
        if (!is_null($registroGenerale) && !is_string($registroGenerale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registroGenerale, true), gettype($registroGenerale)), __LINE__);
        }
        $this->registroGenerale = $registroGenerale;
        return $this;
    }
    /**
     * Get registroParticolare value
     * @return string|null
     */
    public function getRegistroParticolare()
    {
        return $this->registroParticolare;
    }
    /**
     * Set registroParticolare value
     * @param string $registroParticolare
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setRegistroParticolare($registroParticolare = null)
    {
        // validation for constraint: string
        if (!is_null($registroParticolare) && !is_string($registroParticolare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registroParticolare, true), gettype($registroParticolare)), __LINE__);
        }
        $this->registroParticolare = $registroParticolare;
        return $this;
    }
    /**
     * Get restrizione value
     * @return string|null
     */
    public function getRestrizione()
    {
        return $this->restrizione;
    }
    /**
     * Set restrizione value
     * @uses \Sisteract\EnumType\RestrizioniNota_Type::valueIsValid()
     * @uses \Sisteract\EnumType\RestrizioniNota_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrizione
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setRestrizione($restrizione = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\RestrizioniNota_Type::valueIsValid($restrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\RestrizioniNota_Type', is_array($restrizione) ? implode(', ', $restrizione) : var_export($restrizione, true), implode(', ', \Sisteract\EnumType\RestrizioniNota_Type::getValidValues())), __LINE__);
        }
        $this->restrizione = $restrizione;
        return $this;
    }
    /**
     * Get restrizioneImmobileBean value
     * @return \Sisteract\StructType\RestrizioneImmobileBean_Type|null
     */
    public function getRestrizioneImmobileBean()
    {
        return $this->restrizioneImmobileBean;
    }
    /**
     * Set restrizioneImmobileBean value
     * @param \Sisteract\StructType\RestrizioneImmobileBean_Type $restrizioneImmobileBean
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setRestrizioneImmobileBean(\Sisteract\StructType\RestrizioneImmobileBean_Type $restrizioneImmobileBean = null)
    {
        $this->restrizioneImmobileBean = $restrizioneImmobileBean;
        return $this;
    }
    /**
     * Get restrizionePersonaBean value
     * @return \Sisteract\StructType\RestrizionePersoneBean_Type|null
     */
    public function getRestrizionePersonaBean()
    {
        return $this->restrizionePersonaBean;
    }
    /**
     * Set restrizionePersonaBean value
     * @param \Sisteract\StructType\RestrizionePersoneBean_Type $restrizionePersonaBean
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setRestrizionePersonaBean(\Sisteract\StructType\RestrizionePersoneBean_Type $restrizionePersonaBean = null)
    {
        $this->restrizionePersonaBean = $restrizionePersonaBean;
        return $this;
    }
    /**
     * Get sezioneCensimento value
     * @return string|null
     */
    public function getSezioneCensimento()
    {
        return $this->sezioneCensimento;
    }
    /**
     * Set sezioneCensimento value
     * @param string $sezioneCensimento
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setSezioneCensimento($sezioneCensimento = null)
    {
        // validation for constraint: string
        if (!is_null($sezioneCensimento) && !is_string($sezioneCensimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sezioneCensimento, true), gettype($sezioneCensimento)), __LINE__);
        }
        $this->sezioneCensimento = $sezioneCensimento;
        return $this;
    }
    /**
     * Get tipoNota value
     * @return string|null
     */
    public function getTipoNota()
    {
        return $this->tipoNota;
    }
    /**
     * Set tipoNota value
     * @uses \Sisteract\EnumType\EnumTipoNota_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoNota_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoNota
     * @return \Sisteract\StructType\ParametriRichiestaNota_Type
     */
    public function setTipoNota($tipoNota = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoNota_Type::valueIsValid($tipoNota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoNota_Type', is_array($tipoNota) ? implode(', ', $tipoNota) : var_export($tipoNota, true), implode(', ', \Sisteract\EnumType\EnumTipoNota_Type::getValidValues())), __LINE__);
        }
        $this->tipoNota = $tipoNota;
        return $this;
    }
}
