<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaPersonaFisicaBean_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per la ricerca di una persona fisica su tutto il territorio nazionalela ricerca prevede l'uso dei dati anagrafici cognome/nome e opzionalmente anche data nascita,il luogo di nascita, etc.In alternativa o in
 * aggiunta alla denominazione si puo' usare il codice fiscale.Se si passa la provincia, la ricerca si limitera' sull'ufficio catastale della provincia.Se si passa il comune, la ricerca si limitera' al comune dell'ufficio catastale della provincia.Se
 * non verranno passate ne provincia, ne comune la ricerca verrà eseguita su pianta nazionaleil risultato sara' una lista di persone trovate, con data di nascita e codice fiscale (ove presente)Nota:fare molta attenzione ad i parametri mandatari:
 * omocodice e precisione ricerca. Per cio' si rimandala lettura ad i parametri
 * @subpackage Structs
 */
class ParametriRicercaPersonaFisicaBean_Type extends Session_Type
{
    /**
     * The codiceComuneBeni
     * Meta information extracted from the WSDL
     * - documentation: Codice catastale su cui cercare gli immobili
     * - nillable: true
     * @var string
     */
    public $codiceComuneBeni;
    /**
     * The codiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Codice fiscale della persona che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $codiceFiscale;
    /**
     * The cognome
     * Meta information extracted from the WSDL
     * - documentation: Cognome della persona che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $cognome;
    /**
     * The dataNascita
     * Meta information extracted from the WSDL
     * - documentation: Data nascita della persona che si vuole cercarenel formato ansi italiano (yyyymmdd)
     * - nillable: true
     * @var string
     */
    public $dataNascita;
    /**
     * The luogoNascita
     * Meta information extracted from the WSDL
     * - documentation: Luogo di nascita della persona che si vuole cercareTesto libero della localita'
     * - nillable: true
     * @var string
     */
    public $luogoNascita;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - documentation: Nome della persona che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $nome;
    /**
     * The omoCodice
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Omocodicevalori ammessi: RICERCA_OMOCODICEQuesta ricerca può essere applicata a tutti i soggetti per i quali e' stato fornito un codice fiscale.All'elenco degli omonimi ottenuto in seguito ad una ricerca ampliata oppure
     * ristretta vengono aggiunti anche tutti i soggetti il cui codice fiscale è uguale a quello di uno degli omonimi ottenuti dalla normale ricerca ristretta o ampliata.In tal modo è possibile reperire tutti quei soggetti per i quali è stato digitato
     * correttamente il codice fiscale, ma erroneamente il cognome e/o nome, oppure la denominazione.RICERCA_NO_OMOCODICENessun controllo su il risultato ottenutoparametro mandatario
     * @var string
     */
    public $omoCodice;
    /**
     * The precisioneRicerca
     * Meta information extracted from the WSDL
     * - documentation: Precisione della ricercavalori ammessi:RICERCA_AMPLIATA La ricerca ampliata per soggetto persona fisica estrae tutti gli intestati il cui cognome contenga in qualunque posizione (iniziale, finale o intermedia) la stringa inserita nel
     * campo cognome della videata di ricerca. Nel caso in cui il cognome insertito nella schermata di ricerca contenga più parole separate da spazi (al massimo 5 parole), per ciascuna parola si applica la modalità di ricerca suddetta. I seguenti campi
     * sono facoltativi: il nome, il luogo di nascita, la provincia del luogo di nascita, la data di nascita e il sesso. Se come campo di ricerca si inserisce anche il nome, devono valere le stesse condizioni descritte per il cognome relativamente al campo
     * nome presente in banca dati. Se come campo di ricerca si inserisce anche il luogo di nascita, la ricerca trova tutti i luoghi di nascita che contengono la stringa inserita (per esempio inserendo LESSA trovo ALESSANDRIA). Vengono selezionati anche gli
     * intestati per cui il luogo di nascita non è presente in banca dati . Se come campo di ricerca si inserisce anche la data di nascita, questo campo deve essere pari al campo data di nascita presente in banca dati; vengono selezionati anche gli
     * intestati per cui la data di nascita non è presente in banca dati . Per ciascun intestato ottenuto si visualizza nelle schermate risultato della ricerca: · cognome (con eventuale cognome maritale) e nome · luogo di nascita e provincia · data di
     * nascita · codice fiscaleRICERCA_RISTRETTA La ricerca ristretta per soggetto persona fisica estrae tutti gli intestati il cui cognome (completo) oppure la prima parola del cognome sia uguale alla stringa inserita nel campo cognome della videata di
     * ricerca. I seguenti campi sono facoltativi: il nome, il luogo di nascita, la data di nascita, la provincia del luogo di nascita ed il sesso. Se come campo di ricerca si inserisce anche il nome, devono valere le stesse condizioni descritte per il
     * cognome relativamente al campo nome presente in banca dati.Se come campo di ricerca si inserisce anche il luogo di nascita, la ricerca trova tutti i luoghi di nascita che contengono la stringa inserita (per esempio inserendo LESSA verrà trovata
     * anche ALESSANDRIA).Vengono selezionati anche gli intestati per cui il luogo di nascita non è presente in banca dati .Se come campo di ricerca si inserisce anche la data di nascita, questo campo deve essere pari al campo data di nascita presente in
     * banca dati; vengono selezionati anche gli intestati per cui la data di nascita non è presente in banca dati .Per ciascun intestato ottenuto si visualizza nelle schermate risultato della ricerca: · cognome (con eventuale cognome maritale) e nome ·
     * luogo di nascita e provincia · data di nascita · codice fiscaleparametro mandatario
     * @var string
     */
    public $precisioneRicerca;
    /**
     * The provinciaBeni
     * Meta information extracted from the WSDL
     * - documentation: Provincia su cui cercare gli immobili.Obbligatorio se si specifica il codice comune
     * - nillable: true
     * @var string
     */
    public $provinciaBeni;
    /**
     * The provinciaNascita
     * Meta information extracted from the WSDL
     * - documentation: Provincia di nascita della persona che si vuole cercare
     * - nillable: true
     * @var string
     */
    public $provinciaNascita;
    /**
     * The sesso
     * Meta information extracted from the WSDL
     * - documentation: Sesso della persona da cercarevalori ammessi:NO_SESSO da usare in caso non si voglia fare distizione sulla ricercaSESSO_MASCHIO da usare in caso si voglia trovare solo le persone di sesso maschileSESSO_FEMMINA da usare in caso si
     * voglia trovare solo le persone di sesso femminile parametro mandatario
     * @var string
     */
    public $sesso;
    /**
     * The tipoRicerca
     * Meta information extracted from the WSDL
     * - documentation: Tipo di ricerca da effettualevalori ammessi: TIPO_RICERCA_TERRENI_FABBRICATI La ricerca viene fatta sia su il catasto terreni, che il catasto fabbricatiTIPO_RICERCA_FABBRICATI La ricerca viene fatta solo sul catasto
     * fabbricatiTIPO_RICERCA_TERRENI La ricerca viene fatta solo sul catasto terreni parametro mandatario
     * @var string
     */
    public $tipoRicerca;
    /**
     * The tipoRichiesta
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tipoRichiesta;
    /**
     * Constructor method for ParametriRicercaPersonaFisicaBean_Type
     * @uses ParametriRicercaPersonaFisicaBean_Type::setCodiceComuneBeni()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setCodiceFiscale()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setCognome()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setDataNascita()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setLuogoNascita()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setNome()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setOmoCodice()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setPrecisioneRicerca()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setProvinciaBeni()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setProvinciaNascita()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setSesso()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setTipoRicerca()
     * @uses ParametriRicercaPersonaFisicaBean_Type::setTipoRichiesta()
     * @param string $codiceComuneBeni
     * @param string $codiceFiscale
     * @param string $cognome
     * @param string $dataNascita
     * @param string $luogoNascita
     * @param string $nome
     * @param string $omoCodice
     * @param string $precisioneRicerca
     * @param string $provinciaBeni
     * @param string $provinciaNascita
     * @param string $sesso
     * @param string $tipoRicerca
     * @param string $tipoRichiesta
     */
    public function __construct($codiceComuneBeni = null, $codiceFiscale = null, $cognome = null, $dataNascita = null, $luogoNascita = null, $nome = null, $omoCodice = null, $precisioneRicerca = null, $provinciaBeni = null, $provinciaNascita = null, $sesso = null, $tipoRicerca = null, $tipoRichiesta = null)
    {
        $this
            ->setCodiceComuneBeni($codiceComuneBeni)
            ->setCodiceFiscale($codiceFiscale)
            ->setCognome($cognome)
            ->setDataNascita($dataNascita)
            ->setLuogoNascita($luogoNascita)
            ->setNome($nome)
            ->setOmoCodice($omoCodice)
            ->setPrecisioneRicerca($precisioneRicerca)
            ->setProvinciaBeni($provinciaBeni)
            ->setProvinciaNascita($provinciaNascita)
            ->setSesso($sesso)
            ->setTipoRicerca($tipoRicerca)
            ->setTipoRichiesta($tipoRichiesta);
    }
    /**
     * Get codiceComuneBeni value
     * @return string|null
     */
    public function getCodiceComuneBeni()
    {
        return $this->codiceComuneBeni;
    }
    /**
     * Set codiceComuneBeni value
     * @param string $codiceComuneBeni
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setCodiceComuneBeni($codiceComuneBeni = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComuneBeni) && !is_string($codiceComuneBeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComuneBeni, true), gettype($codiceComuneBeni)), __LINE__);
        }
        $this->codiceComuneBeni = $codiceComuneBeni;
        return $this;
    }
    /**
     * Get codiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->codiceFiscale;
    }
    /**
     * Set codiceFiscale value
     * @param string $codiceFiscale
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->codiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get cognome value
     * @return string|null
     */
    public function getCognome()
    {
        return $this->cognome;
    }
    /**
     * Set cognome value
     * @param string $cognome
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        $this->cognome = $cognome;
        return $this;
    }
    /**
     * Get dataNascita value
     * @return string|null
     */
    public function getDataNascita()
    {
        return $this->dataNascita;
    }
    /**
     * Set dataNascita value
     * @param string $dataNascita
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setDataNascita($dataNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataNascita) && !is_string($dataNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNascita, true), gettype($dataNascita)), __LINE__);
        }
        $this->dataNascita = $dataNascita;
        return $this;
    }
    /**
     * Get luogoNascita value
     * @return string|null
     */
    public function getLuogoNascita()
    {
        return $this->luogoNascita;
    }
    /**
     * Set luogoNascita value
     * @param string $luogoNascita
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setLuogoNascita($luogoNascita = null)
    {
        // validation for constraint: string
        if (!is_null($luogoNascita) && !is_string($luogoNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($luogoNascita, true), gettype($luogoNascita)), __LINE__);
        }
        $this->luogoNascita = $luogoNascita;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get omoCodice value
     * @return string|null
     */
    public function getOmoCodice()
    {
        return $this->omoCodice;
    }
    /**
     * Set omoCodice value
     * @uses \Sisteract\EnumType\EnumOmocodice_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumOmocodice_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $omoCodice
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setOmoCodice($omoCodice = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumOmocodice_Type::valueIsValid($omoCodice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumOmocodice_Type', is_array($omoCodice) ? implode(', ', $omoCodice) : var_export($omoCodice, true), implode(', ', \Sisteract\EnumType\EnumOmocodice_Type::getValidValues())), __LINE__);
        }
        $this->omoCodice = $omoCodice;
        return $this;
    }
    /**
     * Get precisioneRicerca value
     * @return string|null
     */
    public function getPrecisioneRicerca()
    {
        return $this->precisioneRicerca;
    }
    /**
     * Set precisioneRicerca value
     * @uses \Sisteract\EnumType\EnumPrecisioneRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumPrecisioneRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $precisioneRicerca
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setPrecisioneRicerca($precisioneRicerca = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumPrecisioneRicerca_Type::valueIsValid($precisioneRicerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumPrecisioneRicerca_Type', is_array($precisioneRicerca) ? implode(', ', $precisioneRicerca) : var_export($precisioneRicerca, true), implode(', ', \Sisteract\EnumType\EnumPrecisioneRicerca_Type::getValidValues())), __LINE__);
        }
        $this->precisioneRicerca = $precisioneRicerca;
        return $this;
    }
    /**
     * Get provinciaBeni value
     * @return string|null
     */
    public function getProvinciaBeni()
    {
        return $this->provinciaBeni;
    }
    /**
     * Set provinciaBeni value
     * @param string $provinciaBeni
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setProvinciaBeni($provinciaBeni = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaBeni) && !is_string($provinciaBeni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaBeni, true), gettype($provinciaBeni)), __LINE__);
        }
        $this->provinciaBeni = $provinciaBeni;
        return $this;
    }
    /**
     * Get provinciaNascita value
     * @return string|null
     */
    public function getProvinciaNascita()
    {
        return $this->provinciaNascita;
    }
    /**
     * Set provinciaNascita value
     * @param string $provinciaNascita
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setProvinciaNascita($provinciaNascita = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaNascita) && !is_string($provinciaNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaNascita, true), gettype($provinciaNascita)), __LINE__);
        }
        $this->provinciaNascita = $provinciaNascita;
        return $this;
    }
    /**
     * Get sesso value
     * @return string|null
     */
    public function getSesso()
    {
        return $this->sesso;
    }
    /**
     * Set sesso value
     * @uses \Sisteract\EnumType\EnumSesso_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumSesso_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sesso
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumSesso_Type::valueIsValid($sesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumSesso_Type', is_array($sesso) ? implode(', ', $sesso) : var_export($sesso, true), implode(', ', \Sisteract\EnumType\EnumSesso_Type::getValidValues())), __LINE__);
        }
        $this->sesso = $sesso;
        return $this;
    }
    /**
     * Get tipoRicerca value
     * @return string|null
     */
    public function getTipoRicerca()
    {
        return $this->tipoRicerca;
    }
    /**
     * Set tipoRicerca value
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRicerca
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setTipoRicerca($tipoRicerca = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid($tipoRicerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRicerca_Type', is_array($tipoRicerca) ? implode(', ', $tipoRicerca) : var_export($tipoRicerca, true), implode(', ', \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues())), __LINE__);
        }
        $this->tipoRicerca = $tipoRicerca;
        return $this;
    }
    /**
     * Get tipoRichiesta value
     * @return string|null
     */
    public function getTipoRichiesta()
    {
        return $this->tipoRichiesta;
    }
    /**
     * Set tipoRichiesta value
     * @uses \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRichiesta
     * @return \Sisteract\StructType\ParametriRicercaPersonaFisicaBean_Type
     */
    public function setTipoRichiesta($tipoRichiesta = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::valueIsValid($tipoRichiesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type', is_array($tipoRichiesta) ? implode(', ', $tipoRichiesta) : var_export($tipoRichiesta, true), implode(', ', \Sisteract\EnumType\EnumTipoRichiestaRicerca_Type::getValidValues())), __LINE__);
        }
        $this->tipoRichiesta = $tipoRichiesta;
        return $this;
    }
}
