<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaImmobiliIndirizzoNoToponimo_Type
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per la ricerca di un immobile, partendo da un indirizzo di uno specificocomune, questa ricerca prevede non di passare anche il toponimo dell'indirizzo.La risposta e' o la risposta negativa dell'indirizzo cercato e
 * o la lista degli indirizzi trovatinota: per ottenere la lista dei comuni partendo da una provincia usare la chiamata: getComuni
 * @subpackage Structs
 */
class ParametriRicercaImmobiliIndirizzoNoToponimo_Type extends Session_Type
{
    /**
     * The codiceComune
     * Meta information extracted from the WSDL
     * - documentation: Codice Comune Catasto su cui ricercare l'indirizzo
     * @var string
     */
    public $codiceComune;
    /**
     * The indirizzo
     * Meta information extracted from the WSDL
     * - documentation: Indirizzo da ricercareparametro mandatario
     * @var string
     */
    public $indirizzo;
    /**
     * The numeroA
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di arrivo per la ricerca
     * - nillable: true
     * @var string
     */
    public $numeroA;
    /**
     * The numeroDa
     * Meta information extracted from the WSDL
     * - documentation: Numero civico di partenza per la ricerca
     * - nillable: true
     * @var string
     */
    public $numeroDa;
    /**
     * The parolaIntera
     * Meta information extracted from the WSDL
     * - documentation: Si può cercare un indirizzo sia per parola intera (in questo caso verranno presi in considerazione gli indirizzi che contengono quella parola intera), sia per chiave parziale (in questo caso saranno considerati anche gli indirizzi
     * che contengono la chiave digitata).Ad esempio cercando l'indirizzo Via Po con la modalità di ricerca non per parola intera, oltre all'indirizzo Via Po, si otterranno anche Via Polinesia, Via Polipo, Via Topolinia, ecc.
     * @var bool
     */
    public $parolaIntera;
    /**
     * The sezioneComune
     * Meta information extracted from the WSDL
     * - documentation: Codice della sezione censuaria del comune su cui si ricerca l'indirizzoparametro facoltativo
     * - nillable: true
     * @var string
     */
    public $sezioneComune;
    /**
     * Constructor method for ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setCodiceComune()
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setIndirizzo()
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setNumeroA()
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setNumeroDa()
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setParolaIntera()
     * @uses ParametriRicercaImmobiliIndirizzoNoToponimo_Type::setSezioneComune()
     * @param string $codiceComune
     * @param string $indirizzo
     * @param string $numeroA
     * @param string $numeroDa
     * @param bool $parolaIntera
     * @param string $sezioneComune
     */
    public function __construct($codiceComune = null, $indirizzo = null, $numeroA = null, $numeroDa = null, $parolaIntera = null, $sezioneComune = null)
    {
        $this
            ->setCodiceComune($codiceComune)
            ->setIndirizzo($indirizzo)
            ->setNumeroA($numeroA)
            ->setNumeroDa($numeroDa)
            ->setParolaIntera($parolaIntera)
            ->setSezioneComune($sezioneComune);
    }
    /**
     * Get codiceComune value
     * @return string|null
     */
    public function getCodiceComune()
    {
        return $this->codiceComune;
    }
    /**
     * Set codiceComune value
     * @param string $codiceComune
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setCodiceComune($codiceComune = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComune) && !is_string($codiceComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComune, true), gettype($codiceComune)), __LINE__);
        }
        $this->codiceComune = $codiceComune;
        return $this;
    }
    /**
     * Get indirizzo value
     * @return string|null
     */
    public function getIndirizzo()
    {
        return $this->indirizzo;
    }
    /**
     * Set indirizzo value
     * @param string $indirizzo
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setIndirizzo($indirizzo = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzo) && !is_string($indirizzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzo, true), gettype($indirizzo)), __LINE__);
        }
        $this->indirizzo = $indirizzo;
        return $this;
    }
    /**
     * Get numeroA value
     * @return string|null
     */
    public function getNumeroA()
    {
        return $this->numeroA;
    }
    /**
     * Set numeroA value
     * @param string $numeroA
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setNumeroA($numeroA = null)
    {
        // validation for constraint: string
        if (!is_null($numeroA) && !is_string($numeroA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroA, true), gettype($numeroA)), __LINE__);
        }
        $this->numeroA = $numeroA;
        return $this;
    }
    /**
     * Get numeroDa value
     * @return string|null
     */
    public function getNumeroDa()
    {
        return $this->numeroDa;
    }
    /**
     * Set numeroDa value
     * @param string $numeroDa
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setNumeroDa($numeroDa = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDa) && !is_string($numeroDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDa, true), gettype($numeroDa)), __LINE__);
        }
        $this->numeroDa = $numeroDa;
        return $this;
    }
    /**
     * Get parolaIntera value
     * @return bool|null
     */
    public function getParolaIntera()
    {
        return $this->parolaIntera;
    }
    /**
     * Set parolaIntera value
     * @param bool $parolaIntera
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setParolaIntera($parolaIntera = null)
    {
        // validation for constraint: boolean
        if (!is_null($parolaIntera) && !is_bool($parolaIntera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($parolaIntera, true), gettype($parolaIntera)), __LINE__);
        }
        $this->parolaIntera = $parolaIntera;
        return $this;
    }
    /**
     * Get sezioneComune value
     * @return string|null
     */
    public function getSezioneComune()
    {
        return $this->sezioneComune;
    }
    /**
     * Set sezioneComune value
     * @param string $sezioneComune
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIndirizzoNoToponimo_Type
     */
    public function setSezioneComune($sezioneComune = null)
    {
        // validation for constraint: string
        if (!is_null($sezioneComune) && !is_string($sezioneComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sezioneComune, true), gettype($sezioneComune)), __LINE__);
        }
        $this->sezioneComune = $sezioneComune;
        return $this;
    }
}
