<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaImmobiliIdentificativo_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean dei parametri per la ricerca di un immobile, partendo dai parametri identificativiCi sono due tipi di ricerche che sono alternative:Identificativo catastale: per foglio, particella e subparticellaIdentificativo provvisorio: per
 * tipo denuncia, protocollo e annoLa risposta e' o la risposta negativa dell'indirizzo cercato e o la lista degli immobili trovati.nota: per ottenere la lista dei comuni partendo da una provincia usare la chiamata: getComuni per ottenere la lista dei
 * toponimo usare la chiamata:
 * @subpackage Structs
 */
class ParametriRicercaImmobiliIdentificativo_Type extends Session_Type
{
    /**
     * The anno
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo TemporaneoAnno del protocolloParametro mandatario se non viene scelto un identificativo provvisorio
     * - nillable: true
     * @var string
     */
    public $anno;
    /**
     * The codiceComune
     * Meta information extracted from the WSDL
     * - documentation: Codice Comune Catasto su cui ricercare l'immobile
     * - nillable: true
     * @var string
     */
    public $codiceComune;
    /**
     * The foglio
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo CatastaleFoglio su cui si vuole cercare gli immobiliParametro mandatario se non viene scelto un identificativo provvisorio
     * - nillable: true
     * @var string
     */
    public $foglio;
    /**
     * The particella
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo CatastaleParticella su cui si vuole cercare gli immobiliParametro mandatario se non viene scelto un identificativo provvisorio
     * - nillable: true
     * @var string
     */
    public $particella;
    /**
     * The particellaSecondaria
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo CatastaleParticella secondaria su cui si vuole cercare gli immobili
     * - nillable: true
     * @var string
     */
    public $particellaSecondaria;
    /**
     * The protocollo
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo TemporaneoProtocolloParametro mandatario se non viene scelto un identificativo provvisorio
     * - nillable: true
     * @var string
     */
    public $protocollo;
    /**
     * The sezione
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sezione;
    /**
     * The sezioneUrbana
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sezioneUrbana;
    /**
     * The subParticella
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo CatastaleSubparticella su cui si vuole cercare gli immobili
     * - nillable: true
     * @var string
     */
    public $subParticella;
    /**
     * The tipoDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per Identificativo TemporaneoTipo di denuncia.Valori ammessi: DENUNCIA_TUTTEDENUNCIA_PROTOCOLLODENUNCIA_VARIAZIONEDENUNCIA_SCHEDAParametro mandatario se non viene scelto un identificativo provvisorio
     * - nillable: true
     * @var string
     */
    public $tipoDenuncia;
    /**
     * The tipoRicerca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tipoRicerca;
    /**
     * The tipoRicercaImmobile
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $tipoRicercaImmobile;
    /**
     * Constructor method for ParametriRicercaImmobiliIdentificativo_Type
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setAnno()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setCodiceComune()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setFoglio()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setParticella()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setParticellaSecondaria()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setProtocollo()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setSezione()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setSezioneUrbana()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setSubParticella()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setTipoDenuncia()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setTipoRicerca()
     * @uses ParametriRicercaImmobiliIdentificativo_Type::setTipoRicercaImmobile()
     * @param string $anno
     * @param string $codiceComune
     * @param string $foglio
     * @param string $particella
     * @param string $particellaSecondaria
     * @param string $protocollo
     * @param string $sezione
     * @param string $sezioneUrbana
     * @param string $subParticella
     * @param string $tipoDenuncia
     * @param string $tipoRicerca
     * @param string $tipoRicercaImmobile
     */
    public function __construct($anno = null, $codiceComune = null, $foglio = null, $particella = null, $particellaSecondaria = null, $protocollo = null, $sezione = null, $sezioneUrbana = null, $subParticella = null, $tipoDenuncia = null, $tipoRicerca = null, $tipoRicercaImmobile = null)
    {
        $this
            ->setAnno($anno)
            ->setCodiceComune($codiceComune)
            ->setFoglio($foglio)
            ->setParticella($particella)
            ->setParticellaSecondaria($particellaSecondaria)
            ->setProtocollo($protocollo)
            ->setSezione($sezione)
            ->setSezioneUrbana($sezioneUrbana)
            ->setSubParticella($subParticella)
            ->setTipoDenuncia($tipoDenuncia)
            ->setTipoRicerca($tipoRicerca)
            ->setTipoRicercaImmobile($tipoRicercaImmobile);
    }
    /**
     * Get anno value
     * @return string|null
     */
    public function getAnno()
    {
        return $this->anno;
    }
    /**
     * Set anno value
     * @param string $anno
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setAnno($anno = null)
    {
        // validation for constraint: string
        if (!is_null($anno) && !is_string($anno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anno, true), gettype($anno)), __LINE__);
        }
        $this->anno = $anno;
        return $this;
    }
    /**
     * Get codiceComune value
     * @return string|null
     */
    public function getCodiceComune()
    {
        return $this->codiceComune;
    }
    /**
     * Set codiceComune value
     * @param string $codiceComune
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setCodiceComune($codiceComune = null)
    {
        // validation for constraint: string
        if (!is_null($codiceComune) && !is_string($codiceComune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceComune, true), gettype($codiceComune)), __LINE__);
        }
        $this->codiceComune = $codiceComune;
        return $this;
    }
    /**
     * Get foglio value
     * @return string|null
     */
    public function getFoglio()
    {
        return $this->foglio;
    }
    /**
     * Set foglio value
     * @param string $foglio
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setFoglio($foglio = null)
    {
        // validation for constraint: string
        if (!is_null($foglio) && !is_string($foglio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foglio, true), gettype($foglio)), __LINE__);
        }
        $this->foglio = $foglio;
        return $this;
    }
    /**
     * Get particella value
     * @return string|null
     */
    public function getParticella()
    {
        return $this->particella;
    }
    /**
     * Set particella value
     * @param string $particella
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setParticella($particella = null)
    {
        // validation for constraint: string
        if (!is_null($particella) && !is_string($particella)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particella, true), gettype($particella)), __LINE__);
        }
        $this->particella = $particella;
        return $this;
    }
    /**
     * Get particellaSecondaria value
     * @return string|null
     */
    public function getParticellaSecondaria()
    {
        return $this->particellaSecondaria;
    }
    /**
     * Set particellaSecondaria value
     * @param string $particellaSecondaria
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setParticellaSecondaria($particellaSecondaria = null)
    {
        // validation for constraint: string
        if (!is_null($particellaSecondaria) && !is_string($particellaSecondaria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particellaSecondaria, true), gettype($particellaSecondaria)), __LINE__);
        }
        $this->particellaSecondaria = $particellaSecondaria;
        return $this;
    }
    /**
     * Get protocollo value
     * @return string|null
     */
    public function getProtocollo()
    {
        return $this->protocollo;
    }
    /**
     * Set protocollo value
     * @param string $protocollo
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setProtocollo($protocollo = null)
    {
        // validation for constraint: string
        if (!is_null($protocollo) && !is_string($protocollo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocollo, true), gettype($protocollo)), __LINE__);
        }
        $this->protocollo = $protocollo;
        return $this;
    }
    /**
     * Get sezione value
     * @return string|null
     */
    public function getSezione()
    {
        return $this->sezione;
    }
    /**
     * Set sezione value
     * @param string $sezione
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setSezione($sezione = null)
    {
        // validation for constraint: string
        if (!is_null($sezione) && !is_string($sezione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sezione, true), gettype($sezione)), __LINE__);
        }
        $this->sezione = $sezione;
        return $this;
    }
    /**
     * Get sezioneUrbana value
     * @return string|null
     */
    public function getSezioneUrbana()
    {
        return $this->sezioneUrbana;
    }
    /**
     * Set sezioneUrbana value
     * @param string $sezioneUrbana
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setSezioneUrbana($sezioneUrbana = null)
    {
        // validation for constraint: string
        if (!is_null($sezioneUrbana) && !is_string($sezioneUrbana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sezioneUrbana, true), gettype($sezioneUrbana)), __LINE__);
        }
        $this->sezioneUrbana = $sezioneUrbana;
        return $this;
    }
    /**
     * Get subParticella value
     * @return string|null
     */
    public function getSubParticella()
    {
        return $this->subParticella;
    }
    /**
     * Set subParticella value
     * @param string $subParticella
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setSubParticella($subParticella = null)
    {
        // validation for constraint: string
        if (!is_null($subParticella) && !is_string($subParticella)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subParticella, true), gettype($subParticella)), __LINE__);
        }
        $this->subParticella = $subParticella;
        return $this;
    }
    /**
     * Get tipoDenuncia value
     * @return string|null
     */
    public function getTipoDenuncia()
    {
        return $this->tipoDenuncia;
    }
    /**
     * Set tipoDenuncia value
     * @uses \Sisteract\EnumType\EnumTipoDenuncia_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoDenuncia_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDenuncia
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setTipoDenuncia($tipoDenuncia = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoDenuncia_Type::valueIsValid($tipoDenuncia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoDenuncia_Type', is_array($tipoDenuncia) ? implode(', ', $tipoDenuncia) : var_export($tipoDenuncia, true), implode(', ', \Sisteract\EnumType\EnumTipoDenuncia_Type::getValidValues())), __LINE__);
        }
        $this->tipoDenuncia = $tipoDenuncia;
        return $this;
    }
    /**
     * Get tipoRicerca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoRicerca()
    {
        return isset($this->tipoRicerca) ? $this->tipoRicerca : null;
    }
    /**
     * Set tipoRicerca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRicerca
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setTipoRicerca($tipoRicerca = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRicerca_Type::valueIsValid($tipoRicerca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRicerca_Type', is_array($tipoRicerca) ? implode(', ', $tipoRicerca) : var_export($tipoRicerca, true), implode(', ', \Sisteract\EnumType\EnumTipoRicerca_Type::getValidValues())), __LINE__);
        }
        if (is_null($tipoRicerca) || (is_array($tipoRicerca) && empty($tipoRicerca))) {
            unset($this->tipoRicerca);
        } else {
            $this->tipoRicerca = $tipoRicerca;
        }
        return $this;
    }
    /**
     * Get tipoRicercaImmobile value
     * @return string|null
     */
    public function getTipoRicercaImmobile()
    {
        return $this->tipoRicercaImmobile;
    }
    /**
     * Set tipoRicercaImmobile value
     * @uses \Sisteract\EnumType\EnumTipoRicercaImmobile_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoRicercaImmobile_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoRicercaImmobile
     * @return \Sisteract\StructType\ParametriRicercaImmobiliIdentificativo_Type
     */
    public function setTipoRicercaImmobile($tipoRicercaImmobile = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoRicercaImmobile_Type::valueIsValid($tipoRicercaImmobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoRicercaImmobile_Type', is_array($tipoRicercaImmobile) ? implode(', ', $tipoRicercaImmobile) : var_export($tipoRicercaImmobile, true), implode(', ', \Sisteract\EnumType\EnumTipoRicercaImmobile_Type::getValidValues())), __LINE__);
        }
        $this->tipoRicercaImmobile = $tipoRicercaImmobile;
        return $this;
    }
}
