<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParametriRicercaImmobileConservatoriaBean_Type StructType
 * @subpackage Structs
 */
class ParametriRicercaImmobileConservatoriaBean_Type extends ParametriRicercaImmobiliIdentificativo_Type
{
    /**
     * The comuneSede
     * Meta information extracted from the WSDL
     * - documentation: Ritorna comune della sede
     * - nillable: true
     * @var string
     */
    public $comuneSede;
    /**
     * The conservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna conservatoria di interesse
     * @var string
     */
    public $conservatoria;
    /**
     * The costoMassimoAccettato
     * Meta information extracted from the WSDL
     * - documentation: Ritorna costo massimo che si è disposti ad accettare
     * @var float
     */
    public $costoMassimoAccettato;
    /**
     * The parametriRestrizioneFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna parametri per eventuali restrizioni sulle formalità
     * @var \Sisteract\StructType\ParametriRestrizioneFormalita_Type
     */
    public $parametriRestrizioneFormalita;
    /**
     * The provinciaSede
     * Meta information extracted from the WSDL
     * - documentation: Ritorna provincia della sede
     * - nillable: true
     * @var string
     */
    public $provinciaSede;
    /**
     * Constructor method for ParametriRicercaImmobileConservatoriaBean_Type
     * @uses ParametriRicercaImmobileConservatoriaBean_Type::setComuneSede()
     * @uses ParametriRicercaImmobileConservatoriaBean_Type::setConservatoria()
     * @uses ParametriRicercaImmobileConservatoriaBean_Type::setCostoMassimoAccettato()
     * @uses ParametriRicercaImmobileConservatoriaBean_Type::setParametriRestrizioneFormalita()
     * @uses ParametriRicercaImmobileConservatoriaBean_Type::setProvinciaSede()
     * @param string $comuneSede
     * @param string $conservatoria
     * @param float $costoMassimoAccettato
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     * @param string $provinciaSede
     */
    public function __construct($comuneSede = null, $conservatoria = null, $costoMassimoAccettato = null, \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null, $provinciaSede = null)
    {
        $this
            ->setComuneSede($comuneSede)
            ->setConservatoria($conservatoria)
            ->setCostoMassimoAccettato($costoMassimoAccettato)
            ->setParametriRestrizioneFormalita($parametriRestrizioneFormalita)
            ->setProvinciaSede($provinciaSede);
    }
    /**
     * Get comuneSede value
     * @return string|null
     */
    public function getComuneSede()
    {
        return $this->comuneSede;
    }
    /**
     * Set comuneSede value
     * @param string $comuneSede
     * @return \Sisteract\StructType\ParametriRicercaImmobileConservatoriaBean_Type
     */
    public function setComuneSede($comuneSede = null)
    {
        // validation for constraint: string
        if (!is_null($comuneSede) && !is_string($comuneSede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comuneSede, true), gettype($comuneSede)), __LINE__);
        }
        $this->comuneSede = $comuneSede;
        return $this;
    }
    /**
     * Get conservatoria value
     * @return string|null
     */
    public function getConservatoria()
    {
        return $this->conservatoria;
    }
    /**
     * Set conservatoria value
     * @param string $conservatoria
     * @return \Sisteract\StructType\ParametriRicercaImmobileConservatoriaBean_Type
     */
    public function setConservatoria($conservatoria = null)
    {
        // validation for constraint: string
        if (!is_null($conservatoria) && !is_string($conservatoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conservatoria, true), gettype($conservatoria)), __LINE__);
        }
        $this->conservatoria = $conservatoria;
        return $this;
    }
    /**
     * Get costoMassimoAccettato value
     * @return float|null
     */
    public function getCostoMassimoAccettato()
    {
        return $this->costoMassimoAccettato;
    }
    /**
     * Set costoMassimoAccettato value
     * @param float $costoMassimoAccettato
     * @return \Sisteract\StructType\ParametriRicercaImmobileConservatoriaBean_Type
     */
    public function setCostoMassimoAccettato($costoMassimoAccettato = null)
    {
        // validation for constraint: float
        if (!is_null($costoMassimoAccettato) && !(is_float($costoMassimoAccettato) || is_numeric($costoMassimoAccettato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costoMassimoAccettato, true), gettype($costoMassimoAccettato)), __LINE__);
        }
        $this->costoMassimoAccettato = $costoMassimoAccettato;
        return $this;
    }
    /**
     * Get parametriRestrizioneFormalita value
     * @return \Sisteract\StructType\ParametriRestrizioneFormalita_Type|null
     */
    public function getParametriRestrizioneFormalita()
    {
        return $this->parametriRestrizioneFormalita;
    }
    /**
     * Set parametriRestrizioneFormalita value
     * @param \Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita
     * @return \Sisteract\StructType\ParametriRicercaImmobileConservatoriaBean_Type
     */
    public function setParametriRestrizioneFormalita(\Sisteract\StructType\ParametriRestrizioneFormalita_Type $parametriRestrizioneFormalita = null)
    {
        $this->parametriRestrizioneFormalita = $parametriRestrizioneFormalita;
        return $this;
    }
    /**
     * Get provinciaSede value
     * @return string|null
     */
    public function getProvinciaSede()
    {
        return $this->provinciaSede;
    }
    /**
     * Set provinciaSede value
     * @param string $provinciaSede
     * @return \Sisteract\StructType\ParametriRicercaImmobileConservatoriaBean_Type
     */
    public function setProvinciaSede($provinciaSede = null)
    {
        // validation for constraint: string
        if (!is_null($provinciaSede) && !is_string($provinciaSede)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provinciaSede, true), gettype($provinciaSede)), __LINE__);
        }
        $this->provinciaSede = $provinciaSede;
        return $this;
    }
}
