<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Formalita_Type StructType
 * @subpackage Structs
 */
class Formalita_Type extends AbstractStructBase
{
    /**
     * The cancellata
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che cancellata
     * @var bool
     */
    public $cancellata;
    /**
     * The comuniBeni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna lista dei comuni dove si trovano i beni
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sisteract\StructType\ComuniBean_Type[]
     */
    public $comuniBeni;
    /**
     * The correlazioniFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna eventuali formalità correlate
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sisteract\StructType\CorrelazioneFormalita_Type[]
     */
    public $correlazioniFormalita;
    /**
     * The dataFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna data formlità
     * @var string
     */
    public $dataFormalita;
    /**
     * The dataRepertorio
     * Meta information extracted from the WSDL
     * - documentation: Ritorna data del repertorio
     * - nillable: true
     * @var string
     */
    public $dataRepertorio;
    /**
     * The favoreControFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna favore/contro
     * @var string
     */
    public $favoreControFormalita;
    /**
     * The formatoNota
     * Meta information extracted from the WSDL
     * - documentation: Ritorna formato della nota
     * - nillable: true
     * @var string
     */
    public $formatoNota;
    /**
     * The genereFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna genere della formalità
     * @var string
     */
    public $genereFormalita;
    /**
     * The idFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna identificativo della formalità
     * @var string
     */
    public $idFormalita;
    /**
     * The numeroGenerale
     * Meta information extracted from the WSDL
     * - documentation: Ritorna numero Generale
     * - nillable: true
     * @var string
     */
    public $numeroGenerale;
    /**
     * The numeroParticolare
     * Meta information extracted from the WSDL
     * - documentation: Ritorna numero particolare
     * - nillable: true
     * @var string
     */
    public $numeroParticolare;
    /**
     * The pubblicoUfficiale
     * Meta information extracted from the WSDL
     * - documentation: Ritorna pubblico ufficiale
     * - nillable: true
     * @var string
     */
    public $pubblicoUfficiale;
    /**
     * The repertorio
     * Meta information extracted from the WSDL
     * - documentation: Ritorna repertorio
     * - nillable: true
     * @var string
     */
    public $repertorio;
    /**
     * The rettifica
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se valorizzato indica che si tratta di rettifica
     * @var bool
     */
    public $rettifica;
    /**
     * The riferimentoFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna eventuale fornalità a cui fa riferimento questa formalità
     * - nillable: true
     * @var \Sisteract\StructType\RiferimentoFormalita_Type
     */
    public $riferimentoFormalita;
    /**
     * The specieFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna specie della formalità
     * - nillable: true
     * @var string
     */
    public $specieFormalita;
    /**
     * The tipoFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tipo della formalità
     * - nillable: true
     * @var string
     */
    public $tipoFormalita;
    /**
     * Constructor method for Formalita_Type
     * @uses Formalita_Type::setCancellata()
     * @uses Formalita_Type::setComuniBeni()
     * @uses Formalita_Type::setCorrelazioniFormalita()
     * @uses Formalita_Type::setDataFormalita()
     * @uses Formalita_Type::setDataRepertorio()
     * @uses Formalita_Type::setFavoreControFormalita()
     * @uses Formalita_Type::setFormatoNota()
     * @uses Formalita_Type::setGenereFormalita()
     * @uses Formalita_Type::setIdFormalita()
     * @uses Formalita_Type::setNumeroGenerale()
     * @uses Formalita_Type::setNumeroParticolare()
     * @uses Formalita_Type::setPubblicoUfficiale()
     * @uses Formalita_Type::setRepertorio()
     * @uses Formalita_Type::setRettifica()
     * @uses Formalita_Type::setRiferimentoFormalita()
     * @uses Formalita_Type::setSpecieFormalita()
     * @uses Formalita_Type::setTipoFormalita()
     * @param bool $cancellata
     * @param \Sisteract\StructType\ComuniBean_Type[] $comuniBeni
     * @param \Sisteract\StructType\CorrelazioneFormalita_Type[] $correlazioniFormalita
     * @param string $dataFormalita
     * @param string $dataRepertorio
     * @param string $favoreControFormalita
     * @param string $formatoNota
     * @param string $genereFormalita
     * @param string $idFormalita
     * @param string $numeroGenerale
     * @param string $numeroParticolare
     * @param string $pubblicoUfficiale
     * @param string $repertorio
     * @param bool $rettifica
     * @param \Sisteract\StructType\RiferimentoFormalita_Type $riferimentoFormalita
     * @param string $specieFormalita
     * @param string $tipoFormalita
     */
    public function __construct($cancellata = null, array $comuniBeni = array(), array $correlazioniFormalita = array(), $dataFormalita = null, $dataRepertorio = null, $favoreControFormalita = null, $formatoNota = null, $genereFormalita = null, $idFormalita = null, $numeroGenerale = null, $numeroParticolare = null, $pubblicoUfficiale = null, $repertorio = null, $rettifica = null, \Sisteract\StructType\RiferimentoFormalita_Type $riferimentoFormalita = null, $specieFormalita = null, $tipoFormalita = null)
    {
        $this
            ->setCancellata($cancellata)
            ->setComuniBeni($comuniBeni)
            ->setCorrelazioniFormalita($correlazioniFormalita)
            ->setDataFormalita($dataFormalita)
            ->setDataRepertorio($dataRepertorio)
            ->setFavoreControFormalita($favoreControFormalita)
            ->setFormatoNota($formatoNota)
            ->setGenereFormalita($genereFormalita)
            ->setIdFormalita($idFormalita)
            ->setNumeroGenerale($numeroGenerale)
            ->setNumeroParticolare($numeroParticolare)
            ->setPubblicoUfficiale($pubblicoUfficiale)
            ->setRepertorio($repertorio)
            ->setRettifica($rettifica)
            ->setRiferimentoFormalita($riferimentoFormalita)
            ->setSpecieFormalita($specieFormalita)
            ->setTipoFormalita($tipoFormalita);
    }
    /**
     * Get cancellata value
     * @return bool|null
     */
    public function getCancellata()
    {
        return $this->cancellata;
    }
    /**
     * Set cancellata value
     * @param bool $cancellata
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setCancellata($cancellata = null)
    {
        // validation for constraint: boolean
        if (!is_null($cancellata) && !is_bool($cancellata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cancellata, true), gettype($cancellata)), __LINE__);
        }
        $this->cancellata = $cancellata;
        return $this;
    }
    /**
     * Get comuniBeni value
     * @return \Sisteract\StructType\ComuniBean_Type[]|null
     */
    public function getComuniBeni()
    {
        return $this->comuniBeni;
    }
    /**
     * This method is responsible for validating the values passed to the setComuniBeni method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComuniBeni method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateComuniBeniForArrayConstraintsFromSetComuniBeni(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formalita_TypeComuniBeniItem) {
            // validation for constraint: itemType
            if (!$formalita_TypeComuniBeniItem instanceof \Sisteract\StructType\ComuniBean_Type) {
                $invalidValues[] = is_object($formalita_TypeComuniBeniItem) ? get_class($formalita_TypeComuniBeniItem) : sprintf('%s(%s)', gettype($formalita_TypeComuniBeniItem), var_export($formalita_TypeComuniBeniItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The comuniBeni property can only contain items of type \Sisteract\StructType\ComuniBean_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set comuniBeni value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuniBean_Type[] $comuniBeni
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setComuniBeni(array $comuniBeni = array())
    {
        // validation for constraint: array
        if ('' !== ($comuniBeniArrayErrorMessage = self::validateComuniBeniForArrayConstraintsFromSetComuniBeni($comuniBeni))) {
            throw new \InvalidArgumentException($comuniBeniArrayErrorMessage, __LINE__);
        }
        $this->comuniBeni = $comuniBeni;
        return $this;
    }
    /**
     * Add item to comuniBeni value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\ComuniBean_Type $item
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function addToComuniBeni(\Sisteract\StructType\ComuniBean_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\ComuniBean_Type) {
            throw new \InvalidArgumentException(sprintf('The comuniBeni property can only contain items of type \Sisteract\StructType\ComuniBean_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->comuniBeni[] = $item;
        return $this;
    }
    /**
     * Get correlazioniFormalita value
     * @return \Sisteract\StructType\CorrelazioneFormalita_Type[]|null
     */
    public function getCorrelazioniFormalita()
    {
        return $this->correlazioniFormalita;
    }
    /**
     * This method is responsible for validating the values passed to the setCorrelazioniFormalita method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCorrelazioniFormalita method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCorrelazioniFormalitaForArrayConstraintsFromSetCorrelazioniFormalita(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $formalita_TypeCorrelazioniFormalitaItem) {
            // validation for constraint: itemType
            if (!$formalita_TypeCorrelazioniFormalitaItem instanceof \Sisteract\StructType\CorrelazioneFormalita_Type) {
                $invalidValues[] = is_object($formalita_TypeCorrelazioniFormalitaItem) ? get_class($formalita_TypeCorrelazioniFormalitaItem) : sprintf('%s(%s)', gettype($formalita_TypeCorrelazioniFormalitaItem), var_export($formalita_TypeCorrelazioniFormalitaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The correlazioniFormalita property can only contain items of type \Sisteract\StructType\CorrelazioneFormalita_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set correlazioniFormalita value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\CorrelazioneFormalita_Type[] $correlazioniFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setCorrelazioniFormalita(array $correlazioniFormalita = array())
    {
        // validation for constraint: array
        if ('' !== ($correlazioniFormalitaArrayErrorMessage = self::validateCorrelazioniFormalitaForArrayConstraintsFromSetCorrelazioniFormalita($correlazioniFormalita))) {
            throw new \InvalidArgumentException($correlazioniFormalitaArrayErrorMessage, __LINE__);
        }
        $this->correlazioniFormalita = $correlazioniFormalita;
        return $this;
    }
    /**
     * Add item to correlazioniFormalita value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\CorrelazioneFormalita_Type $item
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function addToCorrelazioniFormalita(\Sisteract\StructType\CorrelazioneFormalita_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\CorrelazioneFormalita_Type) {
            throw new \InvalidArgumentException(sprintf('The correlazioniFormalita property can only contain items of type \Sisteract\StructType\CorrelazioneFormalita_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->correlazioniFormalita[] = $item;
        return $this;
    }
    /**
     * Get dataFormalita value
     * @return string|null
     */
    public function getDataFormalita()
    {
        return $this->dataFormalita;
    }
    /**
     * Set dataFormalita value
     * @param string $dataFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setDataFormalita($dataFormalita = null)
    {
        // validation for constraint: string
        if (!is_null($dataFormalita) && !is_string($dataFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFormalita, true), gettype($dataFormalita)), __LINE__);
        }
        $this->dataFormalita = $dataFormalita;
        return $this;
    }
    /**
     * Get dataRepertorio value
     * @return string|null
     */
    public function getDataRepertorio()
    {
        return $this->dataRepertorio;
    }
    /**
     * Set dataRepertorio value
     * @param string $dataRepertorio
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setDataRepertorio($dataRepertorio = null)
    {
        // validation for constraint: string
        if (!is_null($dataRepertorio) && !is_string($dataRepertorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRepertorio, true), gettype($dataRepertorio)), __LINE__);
        }
        $this->dataRepertorio = $dataRepertorio;
        return $this;
    }
    /**
     * Get favoreControFormalita value
     * @return string|null
     */
    public function getFavoreControFormalita()
    {
        return $this->favoreControFormalita;
    }
    /**
     * Set favoreControFormalita value
     * @uses \Sisteract\EnumType\FavoreControFormalita_Type::valueIsValid()
     * @uses \Sisteract\EnumType\FavoreControFormalita_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $favoreControFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setFavoreControFormalita($favoreControFormalita = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\FavoreControFormalita_Type::valueIsValid($favoreControFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\FavoreControFormalita_Type', is_array($favoreControFormalita) ? implode(', ', $favoreControFormalita) : var_export($favoreControFormalita, true), implode(', ', \Sisteract\EnumType\FavoreControFormalita_Type::getValidValues())), __LINE__);
        }
        $this->favoreControFormalita = $favoreControFormalita;
        return $this;
    }
    /**
     * Get formatoNota value
     * @return string|null
     */
    public function getFormatoNota()
    {
        return $this->formatoNota;
    }
    /**
     * Set formatoNota value
     * @uses \Sisteract\EnumType\FormatoNota_Type::valueIsValid()
     * @uses \Sisteract\EnumType\FormatoNota_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formatoNota
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setFormatoNota($formatoNota = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\FormatoNota_Type::valueIsValid($formatoNota)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\FormatoNota_Type', is_array($formatoNota) ? implode(', ', $formatoNota) : var_export($formatoNota, true), implode(', ', \Sisteract\EnumType\FormatoNota_Type::getValidValues())), __LINE__);
        }
        $this->formatoNota = $formatoNota;
        return $this;
    }
    /**
     * Get genereFormalita value
     * @return string|null
     */
    public function getGenereFormalita()
    {
        return $this->genereFormalita;
    }
    /**
     * Set genereFormalita value
     * @uses \Sisteract\EnumType\GenereFormalita_Type::valueIsValid()
     * @uses \Sisteract\EnumType\GenereFormalita_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $genereFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setGenereFormalita($genereFormalita = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\GenereFormalita_Type::valueIsValid($genereFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\GenereFormalita_Type', is_array($genereFormalita) ? implode(', ', $genereFormalita) : var_export($genereFormalita, true), implode(', ', \Sisteract\EnumType\GenereFormalita_Type::getValidValues())), __LINE__);
        }
        $this->genereFormalita = $genereFormalita;
        return $this;
    }
    /**
     * Get idFormalita value
     * @return string|null
     */
    public function getIdFormalita()
    {
        return $this->idFormalita;
    }
    /**
     * Set idFormalita value
     * @param string $idFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setIdFormalita($idFormalita = null)
    {
        // validation for constraint: string
        if (!is_null($idFormalita) && !is_string($idFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idFormalita, true), gettype($idFormalita)), __LINE__);
        }
        $this->idFormalita = $idFormalita;
        return $this;
    }
    /**
     * Get numeroGenerale value
     * @return string|null
     */
    public function getNumeroGenerale()
    {
        return $this->numeroGenerale;
    }
    /**
     * Set numeroGenerale value
     * @param string $numeroGenerale
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setNumeroGenerale($numeroGenerale = null)
    {
        // validation for constraint: string
        if (!is_null($numeroGenerale) && !is_string($numeroGenerale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroGenerale, true), gettype($numeroGenerale)), __LINE__);
        }
        $this->numeroGenerale = $numeroGenerale;
        return $this;
    }
    /**
     * Get numeroParticolare value
     * @return string|null
     */
    public function getNumeroParticolare()
    {
        return $this->numeroParticolare;
    }
    /**
     * Set numeroParticolare value
     * @param string $numeroParticolare
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setNumeroParticolare($numeroParticolare = null)
    {
        // validation for constraint: string
        if (!is_null($numeroParticolare) && !is_string($numeroParticolare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroParticolare, true), gettype($numeroParticolare)), __LINE__);
        }
        $this->numeroParticolare = $numeroParticolare;
        return $this;
    }
    /**
     * Get pubblicoUfficiale value
     * @return string|null
     */
    public function getPubblicoUfficiale()
    {
        return $this->pubblicoUfficiale;
    }
    /**
     * Set pubblicoUfficiale value
     * @param string $pubblicoUfficiale
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setPubblicoUfficiale($pubblicoUfficiale = null)
    {
        // validation for constraint: string
        if (!is_null($pubblicoUfficiale) && !is_string($pubblicoUfficiale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pubblicoUfficiale, true), gettype($pubblicoUfficiale)), __LINE__);
        }
        $this->pubblicoUfficiale = $pubblicoUfficiale;
        return $this;
    }
    /**
     * Get repertorio value
     * @return string|null
     */
    public function getRepertorio()
    {
        return $this->repertorio;
    }
    /**
     * Set repertorio value
     * @param string $repertorio
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setRepertorio($repertorio = null)
    {
        // validation for constraint: string
        if (!is_null($repertorio) && !is_string($repertorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repertorio, true), gettype($repertorio)), __LINE__);
        }
        $this->repertorio = $repertorio;
        return $this;
    }
    /**
     * Get rettifica value
     * @return bool|null
     */
    public function getRettifica()
    {
        return $this->rettifica;
    }
    /**
     * Set rettifica value
     * @param bool $rettifica
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setRettifica($rettifica = null)
    {
        // validation for constraint: boolean
        if (!is_null($rettifica) && !is_bool($rettifica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rettifica, true), gettype($rettifica)), __LINE__);
        }
        $this->rettifica = $rettifica;
        return $this;
    }
    /**
     * Get riferimentoFormalita value
     * @return \Sisteract\StructType\RiferimentoFormalita_Type|null
     */
    public function getRiferimentoFormalita()
    {
        return $this->riferimentoFormalita;
    }
    /**
     * Set riferimentoFormalita value
     * @param \Sisteract\StructType\RiferimentoFormalita_Type $riferimentoFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setRiferimentoFormalita(\Sisteract\StructType\RiferimentoFormalita_Type $riferimentoFormalita = null)
    {
        $this->riferimentoFormalita = $riferimentoFormalita;
        return $this;
    }
    /**
     * Get specieFormalita value
     * @return string|null
     */
    public function getSpecieFormalita()
    {
        return $this->specieFormalita;
    }
    /**
     * Set specieFormalita value
     * @param string $specieFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setSpecieFormalita($specieFormalita = null)
    {
        // validation for constraint: string
        if (!is_null($specieFormalita) && !is_string($specieFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specieFormalita, true), gettype($specieFormalita)), __LINE__);
        }
        $this->specieFormalita = $specieFormalita;
        return $this;
    }
    /**
     * Get tipoFormalita value
     * @return string|null
     */
    public function getTipoFormalita()
    {
        return $this->tipoFormalita;
    }
    /**
     * Set tipoFormalita value
     * @param string $tipoFormalita
     * @return \Sisteract\StructType\Formalita_Type
     */
    public function setTipoFormalita($tipoFormalita = null)
    {
        // validation for constraint: string
        if (!is_null($tipoFormalita) && !is_string($tipoFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoFormalita, true), gettype($tipoFormalita)), __LINE__);
        }
        $this->tipoFormalita = $tipoFormalita;
        return $this;
    }
}
