<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorrelazioneFormalita_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Rappresenta la correlazione per una formalità
 * @subpackage Structs
 */
class CorrelazioneFormalita_Type extends AbstractStructBase
{
    /**
     * The data
     * Meta information extracted from the WSDL
     * - documentation: Ritorna data della formalità
     * @var string
     */
    public $data;
    /**
     * The genereFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna genere della formalità
     * @var string
     */
    public $genereFormalita;
    /**
     * The numero
     * Meta information extracted from the WSDL
     * - documentation: Ritorna numero della formalità
     * @var string
     */
    public $numero;
    /**
     * The tipo
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tipo formalità
     * - nillable: true
     * @var string
     */
    public $tipo;
    /**
     * Constructor method for CorrelazioneFormalita_Type
     * @uses CorrelazioneFormalita_Type::setData()
     * @uses CorrelazioneFormalita_Type::setGenereFormalita()
     * @uses CorrelazioneFormalita_Type::setNumero()
     * @uses CorrelazioneFormalita_Type::setTipo()
     * @param string $data
     * @param string $genereFormalita
     * @param string $numero
     * @param string $tipo
     */
    public function __construct($data = null, $genereFormalita = null, $numero = null, $tipo = null)
    {
        $this
            ->setData($data)
            ->setGenereFormalita($genereFormalita)
            ->setNumero($numero)
            ->setTipo($tipo);
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \Sisteract\StructType\CorrelazioneFormalita_Type
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get genereFormalita value
     * @return string|null
     */
    public function getGenereFormalita()
    {
        return $this->genereFormalita;
    }
    /**
     * Set genereFormalita value
     * @uses \Sisteract\EnumType\GenereFormalita_Type::valueIsValid()
     * @uses \Sisteract\EnumType\GenereFormalita_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $genereFormalita
     * @return \Sisteract\StructType\CorrelazioneFormalita_Type
     */
    public function setGenereFormalita($genereFormalita = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\GenereFormalita_Type::valueIsValid($genereFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\GenereFormalita_Type', is_array($genereFormalita) ? implode(', ', $genereFormalita) : var_export($genereFormalita, true), implode(', ', \Sisteract\EnumType\GenereFormalita_Type::getValidValues())), __LINE__);
        }
        $this->genereFormalita = $genereFormalita;
        return $this;
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \Sisteract\StructType\CorrelazioneFormalita_Type
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
    /**
     * Get tipo value
     * @return string|null
     */
    public function getTipo()
    {
        return $this->tipo;
    }
    /**
     * Set tipo value
     * @param string $tipo
     * @return \Sisteract\StructType\CorrelazioneFormalita_Type
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: string
        if (!is_null($tipo) && !is_string($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipo, true), gettype($tipo)), __LINE__);
        }
        $this->tipo = $tipo;
        return $this;
    }
}
