<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lista ServiceType
 * @subpackage Services
 */
class Lista extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named listaUtentiSisterMemorizzati
     * Meta information extracted from the WSDL
     * - documentation: Lista tutti gli utenti sister presenti sul sistema in modalità gestita, per l'azienda loggata.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\ListaUtentiSisterMemorizzatiIn_Type $part1
     * @return \Sisteract\StructType\ListaUtentiSisterMemorizzatiOut_Type|bool
     */
    public function listaUtentiSisterMemorizzati(\Sisteract\StructType\ListaUtentiSisterMemorizzatiIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->listaUtentiSisterMemorizzati($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named listaVisureInArchivio
     * Meta information extracted from the WSDL
     * - documentation: Ritorna una lista di tutte le visure richieste sul sistema negli ultimi due giorni.Trascorso il limite dei due giorni le visure richieste potrebbero non essere più scaricabili.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\ListaVisureInArchivioIn_Type $part1
     * @return \Sisteract\StructType\ListaVisureInArchivioOut_Type|bool
     */
    public function listaVisureInArchivio(\Sisteract\StructType\ListaVisureInArchivioIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->listaVisureInArchivio($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * listaVisureInArchivioPerCodiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Ritorna una lista di tutte le visure richieste sul sistema per un codice fiscale.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\ListaVisureInArchivioPerCodiceFiscaleIn_Type $part1
     * @return \Sisteract\StructType\ListaVisureInArchivioPerCodiceFiscaleOut_Type|bool
     */
    public function listaVisureInArchivioPerCodiceFiscale(\Sisteract\StructType\ListaVisureInArchivioPerCodiceFiscaleIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->listaVisureInArchivioPerCodiceFiscale($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\ListaUtentiSisterMemorizzatiOut_Type|\Sisteract\StructType\ListaVisureInArchivioOut_Type|\Sisteract\StructType\ListaVisureInArchivioPerCodiceFiscaleOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
