<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getEstrattoMappa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetEstrattoMappaIn_Type $part1
     * @return \Sisteract\StructType\GetEstrattoMappaOut_Type|bool
     */
    public function getEstrattoMappa(\Sisteract\StructType\GetEstrattoMappaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getEstrattoMappa($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFormalita
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetFormalitaIn_Type $part1
     * @return \Sisteract\StructType\GetFormalitaOut_Type|bool
     */
    public function getFormalita(\Sisteract\StructType\GetFormalitaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getFormalita($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetNotaIn_Type $part1
     * @return \Sisteract\StructType\GetNotaOut_Type|bool
     */
    public function getNota(\Sisteract\StructType\GetNotaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getNota($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTitoloConservatoria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetTitoloConservatoriaIn_Type $part1
     * @return \Sisteract\StructType\GetTitoloConservatoriaOut_Type|bool
     */
    public function getTitoloConservatoria(\Sisteract\StructType\GetTitoloConservatoriaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getTitoloConservatoria($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRichiestaSchedaCatastaleImmobili
     * Meta information extracted from the WSDL
     * - documentation: Richiesta scheda catastale per immobile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRichiestaSchedaCatastaleImmobiliIn_Type $part1
     * @return \Sisteract\StructType\GetRichiestaSchedaCatastaleImmobiliOut_Type|bool
     */
    public function getRichiestaSchedaCatastaleImmobili(\Sisteract\StructType\GetRichiestaSchedaCatastaleImmobiliIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRichiestaSchedaCatastaleImmobili($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRichiestaVisuraImmobili
     * Meta information extracted from the WSDL
     * - documentation: Richiesta visura per immobile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRichiestaVisuraImmobiliIn_Type $part1
     * @return \Sisteract\StructType\GetRichiestaVisuraImmobiliOut_Type|bool
     */
    public function getRichiestaVisuraImmobili(\Sisteract\StructType\GetRichiestaVisuraImmobiliIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRichiestaVisuraImmobili($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRichiestaSchedaCatastaleSoggetto
     * Meta information extracted from the WSDL
     * - documentation: Richiesta scheda catastale per soggetto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRichiestaSchedaCatastaleSoggettoIn_Type $part1
     * @return \Sisteract\StructType\GetRichiestaSchedaCatastaleSoggettoOut_Type|bool
     */
    public function getRichiestaSchedaCatastaleSoggetto(\Sisteract\StructType\GetRichiestaSchedaCatastaleSoggettoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRichiestaSchedaCatastaleSoggetto($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRichiestaVisuraSoggetto
     * Meta information extracted from the WSDL
     * - documentation: Richiesta visura per soggetto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRichiestaVisuraSoggettoIn_Type $part1
     * @return \Sisteract\StructType\GetRichiestaVisuraSoggettoOut_Type|bool
     */
    public function getRichiestaVisuraSoggetto(\Sisteract\StructType\GetRichiestaVisuraSoggettoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRichiestaVisuraSoggetto($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVisuraByTicket
     * Meta information extracted from the WSDL
     * - documentation: Scarica la visura tramite il ticket (per le differite)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetVisuraByTicketIn_Type $part1
     * @return \Sisteract\StructType\GetVisuraByTicketOut_Type|bool
     */
    public function getVisuraByTicket(\Sisteract\StructType\GetVisuraByTicketIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getVisuraByTicket($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ricerca delle persone fisiche/giuridiche in conservatoriaElenco formalità
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoFormalitaIn_Type $part1
     * @return \Sisteract\StructType\GetElencoFormalitaOut_Type|bool
     */
    public function getElencoFormalita(\Sisteract\StructType\GetElencoFormalitaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoFormalita($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoFormalitaImmobile
     * Meta information extracted from the WSDL
     * - documentation: Ricerca degli immobili in conservatoriaElenco formalità
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoFormalitaImmobileIn_Type $part1
     * @return \Sisteract\StructType\GetElencoFormalitaImmobileOut_Type|bool
     */
    public function getElencoFormalitaImmobile(\Sisteract\StructType\GetElencoFormalitaImmobileIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoFormalitaImmobile($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoFormalitaImmobilePdf
     * Meta information extracted from the WSDL
     * - documentation: Ricerca degli immobili in conservatoriaElenco formalità
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoFormalitaImmobilePdfIn_Type $part1
     * @return \Sisteract\StructType\GetElencoFormalitaImmobilePdfOut_Type|bool
     */
    public function getElencoFormalitaImmobilePdf(\Sisteract\StructType\GetElencoFormalitaImmobilePdfIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoFormalitaImmobilePdf($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoFormalitaPdf
     * Meta information extracted from the WSDL
     * - documentation: Ricerca delle persone fisiche/giuridiche in conservatoriaElenco formalità
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoFormalitaPdfIn_Type $part1
     * @return \Sisteract\StructType\GetElencoFormalitaPdfOut_Type|bool
     */
    public function getElencoFormalitaPdf(\Sisteract\StructType\GetElencoFormalitaPdfIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoFormalitaPdf($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoImmobili
     * Meta information extracted from the WSDL
     * - documentation: Visualizza l'elenco immobili di una provincia di un soggetto individuato tramite lefunzioni di ricerca.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoImmobiliIn_Type $part1
     * @return \Sisteract\StructType\GetElencoImmobiliOut_Type|bool
     */
    public function getElencoImmobili(\Sisteract\StructType\GetElencoImmobiliIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoImmobili($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRicercaConservatoriaImmobile
     * Meta information extracted from the WSDL
     * - documentation: Ricerca su conservatoria per gli immobili
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaConservatoriaImmobileIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaConservatoriaImmobileOut_Type|bool
     */
    public function getRicercaConservatoriaImmobile(\Sisteract\StructType\GetRicercaConservatoriaImmobileIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaConservatoriaImmobile($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getElencoIntestati
     * Meta information extracted from the WSDL
     * - documentation: Visualizza l'elenco intestati di una provincia di un soggetto e di un immobileindividuato tramite le funzioni di ricerca.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetElencoIntestatiIn_Type $part1
     * @return \Sisteract\StructType\GetElencoIntestatiOut_Type|bool
     */
    public function getElencoIntestati(\Sisteract\StructType\GetElencoIntestatiIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getElencoIntestati($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRicercaImmobiliDaListaIndirizzi
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per indirizzo su immobiliScelta dell'indirizzo tornato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaImmobiliDaListaIndirizziIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaImmobiliDaListaIndirizziOut_Type|bool
     */
    public function getRicercaImmobiliDaListaIndirizzi(\Sisteract\StructType\GetRicercaImmobiliDaListaIndirizziIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaImmobiliDaListaIndirizzi($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRicercaImmobiliIdentificativo
     * Meta information extracted from the WSDL
     * - documentation: Ricerca nel comune un immobile tramite un identificativo catastale, o tramiteun identificativo temporaneo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaImmobiliIdentificativoIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaImmobiliIdentificativoOut_Type|bool
     */
    public function getRicercaImmobiliIdentificativo(\Sisteract\StructType\GetRicercaImmobiliIdentificativoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaImmobiliIdentificativo($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRicercaImmobiliIndirizzoNoToponimo
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per comune su immobili senza toponimo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaImmobiliIndirizzoNoToponimoIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaImmobiliIndirizzoNoToponimoOut_Type|bool
     */
    public function getRicercaImmobiliIndirizzoNoToponimo(\Sisteract\StructType\GetRicercaImmobiliIndirizzoNoToponimoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaImmobiliIndirizzoNoToponimo($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRicercaImmobiliIndirizzoToponimo
     * Meta information extracted from the WSDL
     * - documentation: Ricerca per comune su immobili con toponimo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaImmobiliIndirizzoToponimoIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaImmobiliIndirizzoToponimoOut_Type|bool
     */
    public function getRicercaImmobiliIndirizzoToponimo(\Sisteract\StructType\GetRicercaImmobiliIndirizzoToponimoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaImmobiliIndirizzoToponimo($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRicercaConservatoriaPersonaFisica
     * Meta information extracted from the WSDL
     * - documentation: Ricerca su conservatoria delle persone fisiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaConservatoriaPersonaFisicaIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaConservatoriaPersonaFisicaOut_Type|bool
     */
    public function getRicercaConservatoriaPersonaFisica(\Sisteract\StructType\GetRicercaConservatoriaPersonaFisicaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaConservatoriaPersonaFisica($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRicercaNazionalePersonaFisica
     * Meta information extracted from the WSDL
     * - documentation: Ricerca nazionale delle persone fisiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaNazionalePersonaFisicaIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaNazionalePersonaFisicaOut_Type|bool
     */
    public function getRicercaNazionalePersonaFisica(\Sisteract\StructType\GetRicercaNazionalePersonaFisicaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaNazionalePersonaFisica($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRicercaConservatoriaPersonaGiuridica
     * Meta information extracted from the WSDL
     * - documentation: Ricerca su conservatoria delle persone giuridiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaConservatoriaPersonaGiuridicaIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaConservatoriaPersonaGiuridicaOut_Type|bool
     */
    public function getRicercaConservatoriaPersonaGiuridica(\Sisteract\StructType\GetRicercaConservatoriaPersonaGiuridicaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaConservatoriaPersonaGiuridica($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * getRicercaNazionalePersonaGiuridica
     * Meta information extracted from the WSDL
     * - documentation: Ricerca nazionale delle persone giuridiche
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRicercaNazionalePersonaGiuridicaIn_Type $part1
     * @return \Sisteract\StructType\GetRicercaNazionalePersonaGiuridicaOut_Type|bool
     */
    public function getRicercaNazionalePersonaGiuridica(\Sisteract\StructType\GetRicercaNazionalePersonaGiuridicaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRicercaNazionalePersonaGiuridica($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getListaComuni
     * Meta information extracted from the WSDL
     * - documentation: Ricerca nazionale delle persone fisiche/giuridicheScelta della provincia su cui visualizare le proprieta'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetListaComuniIn_Type $part1
     * @return \Sisteract\StructType\GetListaComuniOut_Type|bool
     */
    public function getListaComuni(\Sisteract\StructType\GetListaComuniIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getListaComuni($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRichiestaTipiVisuraImmobile
     * Meta information extracted from the WSDL
     * - documentation: Ricerca comunale degli immobiliVisualizzazione visure immobili disponibili
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetRichiestaTipiVisuraImmobileIn_Type $part1
     * @return \Sisteract\StructType\GetRichiestaTipiVisuraImmobileOut_Type|bool
     */
    public function getRichiestaTipiVisuraImmobile(\Sisteract\StructType\GetRichiestaTipiVisuraImmobileIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getRichiestaTipiVisuraImmobile($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getComuni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la lista dei comuni con codice amministrativo, per la provincia passata
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetComuniIn_Type $part1
     * @return \Sisteract\StructType\GetComuniOut_Type|bool
     */
    public function getComuni(\Sisteract\StructType\GetComuniIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getComuni($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getComuniCatastali
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la lista dei comuni con codice catastale, per la provincia passata
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetComuniCatastaliIn_Type $part1
     * @return \Sisteract\StructType\GetComuniCatastaliOut_Type|bool
     */
    public function getComuniCatastali(\Sisteract\StructType\GetComuniCatastaliIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getComuniCatastali($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getComuniConservatoria
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la lista dei comuni con codice catastale, per la conservatoria passata
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetComuniConservatoriaIn_Type $part1
     * @return \Sisteract\StructType\GetComuniConservatoriaOut_Type|bool
     */
    public function getComuniConservatoria(\Sisteract\StructType\GetComuniConservatoriaIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getComuniConservatoria($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConservatorie
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tutte le conservatorie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetConservatorieIn_Type $part1
     * @return \Sisteract\StructType\GetConservatorieOut_Type|bool
     */
    public function getConservatorie(\Sisteract\StructType\GetConservatorieIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getConservatorie($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProvincie
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tutte le provincie del catasto, con le date di aggiornamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetProvincieIn_Type $part1
     * @return \Sisteract\StructType\GetProvincieOut_Type|bool
     */
    public function getProvincie(\Sisteract\StructType\GetProvincieIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getProvincie($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSezioni
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la lista delle sezioni censuarie del comune passato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetSezioniIn_Type $part1
     * @return \Sisteract\StructType\GetSezioniOut_Type|bool
     */
    public function getSezioni(\Sisteract\StructType\GetSezioniIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getSezioni($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getToponimi
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tutte i toponimi del catasto, (viene aggiornato dal job)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetToponimiIn_Type $part1
     * @return \Sisteract\StructType\GetToponimiOut_Type|bool
     */
    public function getToponimi(\Sisteract\StructType\GetToponimiIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getToponimi($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProvincieAmministrative
     * Meta information extracted from the WSDL
     * - documentation: Ritorna tutte le provincie amministrative
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\GetProvincieAmministrativeIn_Type $part1
     * @return \Sisteract\StructType\GetProvincieAmministrativeOut_Type|bool
     */
    public function getProvincieAmministrative(\Sisteract\StructType\GetProvincieAmministrativeIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->getProvincieAmministrative($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\GetComuniCatastaliOut_Type|\Sisteract\StructType\GetComuniConservatoriaOut_Type|\Sisteract\StructType\GetComuniOut_Type|\Sisteract\StructType\GetConservatorieOut_Type|\Sisteract\StructType\GetElencoFormalitaImmobileOut_Type|\Sisteract\StructType\GetElencoFormalitaImmobilePdfOut_Type|\Sisteract\StructType\GetElencoFormalitaOut_Type|\Sisteract\StructType\GetElencoFormalitaPdfOut_Type|\Sisteract\StructType\GetElencoImmobiliOut_Type|\Sisteract\StructType\GetElencoIntestatiOut_Type|\Sisteract\StructType\GetEstrattoMappaOut_Type|\Sisteract\StructType\GetFormalitaOut_Type|\Sisteract\StructType\GetListaComuniOut_Type|\Sisteract\StructType\GetNotaOut_Type|\Sisteract\StructType\GetProvincieAmministrativeOut_Type|\Sisteract\StructType\GetProvincieOut_Type|\Sisteract\StructType\GetRicercaConservatoriaImmobileOut_Type|\Sisteract\StructType\GetRicercaConservatoriaPersonaFisicaOut_Type|\Sisteract\StructType\GetRicercaConservatoriaPersonaGiuridicaOut_Type|\Sisteract\StructType\GetRicercaImmobiliDaListaIndirizziOut_Type|\Sisteract\StructType\GetRicercaImmobiliIdentificativoOut_Type|\Sisteract\StructType\GetRicercaImmobiliIndirizzoNoToponimoOut_Type|\Sisteract\StructType\GetRicercaImmobiliIndirizzoToponimoOut_Type|\Sisteract\StructType\GetRicercaNazionalePersonaFisicaOut_Type|\Sisteract\StructType\GetRicercaNazionalePersonaGiuridicaOut_Type|\Sisteract\StructType\GetRichiestaSchedaCatastaleImmobiliOut_Type|\Sisteract\StructType\GetRichiestaSchedaCatastaleSoggettoOut_Type|\Sisteract\StructType\GetRichiestaTipiVisuraImmobileOut_Type|\Sisteract\StructType\GetRichiestaVisuraImmobiliOut_Type|\Sisteract\StructType\GetRichiestaVisuraSoggettoOut_Type|\Sisteract\StructType\GetSezioniOut_Type|\Sisteract\StructType\GetTitoloConservatoriaOut_Type|\Sisteract\StructType\GetToponimiOut_Type|\Sisteract\StructType\GetVisuraByTicketOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
