<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Elimina ServiceType
 * @subpackage Services
 */
class Elimina extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eliminaUtenteSisterMemorizzato
     * Meta information extracted from the WSDL
     * - documentation: Elimina dal sistema una password sister. L'utente passato dal momento in cui si completa la chiamatanon farà più parte della modalità gestita.Nota che è considerato un errore tentare di eliminare un utente che non è stato
     * precedentemente inserito.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\EliminaUtenteSisterMemorizzatoIn_Type $part1
     * @return \Sisteract\StructType\EliminaUtenteSisterMemorizzatoOut_Type|bool
     */
    public function eliminaUtenteSisterMemorizzato(\Sisteract\StructType\EliminaUtenteSisterMemorizzatoIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->eliminaUtenteSisterMemorizzato($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\EliminaUtenteSisterMemorizzatoOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
