<?php

namespace Sisteract\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Chiudi ServiceType
 * @subpackage Services
 */
class Chiudi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named chiudiSessione
     * Meta information extracted from the WSDL
     * - documentation: Chiude una sessione di lavoro.Nel momento della prima chiamata a una qualsiasi delle funzioni del servizio le credenziali sister utilizzate,sia che siano state passate dall'utente alla chiamata, sia che siano state pescate dal
     * software tra le credenzialicensite, vengono "bloccate"; ovvero il sistema effettua il login sul portale sister, ma non esce.Questo per ottimizzare i tempi di richiesta e per assicurarsi che non ci siano interferenze tra un eventuale lavoro manuale
     * ele richieste effettuate dal software.Ci possono essere casi in cui si desidera liberare la sessione alla fine del flusso di lavoro. Questa funzione libera le credenziali utilizzate.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sisteract\StructType\ChiudiSessioneIn_Type $part1
     * @return \Sisteract\StructType\ChiudiSessioneOut_Type|bool
     */
    public function chiudiSessione(\Sisteract\StructType\ChiudiSessioneIn_Type $part1)
    {
        try {
            $this->setResult($this->getSoapClient()->chiudiSessione($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sisteract\StructType\ChiudiSessioneOut_Type
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
