<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VisuraDaArchivio_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Rappresenta una visura catastale come memorizzata negli archivi.Si può riferire sia ad una visura andata in differita, sia ad una visura già scaricata.Tramite l'identificativo della visura (il ticket) si può andare a scaricare la
 * stessa dal sistema.
 * @subpackage Structs
 */
class VisuraDaArchivio_Type extends AbstractStructBase
{
    /**
     * The codiceFiscale
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il codice fiscale relativo alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $codiceFiscale;
    /**
     * The dataEvasione
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la data in cui è stata evasa la visura
     * - nillable: true
     * @var string
     */
    public $dataEvasione;
    /**
     * The dataRichiesta
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la data in cui è stata richiesta la visura
     * @var string
     */
    public $dataRichiesta;
    /**
     * The denominatore
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il denominatore relativo alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $denominatore;
    /**
     * The denominazione
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la denominazione relativa alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $denominazione;
    /**
     * The espletabile
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se la visura è espletabile o meno
     * @var bool
     */
    public $espletabile;
    /**
     * The evasa
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se la visura è stata evasa o meno
     * @var bool
     */
    public $evasa;
    /**
     * The foglio
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il foglio relativo alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $foglio;
    /**
     * The indirizzoTrovato
     * Meta information extracted from the WSDL
     * - documentation: Ritorna nel caso di visura per immobile su fabbricati 'indirizzo del fabbricato come risulta dal catasto
     * - nillable: true
     * @var string
     */
    public $indirizzoTrovato;
    /**
     * The particella
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la particella relativa alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $particella;
    /**
     * The partita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna la partita relativa alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $partita;
    /**
     * The posizioniImmobiliVisura
     * Meta information extracted from the WSDL
     * - documentation: Ritorna posizionamento degli immobili in visura
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sisteract\StructType\PosizioneImmobiliVisura_Type[]
     */
    public $posizioniImmobiliVisura;
    /**
     * The scaricata
     * Meta information extracted from the WSDL
     * - documentation: Ritorna se la visura è stata scaricata almeno una volta
     * @var bool
     */
    public $scaricata;
    /**
     * The sub
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il sub relativo alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $sub;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - documentation: Ritorna l'identificativo unico della visura
     * @var string
     */
    public $ticket;
    /**
     * The tipoPersona
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il tipo di persona relativo alla visura richiesta
     * - nillable: true
     * @var string
     */
    public $tipoPersona;
    /**
     * The tipoVisura
     * Meta information extracted from the WSDL
     * - documentation: Ritorna il tipo di visura richiesta
     * - nillable: true
     * @var string
     */
    public $tipoVisura;
    /**
     * Constructor method for VisuraDaArchivio_Type
     * @uses VisuraDaArchivio_Type::setCodiceFiscale()
     * @uses VisuraDaArchivio_Type::setDataEvasione()
     * @uses VisuraDaArchivio_Type::setDataRichiesta()
     * @uses VisuraDaArchivio_Type::setDenominatore()
     * @uses VisuraDaArchivio_Type::setDenominazione()
     * @uses VisuraDaArchivio_Type::setEspletabile()
     * @uses VisuraDaArchivio_Type::setEvasa()
     * @uses VisuraDaArchivio_Type::setFoglio()
     * @uses VisuraDaArchivio_Type::setIndirizzoTrovato()
     * @uses VisuraDaArchivio_Type::setParticella()
     * @uses VisuraDaArchivio_Type::setPartita()
     * @uses VisuraDaArchivio_Type::setPosizioniImmobiliVisura()
     * @uses VisuraDaArchivio_Type::setScaricata()
     * @uses VisuraDaArchivio_Type::setSub()
     * @uses VisuraDaArchivio_Type::setTicket()
     * @uses VisuraDaArchivio_Type::setTipoPersona()
     * @uses VisuraDaArchivio_Type::setTipoVisura()
     * @param string $codiceFiscale
     * @param string $dataEvasione
     * @param string $dataRichiesta
     * @param string $denominatore
     * @param string $denominazione
     * @param bool $espletabile
     * @param bool $evasa
     * @param string $foglio
     * @param string $indirizzoTrovato
     * @param string $particella
     * @param string $partita
     * @param \Sisteract\StructType\PosizioneImmobiliVisura_Type[] $posizioniImmobiliVisura
     * @param bool $scaricata
     * @param string $sub
     * @param string $ticket
     * @param string $tipoPersona
     * @param string $tipoVisura
     */
    public function __construct($codiceFiscale = null, $dataEvasione = null, $dataRichiesta = null, $denominatore = null, $denominazione = null, $espletabile = null, $evasa = null, $foglio = null, $indirizzoTrovato = null, $particella = null, $partita = null, array $posizioniImmobiliVisura = array(), $scaricata = null, $sub = null, $ticket = null, $tipoPersona = null, $tipoVisura = null)
    {
        $this
            ->setCodiceFiscale($codiceFiscale)
            ->setDataEvasione($dataEvasione)
            ->setDataRichiesta($dataRichiesta)
            ->setDenominatore($denominatore)
            ->setDenominazione($denominazione)
            ->setEspletabile($espletabile)
            ->setEvasa($evasa)
            ->setFoglio($foglio)
            ->setIndirizzoTrovato($indirizzoTrovato)
            ->setParticella($particella)
            ->setPartita($partita)
            ->setPosizioniImmobiliVisura($posizioniImmobiliVisura)
            ->setScaricata($scaricata)
            ->setSub($sub)
            ->setTicket($ticket)
            ->setTipoPersona($tipoPersona)
            ->setTipoVisura($tipoVisura);
    }
    /**
     * Get codiceFiscale value
     * @return string|null
     */
    public function getCodiceFiscale()
    {
        return $this->codiceFiscale;
    }
    /**
     * Set codiceFiscale value
     * @param string $codiceFiscale
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setCodiceFiscale($codiceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codiceFiscale) && !is_string($codiceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codiceFiscale, true), gettype($codiceFiscale)), __LINE__);
        }
        $this->codiceFiscale = $codiceFiscale;
        return $this;
    }
    /**
     * Get dataEvasione value
     * @return string|null
     */
    public function getDataEvasione()
    {
        return $this->dataEvasione;
    }
    /**
     * Set dataEvasione value
     * @param string $dataEvasione
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setDataEvasione($dataEvasione = null)
    {
        // validation for constraint: string
        if (!is_null($dataEvasione) && !is_string($dataEvasione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEvasione, true), gettype($dataEvasione)), __LINE__);
        }
        $this->dataEvasione = $dataEvasione;
        return $this;
    }
    /**
     * Get dataRichiesta value
     * @return string|null
     */
    public function getDataRichiesta()
    {
        return $this->dataRichiesta;
    }
    /**
     * Set dataRichiesta value
     * @param string $dataRichiesta
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setDataRichiesta($dataRichiesta = null)
    {
        // validation for constraint: string
        if (!is_null($dataRichiesta) && !is_string($dataRichiesta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataRichiesta, true), gettype($dataRichiesta)), __LINE__);
        }
        $this->dataRichiesta = $dataRichiesta;
        return $this;
    }
    /**
     * Get denominatore value
     * @return string|null
     */
    public function getDenominatore()
    {
        return $this->denominatore;
    }
    /**
     * Set denominatore value
     * @param string $denominatore
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setDenominatore($denominatore = null)
    {
        // validation for constraint: string
        if (!is_null($denominatore) && !is_string($denominatore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominatore, true), gettype($denominatore)), __LINE__);
        }
        $this->denominatore = $denominatore;
        return $this;
    }
    /**
     * Get denominazione value
     * @return string|null
     */
    public function getDenominazione()
    {
        return $this->denominazione;
    }
    /**
     * Set denominazione value
     * @param string $denominazione
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setDenominazione($denominazione = null)
    {
        // validation for constraint: string
        if (!is_null($denominazione) && !is_string($denominazione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denominazione, true), gettype($denominazione)), __LINE__);
        }
        $this->denominazione = $denominazione;
        return $this;
    }
    /**
     * Get espletabile value
     * @return bool|null
     */
    public function getEspletabile()
    {
        return $this->espletabile;
    }
    /**
     * Set espletabile value
     * @param bool $espletabile
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setEspletabile($espletabile = null)
    {
        // validation for constraint: boolean
        if (!is_null($espletabile) && !is_bool($espletabile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($espletabile, true), gettype($espletabile)), __LINE__);
        }
        $this->espletabile = $espletabile;
        return $this;
    }
    /**
     * Get evasa value
     * @return bool|null
     */
    public function getEvasa()
    {
        return $this->evasa;
    }
    /**
     * Set evasa value
     * @param bool $evasa
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setEvasa($evasa = null)
    {
        // validation for constraint: boolean
        if (!is_null($evasa) && !is_bool($evasa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($evasa, true), gettype($evasa)), __LINE__);
        }
        $this->evasa = $evasa;
        return $this;
    }
    /**
     * Get foglio value
     * @return string|null
     */
    public function getFoglio()
    {
        return $this->foglio;
    }
    /**
     * Set foglio value
     * @param string $foglio
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setFoglio($foglio = null)
    {
        // validation for constraint: string
        if (!is_null($foglio) && !is_string($foglio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foglio, true), gettype($foglio)), __LINE__);
        }
        $this->foglio = $foglio;
        return $this;
    }
    /**
     * Get indirizzoTrovato value
     * @return string|null
     */
    public function getIndirizzoTrovato()
    {
        return $this->indirizzoTrovato;
    }
    /**
     * Set indirizzoTrovato value
     * @param string $indirizzoTrovato
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setIndirizzoTrovato($indirizzoTrovato = null)
    {
        // validation for constraint: string
        if (!is_null($indirizzoTrovato) && !is_string($indirizzoTrovato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indirizzoTrovato, true), gettype($indirizzoTrovato)), __LINE__);
        }
        $this->indirizzoTrovato = $indirizzoTrovato;
        return $this;
    }
    /**
     * Get particella value
     * @return string|null
     */
    public function getParticella()
    {
        return $this->particella;
    }
    /**
     * Set particella value
     * @param string $particella
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setParticella($particella = null)
    {
        // validation for constraint: string
        if (!is_null($particella) && !is_string($particella)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($particella, true), gettype($particella)), __LINE__);
        }
        $this->particella = $particella;
        return $this;
    }
    /**
     * Get partita value
     * @return string|null
     */
    public function getPartita()
    {
        return $this->partita;
    }
    /**
     * Set partita value
     * @param string $partita
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setPartita($partita = null)
    {
        // validation for constraint: string
        if (!is_null($partita) && !is_string($partita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partita, true), gettype($partita)), __LINE__);
        }
        $this->partita = $partita;
        return $this;
    }
    /**
     * Get posizioniImmobiliVisura value
     * @return \Sisteract\StructType\PosizioneImmobiliVisura_Type[]|null
     */
    public function getPosizioniImmobiliVisura()
    {
        return $this->posizioniImmobiliVisura;
    }
    /**
     * This method is responsible for validating the values passed to the setPosizioniImmobiliVisura method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosizioniImmobiliVisura method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePosizioniImmobiliVisuraForArrayConstraintsFromSetPosizioniImmobiliVisura(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $visuraDaArchivio_TypePosizioniImmobiliVisuraItem) {
            // validation for constraint: itemType
            if (!$visuraDaArchivio_TypePosizioniImmobiliVisuraItem instanceof \Sisteract\StructType\PosizioneImmobiliVisura_Type) {
                $invalidValues[] = is_object($visuraDaArchivio_TypePosizioniImmobiliVisuraItem) ? get_class($visuraDaArchivio_TypePosizioniImmobiliVisuraItem) : sprintf('%s(%s)', gettype($visuraDaArchivio_TypePosizioniImmobiliVisuraItem), var_export($visuraDaArchivio_TypePosizioniImmobiliVisuraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The posizioniImmobiliVisura property can only contain items of type \Sisteract\StructType\PosizioneImmobiliVisura_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set posizioniImmobiliVisura value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PosizioneImmobiliVisura_Type[] $posizioniImmobiliVisura
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setPosizioniImmobiliVisura(array $posizioniImmobiliVisura = array())
    {
        // validation for constraint: array
        if ('' !== ($posizioniImmobiliVisuraArrayErrorMessage = self::validatePosizioniImmobiliVisuraForArrayConstraintsFromSetPosizioniImmobiliVisura($posizioniImmobiliVisura))) {
            throw new \InvalidArgumentException($posizioniImmobiliVisuraArrayErrorMessage, __LINE__);
        }
        $this->posizioniImmobiliVisura = $posizioniImmobiliVisura;
        return $this;
    }
    /**
     * Add item to posizioniImmobiliVisura value
     * @throws \InvalidArgumentException
     * @param \Sisteract\StructType\PosizioneImmobiliVisura_Type $item
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function addToPosizioniImmobiliVisura(\Sisteract\StructType\PosizioneImmobiliVisura_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Sisteract\StructType\PosizioneImmobiliVisura_Type) {
            throw new \InvalidArgumentException(sprintf('The posizioniImmobiliVisura property can only contain items of type \Sisteract\StructType\PosizioneImmobiliVisura_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->posizioniImmobiliVisura[] = $item;
        return $this;
    }
    /**
     * Get scaricata value
     * @return bool|null
     */
    public function getScaricata()
    {
        return $this->scaricata;
    }
    /**
     * Set scaricata value
     * @param bool $scaricata
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setScaricata($scaricata = null)
    {
        // validation for constraint: boolean
        if (!is_null($scaricata) && !is_bool($scaricata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scaricata, true), gettype($scaricata)), __LINE__);
        }
        $this->scaricata = $scaricata;
        return $this;
    }
    /**
     * Get sub value
     * @return string|null
     */
    public function getSub()
    {
        return $this->sub;
    }
    /**
     * Set sub value
     * @param string $sub
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setSub($sub = null)
    {
        // validation for constraint: string
        if (!is_null($sub) && !is_string($sub)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sub, true), gettype($sub)), __LINE__);
        }
        $this->sub = $sub;
        return $this;
    }
    /**
     * Get ticket value
     * @return string|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param string $ticket
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: string
        if (!is_null($ticket) && !is_string($ticket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
    /**
     * Get tipoPersona value
     * @return string|null
     */
    public function getTipoPersona()
    {
        return $this->tipoPersona;
    }
    /**
     * Set tipoPersona value
     * @uses \Sisteract\EnumType\EnumTipoPersona_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoPersona_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPersona
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setTipoPersona($tipoPersona = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoPersona_Type::valueIsValid($tipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoPersona_Type', is_array($tipoPersona) ? implode(', ', $tipoPersona) : var_export($tipoPersona, true), implode(', ', \Sisteract\EnumType\EnumTipoPersona_Type::getValidValues())), __LINE__);
        }
        $this->tipoPersona = $tipoPersona;
        return $this;
    }
    /**
     * Get tipoVisura value
     * @return string|null
     */
    public function getTipoVisura()
    {
        return $this->tipoVisura;
    }
    /**
     * Set tipoVisura value
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoVisura
     * @return \Sisteract\StructType\VisuraDaArchivio_Type
     */
    public function setTipoVisura($tipoVisura = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid($tipoVisura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoVisura_Type', is_array($tipoVisura) ? implode(', ', $tipoVisura) : var_export($tipoVisura, true), implode(', ', \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues())), __LINE__);
        }
        $this->tipoVisura = $tipoVisura;
        return $this;
    }
}
