<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RiferimentoFormalita_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Rappresenta il riferimento per una formalità
 * @subpackage Structs
 */
class RiferimentoFormalita_Type extends AbstractStructBase
{
    /**
     * The anno
     * Meta information extracted from the WSDL
     * - documentation: Ritorna anno della formalità
     * @var int
     */
    public $anno;
    /**
     * The genereFormalita
     * Meta information extracted from the WSDL
     * - documentation: Ritorna genere della formalità
     * @var string
     */
    public $genereFormalita;
    /**
     * The numero
     * Meta information extracted from the WSDL
     * - documentation: Ritorna numero della formalità
     * @var string
     */
    public $numero;
    /**
     * Constructor method for RiferimentoFormalita_Type
     * @uses RiferimentoFormalita_Type::setAnno()
     * @uses RiferimentoFormalita_Type::setGenereFormalita()
     * @uses RiferimentoFormalita_Type::setNumero()
     * @param int $anno
     * @param string $genereFormalita
     * @param string $numero
     */
    public function __construct($anno = null, $genereFormalita = null, $numero = null)
    {
        $this
            ->setAnno($anno)
            ->setGenereFormalita($genereFormalita)
            ->setNumero($numero);
    }
    /**
     * Get anno value
     * @return int|null
     */
    public function getAnno()
    {
        return $this->anno;
    }
    /**
     * Set anno value
     * @param int $anno
     * @return \Sisteract\StructType\RiferimentoFormalita_Type
     */
    public function setAnno($anno = null)
    {
        // validation for constraint: int
        if (!is_null($anno) && !(is_int($anno) || ctype_digit($anno))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anno, true), gettype($anno)), __LINE__);
        }
        $this->anno = $anno;
        return $this;
    }
    /**
     * Get genereFormalita value
     * @return string|null
     */
    public function getGenereFormalita()
    {
        return $this->genereFormalita;
    }
    /**
     * Set genereFormalita value
     * @uses \Sisteract\EnumType\GenereFormalita_Type::valueIsValid()
     * @uses \Sisteract\EnumType\GenereFormalita_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $genereFormalita
     * @return \Sisteract\StructType\RiferimentoFormalita_Type
     */
    public function setGenereFormalita($genereFormalita = null)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\GenereFormalita_Type::valueIsValid($genereFormalita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\GenereFormalita_Type', is_array($genereFormalita) ? implode(', ', $genereFormalita) : var_export($genereFormalita, true), implode(', ', \Sisteract\EnumType\GenereFormalita_Type::getValidValues())), __LINE__);
        }
        $this->genereFormalita = $genereFormalita;
        return $this;
    }
    /**
     * Get numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->numero;
    }
    /**
     * Set numero value
     * @param string $numero
     * @return \Sisteract\StructType\RiferimentoFormalita_Type
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->numero = $numero;
        return $this;
    }
}
