<?php

namespace Sisteract\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnTipoVisuraImmobileList_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Bean che ritorna la lista dei tipi di visure disponibili per gli immobiliInfatti non tutte le visure sono disponibili per gli immobili.
 * @subpackage Structs
 */
class ReturnTipoVisuraImmobileList_Type extends Session_Type
{
    /**
     * The listTipoVisura
     * Meta information extracted from the WSDL
     * - documentation: Lista delle enumerazioni dei tipi di visure disponibiliLa lista contiene i tipi di visure che si possono eseguire sull'immobiole selezionatovalori ammessi
     * ritornati:VISURA_IMMOBILE_SINTETICAVISURA_IMMOBILE_COMPLETAVISURA_IMMOBILE_STORICAVISURA_IMMOBILE_PARTITA
     * - maxOccurs: unbounded
     * - nillable: true
     * @var string[]
     */
    public $listTipoVisura;
    /**
     * The visureDisponibili
     * Meta information extracted from the WSDL
     * - documentation: Indica se sono state trovate visure per l'immobile selezionato
     * @var bool
     */
    public $visureDisponibili;
    /**
     * Constructor method for ReturnTipoVisuraImmobileList_Type
     * @uses ReturnTipoVisuraImmobileList_Type::setListTipoVisura()
     * @uses ReturnTipoVisuraImmobileList_Type::setVisureDisponibili()
     * @param string[] $listTipoVisura
     * @param bool $visureDisponibili
     */
    public function __construct(array $listTipoVisura = array(), $visureDisponibili = null)
    {
        $this
            ->setListTipoVisura($listTipoVisura)
            ->setVisureDisponibili($visureDisponibili);
    }
    /**
     * Get listTipoVisura value
     * @return string[]|null
     */
    public function getListTipoVisura()
    {
        return $this->listTipoVisura;
    }
    /**
     * This method is responsible for validating the values passed to the setListTipoVisura method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListTipoVisura method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListTipoVisuraForArrayConstraintsFromSetListTipoVisura(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnTipoVisuraImmobileList_TypeListTipoVisuraItem) {
            // validation for constraint: enumeration
            if (!\Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid($returnTipoVisuraImmobileList_TypeListTipoVisuraItem)) {
                $invalidValues[] = is_object($returnTipoVisuraImmobileList_TypeListTipoVisuraItem) ? get_class($returnTipoVisuraImmobileList_TypeListTipoVisuraItem) : sprintf('%s(%s)', gettype($returnTipoVisuraImmobileList_TypeListTipoVisuraItem), var_export($returnTipoVisuraImmobileList_TypeListTipoVisuraItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoVisura_Type', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listTipoVisura value
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $listTipoVisura
     * @return \Sisteract\StructType\ReturnTipoVisuraImmobileList_Type
     */
    public function setListTipoVisura(array $listTipoVisura = array())
    {
        // validation for constraint: array
        if ('' !== ($listTipoVisuraArrayErrorMessage = self::validateListTipoVisuraForArrayConstraintsFromSetListTipoVisura($listTipoVisura))) {
            throw new \InvalidArgumentException($listTipoVisuraArrayErrorMessage, __LINE__);
        }
        $this->listTipoVisura = $listTipoVisura;
        return $this;
    }
    /**
     * Add item to listTipoVisura value
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid()
     * @uses \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sisteract\StructType\ReturnTipoVisuraImmobileList_Type
     */
    public function addToListTipoVisura($item)
    {
        // validation for constraint: enumeration
        if (!\Sisteract\EnumType\EnumTipoVisura_Type::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Sisteract\EnumType\EnumTipoVisura_Type', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \Sisteract\EnumType\EnumTipoVisura_Type::getValidValues())), __LINE__);
        }
        $this->listTipoVisura[] = $item;
        return $this;
    }
    /**
     * Get visureDisponibili value
     * @return bool|null
     */
    public function getVisureDisponibili()
    {
        return $this->visureDisponibili;
    }
    /**
     * Set visureDisponibili value
     * @param bool $visureDisponibili
     * @return \Sisteract\StructType\ReturnTipoVisuraImmobileList_Type
     */
    public function setVisureDisponibili($visureDisponibili = null)
    {
        // validation for constraint: boolean
        if (!is_null($visureDisponibili) && !is_bool($visureDisponibili)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visureDisponibili, true), gettype($visureDisponibili)), __LINE__);
        }
        $this->visureDisponibili = $visureDisponibili;
        return $this;
    }
}
